/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.dungeons_iso.api.cullers;

import com.cleannrooster.dungeons_iso.api.BlockCuller;
import com.cleannrooster.dungeons_iso.mod.Mod;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4184;

public class FloodCuller
implements BlockCuller {
    public Stream<class_2338> culledBlocks = Stream.empty();
    List<Class<? extends class_2248>> ignoredTypes = List.of(class_2341.class, class_2323.class);

    @Override
    public boolean shouldForceCull() {
        return true;
    }

    @Override
    public boolean shouldForceNonCull() {
        return false;
    }

    @Override
    public boolean cullBlocks(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity) {
        return false;
    }

    @Override
    public float blockTransparancy(class_2338 pos) {
        return 0.0f;
    }

    public static double angleBetween(class_243 a, class_243 b) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.acos(cosineTheta) * 57.29577951308232;
        return Double.isNaN(angle) ? 0.0 : angle;
    }

    public final class_243 getRotationVec(class_1297 entity, float tickDelta) {
        float f = entity.method_5695(tickDelta) * ((float)Math.PI / 180);
        float g = -entity.method_5791() * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    @Override
    public boolean shouldCull(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity) {
        return cameraEntity.method_37908().method_8320(blockPos).method_26202((class_1922)cameraEntity.method_37908(), blockPos, class_3726.method_16195((class_1297)cameraEntity)).method_1110();
    }

    private static <T, C> T raycast(class_243 start, class_243 end, C context, BiFunction<C, class_2338, T> blockHitFactory, Function<C, T> missFactory) {
        T object2;
        int l;
        int k;
        if (start.equals((Object)end)) {
            return missFactory.apply(context);
        }
        double d = class_3532.method_16436((double)-1.0E-7, (double)end.field_1352, (double)start.field_1352);
        double e = class_3532.method_16436((double)-1.0E-7, (double)end.field_1351, (double)start.field_1351);
        double f = class_3532.method_16436((double)-1.0E-7, (double)end.field_1350, (double)start.field_1350);
        double g = class_3532.method_16436((double)-1.0E-7, (double)start.field_1352, (double)end.field_1352);
        double h = class_3532.method_16436((double)-1.0E-7, (double)start.field_1351, (double)end.field_1351);
        double i = class_3532.method_16436((double)-1.0E-7, (double)start.field_1350, (double)end.field_1350);
        int j = class_3532.method_15357((double)g);
        class_2338.class_2339 mutable = new class_2338.class_2339(j, k = class_3532.method_15357((double)h), l = class_3532.method_15357((double)i));
        T object = blockHitFactory.apply(context, (class_2338)mutable);
        if (object != null) {
            return object;
        }
        double m = d - g;
        double n = e - h;
        double o = f - i;
        int p = class_3532.method_17822((double)m);
        int q = class_3532.method_17822((double)n);
        int r = class_3532.method_17822((double)o);
        double s = p == 0 ? Double.MAX_VALUE : (double)p / m;
        double t = q == 0 ? Double.MAX_VALUE : (double)q / n;
        double u = r == 0 ? Double.MAX_VALUE : (double)r / o;
        double v = s * (p > 0 ? 1.0 - class_3532.method_15385((double)g) : class_3532.method_15385((double)g));
        double w = t * (q > 0 ? 1.0 - class_3532.method_15385((double)h) : class_3532.method_15385((double)h));
        double x = u * (r > 0 ? 1.0 - class_3532.method_15385((double)i) : class_3532.method_15385((double)i));
        do {
            if (!(v <= 1.0 || w <= 1.0 || x <= 1.0)) {
                return missFactory.apply(context);
            }
            if (v < w) {
                if (v < x) {
                    j += p;
                    v += s;
                    continue;
                }
                l += r;
                x += u;
                continue;
            }
            if (w < x) {
                k += q;
                w += t;
                continue;
            }
            l += r;
            x += u;
        } while ((object2 = blockHitFactory.apply(context, (class_2338)mutable.method_10103(j, k, l))) == null);
        return object2;
    }

    @Override
    public boolean shouldIgnoreBlockPick(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity) {
        return false;
    }

    @Override
    public boolean isIgnoredType(class_2248 block) {
        for (Class<? extends class_2248> ignoredType : this.ignoredTypes) {
            if (!ignoredType.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int frequency() {
        return 1;
    }

    @Override
    public List<class_2338> getCulledBlocks(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity) {
        LinkedHashMap<class_2338, Boolean> visited = new LinkedHashMap<class_2338, Boolean>();
        Stack<class_2338> stack = new Stack<class_2338>();
        stack.push(cameraEntity.method_24515().method_10084());
        ArrayList<class_2338> builder = new ArrayList<class_2338>(List.of());
        while (!stack.isEmpty()) {
            class_2338 p = (class_2338)stack.pop();
            int x = p.method_10263();
            int z = p.method_10260();
            builder.add(p);
            if (!p.method_19771((class_2382)cameraEntity.method_24515(), 0.05 * (double)Math.min(20L, Math.min(cameraEntity.method_37908().method_8510() - Mod.startTime, Mod.endTime)) * 16.0)) continue;
            if (!visited.containsKey(p.method_10095()) && this.shouldCull(p.method_10095(), camera, cameraEntity)) {
                stack.push(p.method_10095());
                visited.put(p.method_10095(), true);
                builder.add(p.method_10095());
            }
            if (!visited.containsKey(p.method_10078()) && this.shouldCull(p.method_10078(), camera, cameraEntity)) {
                stack.push(p.method_10078());
                visited.put(p.method_10078(), true);
                builder.add(p.method_10078());
            }
            if (!visited.containsKey(p.method_10067()) && this.shouldCull(p.method_10067(), camera, cameraEntity)) {
                stack.push(p.method_10067());
                visited.put(p.method_10067(), true);
                builder.add(p.method_10067());
            }
            if (visited.containsKey(p.method_10072()) || !this.shouldCull(p.method_10072(), camera, cameraEntity)) continue;
            stack.push(p.method_10072());
            visited.put(p.method_10072(), true);
            builder.add(p.method_10072());
        }
        return builder;
    }

    @Override
    public void resetCulledBlocks() {
    }

    public boolean isAboveFlood(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity, Stream<class_2338> stream) {
        return stream.anyMatch(pos -> blockPos.method_10263() == pos.method_10263() && blockPos.method_10264() > pos.method_10264() && blockPos.method_10260() == pos.method_10260());
    }
}

