/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.dungeons_iso.api.cullers;

import com.cleannrooster.dungeons_iso.api.BlockCuller;
import com.cleannrooster.dungeons_iso.compat.SodiumCompat;
import com.cleannrooster.dungeons_iso.mod.Mod;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;

public class GenericBlockCuller2
implements BlockCuller {
    public List<class_2338> culledBlocks = new ArrayList<class_2338>(1000);
    List<Class<? extends class_2248>> ignoredTypes = List.of(class_2341.class, class_2323.class);

    @Override
    public boolean shouldForceCull() {
        return false;
    }

    @Override
    public boolean shouldForceNonCull() {
        return true;
    }

    @Override
    public boolean cullBlocks(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity) {
        if (this.shouldCull(blockPos, camera, cameraEntity)) {
            if (this.culledBlocks.size() < 1000) {
                this.culledBlocks.add(blockPos);
                BlockCuller.TransparentBlock block = new BlockCuller.TransparentBlock(blockPos, 0.0f);
                SodiumCompat.transparentBlocks.put(blockPos, SodiumCompat.transparentBlocks.getOrDefault(blockPos, block));
            } else {
                this.culledBlocks = new ArrayList<class_2338>(1000);
                SodiumCompat.transparentBlocks = new LinkedHashMap();
                this.culledBlocks.add(blockPos);
                BlockCuller.TransparentBlock block = new BlockCuller.TransparentBlock(blockPos, 0.0f);
                SodiumCompat.transparentBlocks.put(blockPos, SodiumCompat.transparentBlocks.getOrDefault(blockPos, block));
            }
            return true;
        }
        return false;
    }

    @Override
    public float blockTransparancy(class_2338 pos) {
        return 0.0f;
    }

    public static double angleBetween(class_243 a, class_243 b) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.acos(cosineTheta) * 57.29577951308232;
        return Double.isNaN(angle) ? 0.0 : angle;
    }

    @Override
    public boolean shouldCull(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity) {
        if (camera != null && cameraEntity != null) {
            class_243 vec1 = blockPos.method_46558().method_1020(camera.method_19326());
            class_243 vec2 = cameraEntity.method_19538().method_1020(camera.method_19326());
            class_243 vec3 = blockPos.method_46558().method_1020(cameraEntity.method_19538());
            if (cameraEntity instanceof class_1657) {
                class_1657 player = (class_1657)cameraEntity;
                vec1 = vec1.method_1019(player.method_60478().method_1029().method_1021(2.0));
            }
            double calc_theta = GenericBlockCuller2.angleBetween(vec2, vec1);
            double calc_phi = GenericBlockCuller2.angleBetween(vec3, new class_243(0.0, 1.0, 0.0));
            double calc = GenericBlockCuller2.angleBetween(vec3, vec1);
            return !this.isIgnoredType(cameraEntity.method_37908().method_8320(blockPos).method_26204()) && blockPos.method_46558().method_10214() > cameraEntity.method_19538().method_10214() + 1.0 && (calc_theta < 90.0 * Math.pow(0.9, Mod.zoom) || camera.method_19326().method_1022(blockPos.method_46558()) < 5.0);
        }
        return false;
    }

    private static <T, C> T raycast(class_243 start, class_243 end, C context, BiFunction<C, class_2338, T> blockHitFactory, Function<C, T> missFactory) {
        T object2;
        int l;
        int k;
        if (start.equals((Object)end)) {
            return missFactory.apply(context);
        }
        double d = class_3532.method_16436((double)-1.0E-7, (double)end.field_1352, (double)start.field_1352);
        double e = class_3532.method_16436((double)-1.0E-7, (double)end.field_1351, (double)start.field_1351);
        double f = class_3532.method_16436((double)-1.0E-7, (double)end.field_1350, (double)start.field_1350);
        double g = class_3532.method_16436((double)-1.0E-7, (double)start.field_1352, (double)end.field_1352);
        double h = class_3532.method_16436((double)-1.0E-7, (double)start.field_1351, (double)end.field_1351);
        double i = class_3532.method_16436((double)-1.0E-7, (double)start.field_1350, (double)end.field_1350);
        int j = class_3532.method_15357((double)g);
        class_2338.class_2339 mutable = new class_2338.class_2339(j, k = class_3532.method_15357((double)h), l = class_3532.method_15357((double)i));
        T object = blockHitFactory.apply(context, (class_2338)mutable);
        if (object != null) {
            return object;
        }
        double m = d - g;
        double n = e - h;
        double o = f - i;
        int p = class_3532.method_17822((double)m);
        int q = class_3532.method_17822((double)n);
        int r = class_3532.method_17822((double)o);
        double s = p == 0 ? Double.MAX_VALUE : (double)p / m;
        double t = q == 0 ? Double.MAX_VALUE : (double)q / n;
        double u = r == 0 ? Double.MAX_VALUE : (double)r / o;
        double v = s * (p > 0 ? 1.0 - class_3532.method_15385((double)g) : class_3532.method_15385((double)g));
        double w = t * (q > 0 ? 1.0 - class_3532.method_15385((double)h) : class_3532.method_15385((double)h));
        double x = u * (r > 0 ? 1.0 - class_3532.method_15385((double)i) : class_3532.method_15385((double)i));
        do {
            if (!(v <= 1.0 || w <= 1.0 || x <= 1.0)) {
                return missFactory.apply(context);
            }
            if (v < w) {
                if (v < x) {
                    j += p;
                    v += s;
                    continue;
                }
                l += r;
                x += u;
                continue;
            }
            if (w < x) {
                k += q;
                w += t;
                continue;
            }
            l += r;
            x += u;
        } while ((object2 = blockHitFactory.apply(context, (class_2338)mutable.method_10103(j, k, l))) == null);
        return object2;
    }

    @Override
    public boolean shouldIgnoreBlockPick(class_2338 blockPos, class_4184 camera, class_1297 cameraEntity) {
        if (!this.isIgnoredType(cameraEntity.method_37908().method_8320(blockPos).method_26204()) && blockPos != null && cameraEntity instanceof class_1657) {
            class_1657 player = (class_1657)cameraEntity;
            if (blockPos.method_46558().method_1022(cameraEntity.method_33571()) > player.method_55754() && blockPos.method_46558().method_10214() > cameraEntity.method_23318() + 1.0) {
                class_243 class_2432 = new class_243(0.0, 1.0, 0.0);
                if (class_2432.method_1026(blockPos.method_46558().method_1020(cameraEntity.method_19538()).method_1029()) > 0.5) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isIgnoredType(class_2248 block) {
        for (Class<? extends class_2248> ignoredType : this.ignoredTypes) {
            if (!ignoredType.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int frequency() {
        return 1;
    }

    @Override
    public void resetCulledBlocks() {
    }
}

