/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.Config;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigLoader;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigurationException;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.Element;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.StartupProgressBarConfig;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements.ApngTextureElement;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements.StartupProgressBar;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements.StaticTextureElement;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefDisplayWindow;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.RefEarlyFrameBuffer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.minecraftforge.fml.earlydisplay.ColourScheme;
import net.minecraftforge.fml.earlydisplay.DisplayWindow;
import net.minecraftforge.fml.earlydisplay.EarlyFramebuffer;
import net.minecraftforge.fml.earlydisplay.RenderElement;
import net.minecraftforge.fml.earlydisplay.SimpleFont;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.ImmediateWindowProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11C;

public class SimpleCustomEarlyLoadingWindow
extends DisplayWindow
implements ImmediateWindowProvider {
    public static final String WINDOW_PROVIDER = "SimpleCustomEarlyLoading";
    private static final Logger LOG = LogManager.getLogger();
    private final RefDisplayWindow accessor = new RefDisplayWindow(this);
    private final Config configuration;

    public SimpleCustomEarlyLoadingWindow() {
        SimpleCustomEarlyLoadingWindow.checkFMLConfig();
        ConfigLoader.copyDefaultConfig();
        this.configuration = ConfigLoader.loadConfiguration();
    }

    private static void checkFMLConfig() {
        String windowProvider = FMLConfig.getConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER);
        if (!WINDOW_PROVIDER.equals(windowProvider)) {
            JFrame frame = new JFrame("Missing Forge configuration");
            frame.setAlwaysOnTop(true);
            frame.setDefaultCloseOperation(2);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            int answer = JOptionPane.showConfirmDialog(frame, "You have installed the Simple Custom Early Loading mod,\nbut the early window provider is not set to WINDOW_PROVIDER in the fml.toml config!\nPlease update the config and restart the game.\nSee mod description for instructions.\nhttps://github.com/lukaskabc/SimpleCustomEarlyLoading\n\nDo you wish to update the config?\nAnswering yes will update the config and exit the game.\n".replace("WINDOW_PROVIDER", WINDOW_PROVIDER), "Missing NeoForge configuration", 0, 3);
            frame.dispose();
            if (answer == 0) {
                FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER, (Object)WINDOW_PROVIDER);
                System.exit(0);
            }
        }
    }

    private Supplier<RenderElement> constructElement(Element element) {
        if (ApngTextureElement.SUPPORTED_EXTENSIONS.contains(element.getExtension())) {
            return new ApngTextureElement(element.getImage(), element.getPosition());
        }
        if (StaticTextureElement.SUPPORTED_EXTENSIONS.contains(element.getExtension())) {
            return new StaticTextureElement(element.getImage(), element.getPosition());
        }
        throw new ConfigurationException("Unsupported image extension: " + element.getExtension());
    }

    private void constructElements(List<RenderElement> elements) {
        SimpleFont font = this.accessor.getFont();
        RenderElement anvil = elements.get(0);
        RenderElement logMessageOverlay = elements.get(1);
        RenderElement forgeVersionOverlay = elements.get(2);
        elements.clear();
        Optional.ofNullable(this.configuration.getElements()).ifPresent(list -> list.forEach(el -> elements.add(this.constructElement((Element)el).get())));
        Optional.ofNullable(this.configuration.getProgressBar()).ifPresent(barConfig -> elements.add(new StartupProgressBar(font, (StartupProgressBarConfig)barConfig).get()));
        if (this.configuration.isPerformanceBar()) {
            elements.add(RenderElement.performanceBar((SimpleFont)font));
        }
        if (this.configuration.isAnvil()) {
            elements.add(anvil);
        }
        if (this.configuration.isLogMessages()) {
            elements.add(logMessageOverlay);
        }
        if (this.configuration.isForgeVersion()) {
            elements.add(forgeVersionOverlay);
        }
    }

    public String name() {
        return WINDOW_PROVIDER;
    }

    public Runnable initialize(String[] arguments) {
        Runnable result = super.initialize(arguments);
        this.accessor.setColourScheme(ColourScheme.BLACK);
        return result;
    }

    public Runnable start(String mcVersion, String forgeVersion) {
        ScheduledExecutorService renderScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.accessor.setRenderScheduler(renderScheduler);
        this.initWindow(mcVersion);
        ScheduledFuture<?> initializationFuture = renderScheduler.schedule(() -> {
            this.accessor.initRender(mcVersion, forgeVersion);
            this.afterInitRender();
        }, 1L, TimeUnit.MILLISECONDS);
        this.accessor.setInitializationFuture(initializationFuture);
        return () -> ((SimpleCustomEarlyLoadingWindow)this).periodicTick();
    }

    public void afterInitRender() {
        GLFW.glfwMakeContextCurrent((long)this.accessor.getGlWindow());
        ColourScheme colourScheme = this.accessor.getColourScheme();
        GL11C.glClearColor((float)colourScheme.background().redf(), (float)colourScheme.background().greenf(), (float)colourScheme.background().bluef(), (float)1.0f);
        this.recreateContext();
        List<RenderElement> elements = this.accessor.getElements();
        this.constructElements(elements);
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    public void updateModuleReads(ModuleLayer layer) {
        Module fm = layer.findModule("forge").orElseThrow();
        ((Object)((Object)this)).getClass().getModule().addReads(fm);
        Class clz = FMLLoader.getGameLayer().findModule("forge").map(l -> Class.forName(l, "net.minecraftforge.client.loading.ForgeLoadingOverlay")).orElseThrow();
        Map methods = Arrays.stream(clz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toMap(Method::getName, Function.identity()));
        this.accessor.setLoadingOverlay((Method)methods.get("newInstance"));
    }

    public void addMojangTexture(int textureId) {
        this.accessor.getElements().add(RenderElement.mojang((int)textureId, (int)this.accessor.getFrameCount()));
    }

    private void recreateContext() {
        RenderElement.DisplayContext oldContext = this.accessor.getContext();
        EarlyFramebuffer oldFrameBuffer = this.accessor.getFramebuffer();
        int[] width = new int[1];
        int[] height = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.accessor.getGlWindow(), (int[])width, (int[])height);
        this.accessor.setFBSize(width[0], height[0]);
        LOG.debug("The available size of the framebuffer in the window is {}x{}", (Object)width[0], (Object)height[0]);
        if (this.configuration.getResolutionWidth() > 0 && this.configuration.getResolutionHeight() > 0) {
            width[0] = this.configuration.getResolutionWidth();
            height[0] = this.configuration.getResolutionHeight();
        }
        RenderElement.DisplayContext context = new RenderElement.DisplayContext(width[0], height[0], oldContext.scale(), oldContext.elementShader(), this.accessor.getColourScheme(), oldContext.performance());
        this.accessor.setContext(context);
        this.accessor.setFrameBuffer(RefEarlyFrameBuffer.constructor(context));
        RefEarlyFrameBuffer.close(oldFrameBuffer);
    }
}

