/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.Config;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class ConfigLoader {
    private static final String STARGATE_VARIANT_CONFIG_DIRECTORY = "simple-custom-early-loading";
    private static final String DEFAULT_CONFIG_FILE = "/default_config.json";
    private static final String CONFIG_FILE_NAME = "simple-custom-early-loading.json";
    private static final Logger LOG = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    private ConfigLoader() {
        throw new AssertionError();
    }

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().resolve(STARGATE_VARIANT_CONFIG_DIRECTORY);
    }

    private static Path getConfigFilePath() {
        return FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE_NAME).toAbsolutePath();
    }

    public static void copyDefaultConfig() {
        if (!Files.exists(ConfigLoader.getConfigFilePath(), new LinkOption[0])) {
            LOG.atDebug().log("Creating default config file {}", (Object)ConfigLoader.getConfigFilePath());
            try (InputStream defaultConfig = ConfigLoader.class.getResourceAsStream(DEFAULT_CONFIG_FILE);){
                if (defaultConfig == null) {
                    throw new ConfigurationException("Could not find default config file: /default_config.json");
                }
                Files.copy(defaultConfig, ConfigLoader.getConfigFilePath(), new CopyOption[0]);
                LOG.atDebug().log("Config file successfully created");
            }
            catch (IOException e) {
                LOG.atError().log("Failed to create default config file: {}", (Object)e.getMessage());
                throw new ConfigurationException(e);
            }
        }
    }

    public static Config loadConfiguration() {
        LOG.atDebug().log("Loading configuration from {}", (Object)ConfigLoader.getConfigFilePath());
        try {
            return (Config)GSON.fromJson((Reader)new FileReader(ConfigLoader.getConfigFilePath().toFile()), Config.class);
        }
        catch (JsonParseException | FileNotFoundException e) {
            LOG.atError().log("Failed to load configuration from {}\nError:{}", (Object)ConfigLoader.getConfigFilePath(), (Object)e.getMessage());
            throw new ConfigurationException(e);
        }
    }

    private static void fileSize(int @Nullable [] size, Path path) {
        try {
            ConfigLoader.safeLongToInt(size, Files.size(path));
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    private static void safeLongToInt(int @Nullable [] size, long value) {
        if (size == null) {
            return;
        }
        try {
            size[0] = Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            LOG.error("File size is too big: {}. Max integer size is {}", (Object)value, (Object)Integer.MAX_VALUE);
            throw new ConfigurationException(e);
        }
    }

    private static void fileSize(int @Nullable [] size, byte[] data) {
        ConfigLoader.safeLongToInt(size, data.length);
    }

    public static InputStream resolveFile(Path path, int @Nullable [] size) throws FileNotFoundException {
        Path imagePath;
        if (path.startsWith("/") || path.startsWith("\\")) {
            path = Path.of(path.toString().substring(1), new String[0]);
        }
        if (Files.exists(imagePath = ConfigLoader.getConfigDirectory().resolve(path), new LinkOption[0])) {
            ConfigLoader.fileSize(size, imagePath);
            return new FileInputStream(imagePath.toFile());
        }
        String classPath = "/" + path.toString().replace('\\', '/');
        try {
            byte[] data = Objects.requireNonNull(ConfigLoader.class.getResourceAsStream(classPath)).readAllBytes();
            ConfigLoader.fileSize(size, data);
            return new ByteArrayInputStream(data);
        }
        catch (IOException | NullPointerException e) {
            LOG.error("Failed to resolve file: {}", (Object)imagePath);
            throw new FileNotFoundException("File not found: " + String.valueOf(imagePath));
        }
    }
}

