/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.BoundsResolver;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigurationException;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.element_anchor.ElementAnchor;
import org.jspecify.annotations.Nullable;

public class ElementPosition
implements BoundsResolver {
    private ElementAnchor positionAnchor = ElementAnchor.CENTER;
    private Unit positionUnit = Unit.PIXELS;
    private @Nullable Unit positionUnitX = null;
    private @Nullable Unit positionUnitY = null;
    private Unit sizeUnit = Unit.PIXELS;
    private float x = 0.0f;
    private float y = 0.0f;
    private float width = Float.NaN;
    private float height = Float.NaN;

    public boolean hasWidth() {
        return Float.isFinite(this.width);
    }

    public void validate() {
        if (!this.hasHeight() && !this.hasWidth()) {
            throw new ConfigurationException("Element position must have either width or height set");
        }
    }

    public int getSafeWidth(int elementTextureWidth, int elementTextureHeight) {
        if (this.hasWidth()) {
            return (int)this.width;
        }
        return (int)(this.height * (float)elementTextureWidth / (float)elementTextureHeight);
    }

    public int getSafeHeight(int elementTextureWidth, int elementTextureHeight) {
        if (this.hasHeight()) {
            return (int)this.height;
        }
        return (int)(this.width * (float)elementTextureHeight / (float)elementTextureWidth);
    }

    public int getRelativeWidth(int elementTextureWidth, int elementTextureHeight, int screenWidth, int screenHeight) {
        if (this.hasWidth()) {
            return (int)(this.width * (float)screenWidth / 100.0f);
        }
        return Math.round(this.height * (float)screenHeight / 100.0f * ((float)elementTextureWidth / (float)elementTextureHeight));
    }

    public int getRelativeHeight(int elementTextureWidth, int elementTextureHeight, int screenWidth, int screenHeight) {
        if (this.hasHeight()) {
            return (int)(this.height * (float)screenHeight / 100.0f);
        }
        return Math.round(this.width * (float)screenWidth / 100.0f * ((float)elementTextureHeight / (float)elementTextureWidth));
    }

    private void resolveSize(int elementWidth, int elementHeight, int screenWidth, int screenHeight, int[] output) {
        assert (output.length >= 4);
        output[2] = this.getSafeWidth(elementWidth, elementHeight);
        output[3] = this.getSafeHeight(elementWidth, elementHeight);
        if (this.sizeUnit == Unit.PERCENTAGE) {
            output[2] = this.getRelativeWidth(elementWidth, elementHeight, screenWidth, screenHeight);
            output[3] = this.getRelativeHeight(elementWidth, elementHeight, screenWidth, screenHeight);
        } else if (this.sizeUnit != Unit.PIXELS) {
            throw new ConfigurationException("Invalid size unit: " + String.valueOf((Object)this.sizeUnit));
        }
    }

    @Override
    public int[] resolveBounds(int elementWidth, int elementHeight, int screenWidth, int screenHeight) {
        this.validate();
        int[] position = new int[4];
        this.resolveSize(elementWidth, elementHeight, screenWidth, screenHeight, position);
        position[0] = this.getPositionUnitX() == Unit.PERCENTAGE ? (int)(this.x * (float)screenWidth / 100.0f) : (int)this.x;
        position[1] = this.getPositionUnitY() == Unit.PERCENTAGE ? (int)(this.y * (float)screenHeight / 100.0f) : (int)this.y;
        return this.positionAnchor.apply(position[0], position[1], position[2], position[3]);
    }

    public boolean hasHeight() {
        return Float.isFinite(this.height);
    }

    public Unit getPositionUnitX() {
        if (this.positionUnitX == null) {
            return this.positionUnit;
        }
        return this.positionUnitX;
    }

    public void setPositionUnitX(@Nullable Unit positionUnitX) {
        this.positionUnitX = positionUnitX;
    }

    public Unit getPositionUnitY() {
        if (this.positionUnitY == null) {
            return this.positionUnit;
        }
        return this.positionUnitY;
    }

    public void setPositionUnitY(@Nullable Unit positionUnitY) {
        this.positionUnitY = positionUnitY;
    }

    public Unit getPositionUnit() {
        return this.positionUnit;
    }

    public void setPositionUnit(Unit positionUnit) {
        this.positionUnit = positionUnit;
    }

    public Unit getSizeUnit() {
        return this.sizeUnit;
    }

    public void setSizeUnit(Unit sizeUnit) {
        this.sizeUnit = sizeUnit;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public ElementAnchor getPositionAnchor() {
        return this.positionAnchor;
    }

    public void setPositionAnchor(ElementAnchor positionAnchor) {
        this.positionAnchor = positionAnchor;
    }

    public static enum Unit {
        PIXELS,
        PERCENTAGE;

    }
}

