/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.BoundsResolver;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.config.ConfigurationException;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.elements.ElementSupplier;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.helper.StaticSTBHelper;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.CSB;
import java.io.FileNotFoundException;
import java.util.Set;
import net.minecraftforge.fml.earlydisplay.ElementShader;
import net.minecraftforge.fml.earlydisplay.QuadHelper;
import net.minecraftforge.fml.earlydisplay.SimpleBufferBuilder;
import org.jline.utils.Log;
import org.lwjgl.opengl.GL32C;

public class StaticTextureElement
implements ElementSupplier {
    public static final Set<String> SUPPORTED_EXTENSIONS = Set.of("jpg", "jpeg", "png", "tga", "bmp", "psd", "gif", "hdr", "pic", "pnm");
    public static final int COLOR = -1;
    private final int[] textureSize;
    private final int textureId;
    private final BoundsResolver boundsResolver;

    public StaticTextureElement(String texture, BoundsResolver boundsResolver) {
        int[] textureWidth = new int[1];
        int[] textureHeight = new int[1];
        this.boundsResolver = boundsResolver;
        try {
            this.textureId = StaticSTBHelper.resolveAndBindTexture(texture, textureWidth, textureHeight);
        }
        catch (FileNotFoundException e) {
            Log.error((Object[])new Object[]{"Failed to load texture: ", e.getMessage()});
            throw new ConfigurationException(e);
        }
        this.textureSize = new int[]{textureWidth[0], textureHeight[0]};
    }

    @Override
    public void render(CSB csb, int frame) {
        int[] bounds = this.boundsResolver.resolveBounds(this.textureSize[0], this.textureSize[1], csb.ctx().scaledWidth(), csb.ctx().scaledHeight());
        csb.ctx().elementShader().updateTextureUniform(0);
        csb.ctx().elementShader().updateRenderTypeUniform(ElementShader.RenderType.TEXTURE);
        GL32C.glBindTexture((int)3553, (int)this.textureId);
        csb.buffer().begin(SimpleBufferBuilder.Format.POS_TEX_COLOR, SimpleBufferBuilder.Mode.QUADS);
        QuadHelper.loadQuad((SimpleBufferBuilder)csb.buffer(), (float)bounds[0], (float)bounds[2], (float)bounds[1], (float)bounds[3], (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (int)-1);
        csb.buffer().draw();
        GL32C.glBindTexture((int)3553, (int)0);
    }
}

