/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection;

import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.CSB;
import cz.lukaskabc.minecraft.mod_loader.loading.simple_custom_early_loading.reflection.TextureRenderer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.minecraftforge.fml.earlydisplay.RenderElement;
import net.minecraftforge.fml.earlydisplay.SimpleBufferBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererProxy
implements InvocationHandler {
    private static final Logger LOG = LogManager.getLogger();
    private final TextureRenderer textureRenderer;

    public RendererProxy(TextureRenderer textureRenderer) {
        this.textureRenderer = textureRenderer;
    }

    @Override
    public Object invoke(Object renderProxy, Method renderMethod, Object[] renderArgs) throws Throwable {
        if (renderMethod.getName().equals("accept")) {
            SimpleBufferBuilder bb = (SimpleBufferBuilder)renderArgs[0];
            RenderElement.DisplayContext ctx = (RenderElement.DisplayContext)renderArgs[1];
            int frame = (Integer)renderArgs[2];
            try {
                this.textureRenderer.accept(new CSB(ctx, bb), frame);
            }
            catch (Throwable t) {
                LOG.error("Early loading rendering exception", t);
                System.exit(1);
                LOG.error("An exception occurred during early loading rendering, the game will exit immediately. No crash report will be generated!");
                throw new RuntimeException(t);
            }
            return null;
        }
        if (!renderMethod.canAccess(renderProxy)) {
            renderMethod.setAccessible(true);
        }
        return renderMethod.invoke(renderProxy, renderArgs);
    }
}

