/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888;

import cz.lukaskabc.minecraft.mod_loader.shaded.japng.PngChunkCode;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.PngScanlineBuffer;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888Director;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888Palette;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888ScanlineProcessor;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngAnimationControl;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngFrameControl;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngGamma;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngHeader;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngException;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngIntegrityException;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.map.PngChunkMap;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.reader.PngChunkProcessor;
import java.io.IOException;
import java.io.InputStream;

public class Argb8888Processor<ResultT>
implements PngChunkProcessor<ResultT> {
    protected PngHeader header = null;
    protected PngScanlineBuffer scanlineReader = null;
    protected Argb8888Director<ResultT> builder = null;
    protected Argb8888ScanlineProcessor scanlineProcessor = null;

    public Argb8888Processor(Argb8888Director<ResultT> builder) {
        this.builder = builder;
    }

    @Override
    public void processHeader(PngHeader header) throws PngException {
        this.header = header;
        this.scanlineReader = PngScanlineBuffer.from(header);
        this.builder.receiveHeader(this.header, this.scanlineReader);
    }

    @Override
    public void processGamma(PngGamma gamma) throws PngException {
    }

    @Override
    public void processPalette(byte[] bytes, int position, int length) throws PngException {
        this.builder.receivePalette(Argb8888Palette.fromPaletteBytes(bytes, position, length));
    }

    @Override
    public void processTransparency(byte[] bytes, int position, int length) throws PngException {
        switch (this.header.colourType) {
            case PNG_GREYSCALE: {
                if (length != 2) {
                    throw new PngIntegrityException(String.format("tRNS chunk for greyscale image must be exactly length=2, not %d", length));
                }
                this.builder.processTransparentGreyscale(bytes[0], bytes[1]);
                break;
            }
            case PNG_TRUECOLOUR: {
                this.builder.processTransparentTruecolour(bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5]);
                break;
            }
            case PNG_INDEXED_COLOUR: {
                this.builder.processTransparentPalette(bytes, position, length);
                break;
            }
            default: {
                throw new PngIntegrityException("Illegal to have tRNS chunk with image type " + this.header.colourType.name);
            }
        }
    }

    @Override
    public void processDefaultImageData(InputStream inputStream, PngChunkCode code, int position, int length) throws IOException, PngException {
        if (!this.builder.wantDefaultImage()) {
            inputStream.skip(length);
            return;
        }
        if (null == this.scanlineProcessor) {
            this.scanlineProcessor = this.builder.beforeDefaultImage();
            if (null == this.scanlineProcessor) {
                throw new IllegalStateException("Builder must create scanline processor");
            }
        }
        if (this.scanlineReader.decompress(inputStream, this.scanlineProcessor)) {
            this.builder.receiveDefaultImage(this.scanlineProcessor.getBitmap());
            this.scanlineProcessor = null;
            this.scanlineReader.reset();
        }
    }

    @Override
    public void processAnimationControl(PngAnimationControl animationControl) throws PngException {
        if (this.builder.wantAnimationFrames()) {
            this.builder.receiveAnimationControl(animationControl);
        }
    }

    @Override
    public void processFrameControl(PngFrameControl frameControl) throws PngException {
        if (!this.builder.wantAnimationFrames()) {
            return;
        }
        if (null == this.scanlineProcessor) {
            this.scanlineProcessor = this.builder.receiveFrameControl(frameControl);
            if (null == this.scanlineProcessor) {
                throw new IllegalStateException("Builder must create scanline processor for frame");
            }
        } else {
            throw new IllegalStateException("received animation frame control but image data was in progress");
        }
    }

    @Override
    public void processFrameImageData(InputStream inputStream, PngChunkCode code, int position, int length) throws IOException, PngException {
        if (!this.builder.wantAnimationFrames()) {
            inputStream.skip(length);
            return;
        }
        if (null == this.scanlineProcessor) {
            throw new IllegalStateException("received animation frame image data before frame control or without processor in place");
        }
        if (this.scanlineReader.decompress(inputStream, this.scanlineProcessor)) {
            this.builder.receiveFrameImage(this.scanlineProcessor.getBitmap());
            this.scanlineReader.reset();
            this.scanlineProcessor = null;
        }
    }

    @Override
    public void processChunkMapItem(PngChunkMap chunkMapItem) throws PngException {
    }

    @Override
    public ResultT getResult() {
        return this.builder.getResult();
    }
}

