/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888;

import cz.lukaskabc.minecraft.mod_loader.shaded.japng.PngConstants;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.PngScanlineBuffer;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888Bitmap;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888Palette;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.argb8888.Argb8888ScanlineProcessor;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.chunks.PngHeader;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngException;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngFeatureException;
import cz.lukaskabc.minecraft.mod_loader.shaded.japng.error.PngIntegrityException;

public class Argb8888Processors {
    public static Argb8888ScanlineProcessor from(PngHeader header, PngScanlineBuffer scanlineReader, Argb8888Bitmap bitmap) throws PngException {
        int bytesPerScanline = header.bytesPerRow;
        switch (header.colourType) {
            case PNG_GREYSCALE: {
                switch (header.bitDepth) {
                    case 1: {
                        return new IndexedColourBits(bytesPerScanline, bitmap, 7, 1, PngConstants.SHIFTS_1, Argb8888Palette.forGreyscale(1));
                    }
                    case 2: {
                        return new IndexedColourBits(bytesPerScanline, bitmap, 3, 3, PngConstants.SHIFTS_2, Argb8888Palette.forGreyscale(2));
                    }
                    case 4: {
                        return new IndexedColourBits(bytesPerScanline, bitmap, 1, 15, PngConstants.SHIFTS_4, Argb8888Palette.forGreyscale(4));
                    }
                    case 8: {
                        return new Greyscale8(bytesPerScanline, bitmap);
                    }
                    case 16: {
                        throw new PngFeatureException("Greyscale supports 1, 2, 4, 8 but not 16.");
                    }
                }
                throw new PngIntegrityException(String.format("Invalid greyscale bit-depth: %d", header.bitDepth));
            }
            case PNG_GREYSCALE_WITH_ALPHA: {
                switch (header.bitDepth) {
                    case 4: {
                        return new Greyscale4Alpha(bytesPerScanline, bitmap);
                    }
                    case 8: {
                        return new Greyscale8Alpha(bytesPerScanline, bitmap);
                    }
                    case 16: {
                        return new Greyscale16Alpha(bytesPerScanline, bitmap);
                    }
                }
                throw new PngIntegrityException(String.format("Invalid greyscale-with-alpha bit-depth: %d", header.bitDepth));
            }
            case PNG_INDEXED_COLOUR: {
                switch (header.bitDepth) {
                    case 1: {
                        return new IndexedColourBits(bytesPerScanline, bitmap, 7, 1, PngConstants.SHIFTS_1);
                    }
                    case 2: {
                        return new IndexedColourBits(bytesPerScanline, bitmap, 3, 3, PngConstants.SHIFTS_2);
                    }
                    case 4: {
                        return new IndexedColourBits(bytesPerScanline, bitmap, 1, 15, PngConstants.SHIFTS_4);
                    }
                    case 8: {
                        return new IndexedColour8(bytesPerScanline, bitmap);
                    }
                }
                throw new PngIntegrityException(String.format("Invalid indexed colour bit-depth: %d", header.bitDepth));
            }
            case PNG_TRUECOLOUR: {
                switch (header.bitDepth) {
                    case 8: {
                        return new Truecolour8(bytesPerScanline, bitmap);
                    }
                    case 16: {
                        return new Truecolour16(bytesPerScanline, bitmap);
                    }
                }
                throw new PngIntegrityException(String.format("Invalid truecolour bit-depth: %d", header.bitDepth));
            }
            case PNG_TRUECOLOUR_WITH_ALPHA: {
                switch (header.bitDepth) {
                    case 8: {
                        return new Truecolour8Alpha(bytesPerScanline, bitmap);
                    }
                    case 16: {
                        return new Truecolour16Alpha(bytesPerScanline, bitmap);
                    }
                }
                throw new PngIntegrityException(String.format("Invalid truecolour with alpha bit-depth: %d", header.bitDepth));
            }
        }
        throw new PngFeatureException("ARGB8888 doesn't support PNG mode " + header.colourType.name());
    }

    public static class Truecolour16Alpha
    extends Argb8888ScanlineProcessor {
        public Truecolour16Alpha(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int r = 0xFF & srcBytes[srcPosition];
                int g = 0xFF & srcBytes[srcPosition += 2];
                int b = 0xFF & srcBytes[srcPosition += 2];
                int alpha = 0xFF & srcBytes[srcPosition += 2];
                srcPosition += 2;
                int c = alpha << 24 | r << 16 | g << 8 | b;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Truecolour16(bytesPerRow, bitmap);
        }
    }

    public static class Truecolour16
    extends Argb8888ScanlineProcessor {
        public Truecolour16(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int alpha = -16777216;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int r = 0xFF & srcBytes[srcPosition];
                int g = 0xFF & srcBytes[srcPosition += 2];
                int b = 0xFF & srcBytes[srcPosition += 2];
                srcPosition += 2;
                int c = 0xFF000000 | r << 16 | g << 8 | b;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Truecolour16(bytesPerRow, bitmap);
        }
    }

    public static class Truecolour8Alpha
    extends Argb8888ScanlineProcessor {
        public Truecolour8Alpha(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int r = 0xFF & srcBytes[srcPosition++];
                int g = 0xFF & srcBytes[srcPosition++];
                int b = 0xFF & srcBytes[srcPosition++];
                int a = 0xFF & srcBytes[srcPosition++];
                int c = a << 24 | r << 16 | g << 8 | b;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Truecolour8Alpha(bytesPerRow, bitmap);
        }
    }

    public static class Truecolour8
    extends Argb8888ScanlineProcessor {
        public Truecolour8(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int alpha = -16777216;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int r = 0xFF & srcBytes[srcPosition++];
                int g = 0xFF & srcBytes[srcPosition++];
                int b = 0xFF & srcBytes[srcPosition++];
                int c = 0xFF000000 | r << 16 | g << 8 | b;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Truecolour8(bytesPerRow, bitmap);
        }
    }

    public static class Greyscale16Alpha
    extends Argb8888ScanlineProcessor {
        public Greyscale16Alpha(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int k = 0xFF & srcBytes[srcPosition++];
                int n = ++srcPosition;
                ++srcPosition;
                int a = 0xFF & srcBytes[n];
                ++srcPosition;
                int c = a << 24 | k << 16 | k << 8 | k;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Greyscale16Alpha(bytesPerRow, bitmap);
        }
    }

    public static class Greyscale8Alpha
    extends Argb8888ScanlineProcessor {
        public Greyscale8Alpha(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int k = 0xFF & srcBytes[srcPosition++];
                int a = 0xFF & srcBytes[srcPosition++];
                int c = a << 24 | k << 16 | k << 8 | k;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Greyscale8Alpha(bytesPerRow, bitmap);
        }
    }

    public static class Greyscale8
    extends Argb8888ScanlineProcessor {
        boolean haveTransparent = false;
        int transparentSample = 0;

        public Greyscale8(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int alpha = -16777216;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int sample = 0xFF & srcBytes[srcPosition++];
                int k = this.haveTransparent && sample == this.transparentSample ? this.transparentSample : sample;
                int c = 0xFF000000 | k << 16 | k << 8 | k;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public void processTransparentGreyscale(byte k1, byte k0) {
            this.haveTransparent = true;
            this.transparentSample = 0xFF & k0;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Greyscale8(bytesPerRow, bitmap);
        }
    }

    public static class Greyscale4Alpha
    extends Argb8888ScanlineProcessor {
        public Greyscale4Alpha(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                byte v = srcBytes[srcPosition++];
                byte k = PngConstants.GREY_PALETTE_16[0xF & v >> 4];
                byte a = PngConstants.GREY_PALETTE_16[0xF & v];
                int c = a << 24 | k << 16 | k << 8 | k;
                destArray[writePosition++] = c;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new Greyscale4Alpha(bytesPerRow, bitmap);
        }
    }

    public static class IndexedColour8
    extends Argb8888ScanlineProcessor {
        public IndexedColour8(int bytesPerScanline, Argb8888Bitmap bitmap) {
            super(bytesPerScanline, bitmap);
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int writePosition = this.y * width;
            for (int x = 0; x < width; ++x) {
                int index = 0xFF & srcBytes[srcPosition++];
                int dest = this.palette != null ? this.palette.argbArray[index] : 0;
                destArray[writePosition++] = dest;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new IndexedColour8(bytesPerRow, bitmap);
        }
    }

    public static class IndexedColourBits
    extends Argb8888ScanlineProcessor {
        private int highBit;
        private int mask;
        private byte[] shifts;

        public IndexedColourBits(int bytesPerScanline, Argb8888Bitmap bitmap, int highBit, int mask, byte[] shifts) {
            this(bytesPerScanline, bitmap, highBit, mask, shifts, null);
        }

        public IndexedColourBits(int bytesPerScanline, Argb8888Bitmap bitmap, int highBit, int mask, byte[] shifts, Argb8888Palette palette) {
            super(bytesPerScanline, bitmap);
            this.highBit = highBit;
            this.mask = mask;
            this.shifts = shifts;
            this.palette = palette;
        }

        @Override
        public void processScanline(byte[] srcBytes, int srcPosition) {
            int[] destArray = this.bitmap.array;
            int width = this.bitmap.width;
            int writePosition = this.y * width;
            int lastWritePosition = writePosition + width;
            int bit = this.highBit;
            while (writePosition < lastWritePosition) {
                int index = this.mask & srcBytes[srcPosition] >> this.shifts[bit];
                int dest = this.palette != null ? this.palette.argbArray[index] : 0;
                destArray[writePosition++] = dest;
                if (bit == 0) {
                    ++srcPosition;
                    bit = this.highBit;
                    continue;
                }
                --bit;
            }
            ++this.y;
        }

        @Override
        public Argb8888ScanlineProcessor clone(int bytesPerRow, Argb8888Bitmap bitmap) {
            return new IndexedColourBits(bytesPerRow, bitmap, this.highBit, this.mask, this.shifts, this.palette);
        }
    }
}

