/*
 * Decompiled with CFR 0.152.
 */
package cz.lukaskabc.minecraft.mod_loader.shaded.japng.util;

import java.io.IOException;
import java.io.InputStream;

public class InputStreamSlice
extends InputStream {
    protected final InputStream src;
    protected final int length;
    protected int position = 0;
    protected boolean atEof = false;

    public InputStreamSlice(InputStream src, int length) {
        this.src = src;
        this.length = length;
    }

    public int tell() {
        return this.position;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.atEof || this.position >= this.length) {
            this.atEof = true;
            return -1;
        }
        int rv = this.src.read(b, 0, Math.min(b.length, this.length - this.position));
        if (rv > 0) {
            this.position += rv;
        }
        return rv;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.atEof || this.position >= this.length) {
            this.atEof = true;
            return -1;
        }
        int rv = this.src.read(b, off, Math.min(len, this.length - this.position));
        if (rv > 0) {
            this.position += rv;
        }
        return rv;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        if (this.atEof || this.position >= this.length) {
            this.atEof = true;
            return -1L;
        }
        for (long remaining = n = Math.min((long)this.available(), n); remaining > 0L; remaining -= skipped) {
            skipped = this.src.skip(remaining);
            if (skipped > 0L) continue;
            throw new IOException("Failed to skip a total of " + n + " bytes in stream; " + remaining + " bytes remained but " + skipped + " returned from skip.");
        }
        this.position = (int)((long)this.position + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.atEof || this.position >= this.length) {
            return 0;
        }
        return this.length - this.position;
    }

    @Override
    public int read() throws IOException {
        if (this.atEof || this.position >= this.length) {
            this.atEof = true;
            return -1;
        }
        int rv = this.src.read();
        if (rv < 0) {
            this.atEof = true;
        } else if (rv > 0) {
            this.position += rv;
        }
        return rv;
    }
}

