/*
 * Decompiled with CFR 0.152.
 */
package cc.synkdev.nexusMenus;

import cc.synkdev.nexusMenus.ConfigManager;
import cc.synkdev.nexusMenus.CooldownManager;
import cc.synkdev.nexusMenus.Util;
import cc.synkdev.nexusMenus.commands.DynamicCommand;
import cc.synkdev.nexusMenus.commands.MainCmd;
import cc.synkdev.nexusMenus.commands.MenuCommandHandler;
import cc.synkdev.nexusMenus.events.PlayerListener;
import cc.synkdev.nexusMenus.objects.PluginGui;
import cc.synkdev.nexusMenus.objects.PluginItem;
import cc.synkdev.shaded.bukkit.Metrics;
import cc.synkdev.synkLibs.bukkit.Analytics;
import cc.synkdev.synkLibs.bukkit.Lang;
import cc.synkdev.synkLibs.components.SynkPlugin;
import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.MessageKeys;
import dev.triumphteam.gui.components.GuiType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NexusMenus
extends JavaPlugin
implements SynkPlugin {
    private static NexusMenus instance;
    public Map<String, PluginGui> guiMap = new HashMap<String, PluginGui>();
    public Map<String, UUID> guiEditors = new HashMap<String, UUID>();
    public Map<UUID, String> guiViewers = new HashMap<UUID, String>();
    public Map<UUID, PluginItem> cloneMap = new HashMap<UUID, PluginItem>();
    public File cooldownFile = new File(this.getDataFolder(), "cooldowns.yml");
    public File configFile = new File(this.getDataFolder(), "config.yml");
    public File messagesFile = new File(this.getDataFolder(), "messages.yml");
    public File menusFolder = new File(this.getDataFolder(), "menus");
    public FileConfiguration cooldownConfig;
    public FileConfiguration config;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    public List<String> commandsWaitList = new ArrayList<String>();
    public List<String> commandsWaitDelList = new ArrayList<String>();
    public Map<String, String> langMap = new HashMap<String, String>();
    private final File langFile = new File(this.getDataFolder(), "lang.json");

    public void onEnable() {
        instance = this;
        new Metrics(this, 27067);
        Analytics.registerSpl((JavaPlugin)this);
        this.updateConfig();
        ConfigManager.setup(this.config);
        this.reloadLang();
        this.initCooldown();
        CooldownManager.setup(this.cooldownConfig);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        BukkitCommandManager bcm = new BukkitCommandManager((Plugin)this);
        bcm.registerCommand(new MainCmd());
        bcm.getCommandCompletions().registerCompletion("types", h -> Arrays.stream(GuiType.values()).map(Enum::name).toList());
        bcm.usePerIssuerLocale(false);
        bcm.getLocales().addMessage(bcm.getLocales().getDefaultLocale(), MessageKeys.PERMISSION_DENIED, Lang.translate((String)"commands.no-perm", (SynkPlugin)this, (String[])new String[0]));
        bcm.getLocales().addMessage(bcm.getLocales().getDefaultLocale(), MessageKeys.NOT_ALLOWED_ON_CONSOLE, Lang.translate((String)"commands.console-error", (SynkPlugin)this, (String[])new String[0]));
        bcm.getLocales().addMessage(bcm.getLocales().getDefaultLocale(), MessageKeys.UNKNOWN_COMMAND, Lang.translate((String)"commands.not-exist", (SynkPlugin)this, (String[])new String[0]));
        this.initFolder();
        this.loadMenus();
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            if (this.commandsWaitList.isEmpty()) {
                if (this.commandsWaitDelList.isEmpty()) {
                    return;
                }
                String command = this.commandsWaitDelList.get(0);
                this.commandsWaitDelList.remove(0);
                this.unregisterCommand(command);
                return;
            }
            String command = this.commandsWaitList.get(0);
            this.commandsWaitList.remove(0);
            this.registerCommand(command);
        }, 1L, 1L);
    }

    public void loadMenus() {
        this.guiMap.clear();
        for (File file : this.menusFolder.listFiles()) {
            String name = file.getName().replaceAll(".yml", "");
            this.guiMap.put(name, new PluginGui(file));
            this.registerMenuCommand(name, name);
        }
    }

    public void reloadLang() {
        this.langMap.clear();
        this.langMap.putAll(Lang.init((SynkPlugin)this, (File)this.langFile));
    }

    private void updateConfig() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        try {
            if (!this.configFile.exists()) {
                try {
                    Files.copy(this.getResource("config.yml"), this.configFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            File temp = new File(this.getDataFolder(), "temp-config-" + System.currentTimeMillis() + ".yml");
            try {
                Files.copy(this.getResource("config.yml"), temp.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            YamlConfiguration tempConfig = YamlConfiguration.loadConfiguration((File)temp);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
            boolean changed = false;
            for (String key : tempConfig.getKeys(true)) {
                if (config.contains(key)) continue;
                config.set(key, tempConfig.get(key));
                changed = true;
            }
            if (changed) {
                config.save(this.configFile);
            }
            temp.delete();
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteMenuFile(String name) {
        new File(this.menusFolder, name + ".yml").delete();
    }

    private void initFolder() {
        if (!this.menusFolder.exists()) {
            this.menusFolder.mkdir();
        }
    }

    private void initCooldown() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        try {
            if (!this.cooldownFile.exists()) {
                this.cooldownFile.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cooldownConfig = YamlConfiguration.loadConfiguration((File)this.cooldownFile);
    }

    public void registerMenuCommand(String commandName, String menuName) {
        this.commandsWaitList.add(commandName);
    }

    private void registerCommand(String commandName) {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            DynamicCommand command = new DynamicCommand(commandName, new MenuCommandHandler(commandName));
            command.setDescription("Opens the '" + commandName + "' menu.");
            commandMap.register(this.getDescription().getName(), (Command)command);
            Server server = Bukkit.getServer();
            Method syncCommandsMethod = server.getClass().getDeclaredMethod("syncCommands", new Class[0]);
            syncCommandsMethod.setAccessible(true);
            syncCommandsMethod.invoke((Object)server, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterCommand(String command) {
        this.commandsWaitDelList.add(command);
    }

    private void unregisterMenuCommand(String commandName) {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            Command command = commandMap.getCommand(commandName);
            if (command != null) {
                command.unregister(commandMap);
            }
            Method sync = Bukkit.getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
            sync.setAccessible(true);
            sync.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        CooldownManager.save(this);
        this.guiMap.values().forEach(PluginGui::saveToFile);
    }

    public String name() {
        return "NexusMenus";
    }

    public String ver() {
        return "1.0";
    }

    public String dlLink() {
        return "https://modrinth.com/plugin/nexusmenus";
    }

    public String prefix() {
        return Util.translate("prefix", new String[0]);
    }

    public String lang() {
        return "https://synkdev.cc/storage/translations/lang-pld/NexusMenus/lang-nm.json";
    }

    public Map<String, String> langMap() {
        return this.langMap;
    }

    @Generated
    public static NexusMenus getInstance() {
        return instance;
    }

    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }
}

