/*
 * Decompiled with CFR 0.152.
 */
package cc.synkdev.nexusMenus;

import cc.synkdev.nexusMenus.NexusMenus;
import cc.synkdev.synkLibs.bukkit.Lang;
import cc.synkdev.synkLibs.components.SynkPlugin;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Util {
    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static Component componentify(String s) {
        return Component.text(String.valueOf(ChatColor.RESET) + Util.color(s));
    }

    public static List<Material> getFilteredMaterials() {
        ArrayList<Material> result = new ArrayList<Material>();
        try {
            for (Field field : Material.class.getDeclaredFields()) {
                if (field.getName().contains("AIR") || !field.isEnumConstant() || field.isAnnotationPresent(Deprecated.class)) continue;
                Material value = Material.valueOf((String)field.getName());
                result.add(value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static List<Material> getFilteredMaterials(String search) {
        if (search == null) {
            return Util.getFilteredMaterials();
        }
        ArrayList<Material> result = new ArrayList<Material>();
        try {
            for (Field field : Material.class.getDeclaredFields()) {
                if (field.getName().contains("AIR") || !field.isEnumConstant() || field.isAnnotationPresent(Deprecated.class) || !field.getName().contains(search.toUpperCase())) continue;
                Material value = Material.valueOf((String)field.getName());
                result.add(value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void log(String msg) {
        Bukkit.getConsoleSender().sendMessage(Util.color(msg));
    }

    public static long parseDurationToMillieconds(String input) throws NumberFormatException {
        Map<String, Long> timeUnits = Map.of("s", 1000L, "m", 60000L, "h", 3600000L, "d", 86400000L, "w", 604800000L, "mo", 2592000000L, "y", 31536000000L);
        Matcher matcher = Pattern.compile("(?i)(\\d+)([a-z]+)").matcher(input.trim());
        if (matcher.matches()) {
            long value = Long.parseLong(matcher.group(1));
            String unit = matcher.group(2).toLowerCase();
            Long multiplier = timeUnits.get(unit);
            if (multiplier != null) {
                return value * multiplier;
            }
            throw new IllegalArgumentException("Unknown time unit: " + unit);
        }
        try {
            long ret = Long.parseLong(input);
            return ret;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid time string", e);
        }
    }

    public static String formatMillisecondsToDuration(long millis) {
        LinkedHashMap<String, Long> timeUnits = new LinkedHashMap<String, Long>();
        timeUnits.put("y", 31536000000L);
        timeUnits.put("mo", 2592000000L);
        timeUnits.put("w", 604800000L);
        timeUnits.put("d", 86400000L);
        timeUnits.put("h", 3600000L);
        timeUnits.put("m", 60000L);
        timeUnits.put("s", 1000L);
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : timeUnits.entrySet()) {
            String unit = (String)entry.getKey();
            long unitMillis = (Long)entry.getValue();
            if (millis < unitMillis) continue;
            long count = millis / unitMillis;
            millis %= unitMillis;
            result.append(count).append(unit);
        }
        if (result.length() == 0) {
            result.append("0s");
        }
        return result.toString();
    }

    public static String formatTimestamp(long timestampInSeconds) {
        long timestampInMilliseconds = timestampInSeconds * 1000L;
        Date date = new Date(timestampInMilliseconds);
        SimpleDateFormat sdf = new SimpleDateFormat(NexusMenus.getInstance().getDateFormat());
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    public static FileConfiguration saveItem(FileConfiguration config, ItemStack item, String path) {
        if (item == null) {
            return config;
        }
        config.set(path + ".material", (Object)item.getType().name());
        config.set(path + ".amount", (Object)item.getAmount());
        boolean meta = item.getItemMeta() != null;
        config.set(path + ".name", (Object)Util.unSetColors(meta ? item.getItemMeta().getDisplayName() : ""));
        ArrayList<String> lore = new ArrayList<String>();
        if (meta && item.getItemMeta().getLore() != null) {
            for (String s : item.getItemMeta().getLore()) {
                lore.add(Util.unSetColors(s));
            }
        }
        config.set(path + ".lore", lore);
        Object model = !meta ? "" : (!item.getItemMeta().hasCustomModelData() && !item.getItemMeta().hasItemModel() ? "" : (!item.getItemMeta().hasItemModel() ? (item.getItemMeta().hasCustomModelData() ? Integer.valueOf(item.getItemMeta().getCustomModelData()) : "") : item.getItemMeta().getItemModel().getNamespace() + ":" + item.getItemMeta().getItemModel().getKey()));
        config.set(path + ".model-data", model);
        return config;
    }

    public static ItemStack restoreItem(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        Material material = Material.valueOf((String)section.getString("material").toUpperCase());
        String name = Util.setColors(section.getString("name"));
        ArrayList<String> lore = new ArrayList<String>();
        for (String s : section.getStringList("lore")) {
            lore.add(Util.setColors(s));
        }
        Object mData = section.get("model-data");
        ItemStack item = new ItemStack(material);
        item.setAmount(section.contains("amount") ? section.getInt("amount") : 1);
        ItemMeta meta = Bukkit.getItemFactory().getItemMeta(material);
        try {
            meta.setDisplayName(name);
            meta.setLore(lore);
            if (mData instanceof String) {
                if (!((String)mData).isEmpty()) {
                    meta.setItemModel(new NamespacedKey(((String)mData).split(":")[0], ((String)mData).split(":")[1]));
                }
            } else if (mData instanceof Integer) {
                meta.setCustomModelData((Integer)mData);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        item.setItemMeta(meta);
        return item;
    }

    public static String setColors(String s) {
        HashMap<String, ChatColor> colorMap = new HashMap<String, ChatColor>(Map.of("&0", ChatColor.BLACK, "&1", ChatColor.DARK_BLUE, "&2", ChatColor.DARK_GREEN, "&3", ChatColor.DARK_AQUA, "&4", ChatColor.DARK_RED, "&5", ChatColor.DARK_PURPLE, "&6", ChatColor.GOLD, "&7", ChatColor.GRAY, "&8", ChatColor.DARK_GRAY));
        colorMap.putAll(Map.of("&9", ChatColor.BLUE, "&a", ChatColor.GREEN, "&b", ChatColor.AQUA, "&c", ChatColor.RED, "&d", ChatColor.LIGHT_PURPLE, "&e", ChatColor.YELLOW, "&f", ChatColor.WHITE, "&k", ChatColor.MAGIC, "&l", ChatColor.BOLD, "&m", ChatColor.STRIKETHROUGH));
        colorMap.putAll(Map.of("&n", ChatColor.UNDERLINE, "&o", ChatColor.ITALIC, "&r", ChatColor.RESET));
        for (Map.Entry entry : colorMap.entrySet()) {
            s = s.replaceAll((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return s;
    }

    public static String unSetColors(String s) {
        HashMap<String, ChatColor> colorMap = new HashMap<String, ChatColor>(Map.of("&0", ChatColor.BLACK, "&1", ChatColor.DARK_BLUE, "&2", ChatColor.DARK_GREEN, "&3", ChatColor.DARK_AQUA, "&4", ChatColor.DARK_RED, "&5", ChatColor.DARK_PURPLE, "&6", ChatColor.GOLD, "&7", ChatColor.GRAY, "&8", ChatColor.DARK_GRAY));
        colorMap.putAll(Map.of("&9", ChatColor.BLUE, "&a", ChatColor.GREEN, "&b", ChatColor.AQUA, "&c", ChatColor.RED, "&d", ChatColor.LIGHT_PURPLE, "&e", ChatColor.YELLOW, "&f", ChatColor.WHITE, "&k", ChatColor.MAGIC, "&l", ChatColor.BOLD, "&m", ChatColor.STRIKETHROUGH));
        colorMap.putAll(Map.of("&n", ChatColor.UNDERLINE, "&o", ChatColor.ITALIC, "&r", ChatColor.RESET));
        for (Map.Entry entry : colorMap.entrySet()) {
            s = s.replaceAll(String.valueOf(entry.getValue()), (String)entry.getKey());
        }
        return s;
    }

    public static String sanitize(String s) {
        for (ChatColor value : ChatColor.values()) {
            s = s.replaceAll("&" + value.getChar(), "");
        }
        s = s.replaceAll(" ", "_");
        return s;
    }

    public static String translate(String key, String ... args) {
        return Lang.translate((String)key, (SynkPlugin)NexusMenus.getInstance(), (String[])args);
    }
}

