/*
 * Decompiled with CFR 0.152.
 */
package cc.synkdev.nexusMenus.commands;

import cc.synkdev.nexusMenus.ConfigManager;
import cc.synkdev.nexusMenus.CooldownManager;
import cc.synkdev.nexusMenus.NexusMenus;
import cc.synkdev.nexusMenus.Util;
import cc.synkdev.nexusMenus.gui.MenusListGui;
import cc.synkdev.nexusMenus.objects.GUIType;
import cc.synkdev.nexusMenus.objects.PluginGui;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Subcommand;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

@CommandAlias(value="nexusmenus|nm")
public class MainCmd
extends BaseCommand {
    private final NexusMenus core = NexusMenus.getInstance();

    @Default
    public void onDefault(Player pl) {
        if (ConfigManager.isRequireOp()) {
            if (!pl.isOp()) {
                pl.sendMessage(Util.translate("comands.no-perm", new String[0]));
            }
        } else if (!pl.hasPermission("nexusmenus.command.nexusmenus")) {
            pl.sendMessage(Util.translate("commands.no-perm", new String[0]));
        }
        new MenusListGui().gui(1).open((HumanEntity)pl);
    }

    @Subcommand(value="create")
    public void onCreate(Player pl, String[] args) {
        int rows;
        GUIType gType;
        if (ConfigManager.isRequireOp()) {
            if (!pl.isOp()) {
                pl.sendMessage(Util.translate("comands.no-perm", new String[0]));
            }
        } else if (!pl.hasPermission(ConfigManager.getCreationPerm())) {
            pl.sendMessage(Util.translate("commands.no-perm", new String[0]));
        }
        if (args.length == 0) {
            pl.sendMessage(Util.translate("commands.require-name", new String[0]));
            return;
        }
        String name = args[0];
        if (this.core.guiMap.containsKey(name)) {
            pl.sendMessage(Util.translate("menus.double-name", new String[0]));
            return;
        }
        if (args.length < 2) {
            this.core.guiMap.put(Util.sanitize(name), new PluginGui(Util.sanitize(name), Util.color(name), ConfigManager.getDefRows(), ConfigManager.getDefType()));
            name = Util.sanitize(name);
            this.core.registerMenuCommand(name, name);
            new MenusListGui().gui(1).open((HumanEntity)pl);
            return;
        }
        String type = args[1];
        try {
            gType = GUIType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            pl.sendMessage(Util.translate("commands.gui-types", new String[0]));
            return;
        }
        if (args.length == 2) {
            if (gType == GUIType.CHEST) {
                this.core.guiMap.put(Util.sanitize(name), new PluginGui(Util.sanitize(name), Util.color(name), ConfigManager.getDefRows(), GUIType.CHEST));
            } else {
                this.core.guiMap.put(Util.sanitize(name), new PluginGui(Util.sanitize(name), Util.color(name), 0, gType));
            }
            name = Util.sanitize(name);
            this.core.registerMenuCommand(name, name);
            new MenusListGui().gui(1).open((HumanEntity)pl);
            return;
        }
        if (gType != GUIType.CHEST) {
            this.core.guiMap.put(Util.sanitize(name), new PluginGui(Util.sanitize(name), Util.color(name), 0, gType));
            name = Util.sanitize(name);
            this.core.registerMenuCommand(name, name);
            new MenusListGui().gui(1).open((HumanEntity)pl);
            return;
        }
        try {
            rows = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            pl.sendMessage(Util.translate("commands.require-rows", new String[0]));
            return;
        }
        if (rows >= 1 && rows <= 6) {
            this.core.guiMap.put(Util.sanitize(name), new PluginGui(Util.sanitize(name), Util.color(name), rows, GUIType.CHEST));
            name = Util.sanitize(name);
            this.core.registerMenuCommand(name, name);
            new MenusListGui().gui(1).open((HumanEntity)pl);
            return;
        }
        pl.sendMessage(Util.translate("commands.require-rows", new String[0]));
    }

    @Subcommand(value="edit")
    @CommandPermission(value="nexusmenus.command.edit")
    public void onEdit(Player pl, String[] args) {
        if (args.length == 0) {
            new MenusListGui().gui(1).open((HumanEntity)pl);
            return;
        }
        String name = args[0];
        if (!this.core.guiMap.containsKey(name)) {
            pl.sendMessage(Util.translate("menus.does-not-exist", new String[0]));
            return;
        }
        this.core.guiMap.get(name).openEditor(pl, false, 1);
    }

    @Subcommand(value="clearcooldown")
    @CommandCompletion(value="@players")
    @CommandPermission(value="nexusmenus.command.clearcooldown")
    public void onClearCd(Player pl, String[] args) {
        if (args.length == 0) {
            pl.sendMessage(Util.translate("commands.require-player", new String[0]));
            return;
        }
        String target = args[0];
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)target);
        if (!player.hasPlayedBefore() && !player.isOnline()) {
            pl.sendMessage(Util.translate("commands.cannot-find-player", new String[0]));
            return;
        }
        if (args.length == 1) {
            CooldownManager.clearCooldown(player.getUniqueId());
            return;
        }
        if (args.length != 2) {
            pl.sendMessage(Util.translate("commands.require-id", new String[0]));
            return;
        }
        String id = args[1];
        CooldownManager.clearCooldown(pl.getUniqueId(), id);
        pl.sendMessage(Util.translate("cooldown-reset", new String[0]));
    }

    @Subcommand(value="reload")
    @CommandPermission(value="nexusmenus.command.reload")
    public void onReload(CommandSender sender) {
        long time = System.currentTimeMillis();
        ConfigManager.setup(this.core.getConfig());
        this.core.reloadLang();
        this.core.loadMenus();
        sender.sendMessage(Util.color("&aSuccessfully reloaded the plugin in " + (System.currentTimeMillis() - time) + " ms!"));
    }
}

