/*
 * Decompiled with CFR 0.152.
 */
package cc.synkdev.nexusMenus.gui;

import cc.synkdev.nexusMenus.NexusMenus;
import cc.synkdev.nexusMenus.Util;
import dev.triumphteam.gui.builder.gui.ChestGuiBuilder;
import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.Gui;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.wesjd.anvilgui.AnvilGUI;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MaterialPickerGUI {
    private final NexusMenus core = NexusMenus.getInstance();

    public Gui gui(int page, String search, Runnable onBack, Consumer<Material> onSelect) {
        Material sign;
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().rows(6)).disableAllInteractions()).title(Util.componentify(Util.translate("editing.material.title", new String[0])))).create();
        ArrayList<Material> materials = new ArrayList<Material>(Util.getFilteredMaterials(search));
        int max = (materials.size() + 44) / 45;
        gui.getFiller().fillBottom(((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem());
        if (page > 1) {
            gui.setItem(6, 4, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("menus.pages.prev-page", new String[0])))).asGuiItem(event -> this.gui(page - 1, search, onBack, onSelect).open((HumanEntity)((Player)event.getWhoClicked()))));
        }
        if (page < max) {
            gui.setItem(6, 6, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("menus.pages.next-page", new String[0])))).asGuiItem(event -> this.gui(page + 1, search, onBack, onSelect).open((HumanEntity)((Player)event.getWhoClicked()))));
        }
        gui.setItem(6, 5, ((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Util.componentify(Util.translate("editing.back", new String[0])))).asGuiItem(event -> onBack.run()));
        ArrayList<Component> lore = new ArrayList<Component>();
        if (search != null) {
            lore.add(Component.text(""));
            lore.add(Util.componentify(Util.translate("editing.material.current-search", search)));
            lore.add(Component.text(Util.translate("editing.material.search-reset", new String[0])));
        }
        lore.add(Component.text(""));
        lore.add(Util.componentify(Util.translate("editing.material.click-search", new String[0])));
        try {
            sign = Material.valueOf((String)"SIGN");
        }
        catch (IllegalArgumentException e) {
            sign = Material.OAK_SIGN;
        }
        gui.setItem(6, 2, ((ItemBuilder)((ItemBuilder)((ItemBuilder)ItemBuilder.from(sign).name(Util.componentify(Util.translate("editing.material.search", new String[0])))).flags(ItemFlag.HIDE_ATTRIBUTES)).lore(lore)).asGuiItem(event -> {
            Player p = (Player)event.getWhoClicked();
            if (event.isRightClick() && search != null) {
                this.gui(1, null, onBack, onSelect).open((HumanEntity)p);
                return;
            }
            AnvilGUI.Builder anvil = new AnvilGUI.Builder();
            anvil.plugin((Plugin)this.core);
            anvil.itemLeft(new ItemStack(Material.PAPER));
            ItemStack out = new ItemStack(Material.PAPER);
            ItemMeta meta = out.getItemMeta();
            meta.setDisplayName(Util.translate("editing.material.search", new String[0]));
            out.setItemMeta(meta);
            anvil.itemOutput(out);
            anvil.text(Util.translate("editing.material.search-anvil", new String[0]));
            anvil.onClick((integer, stateSnapshot) -> {
                if (integer != 2) {
                    return List.of();
                }
                p.closeInventory();
                this.gui(1, stateSnapshot.getText(), onBack, onSelect).open((HumanEntity)p);
                return List.of();
            });
            anvil.onClose(stateSnapshot -> this.gui(1, stateSnapshot.getText(), onBack, onSelect).open((HumanEntity)p));
            anvil.open(p);
        }));
        int minSlot = 45 * (page - 1);
        int maxSlot = 45 * page;
        for (int i = minSlot; i < maxSlot && materials.size() > i; ++i) {
            Material m = (Material)materials.get(i);
            try {
                gui.setItem(i - minSlot, ((ItemBuilder)((ItemBuilder)((ItemBuilder)ItemBuilder.from(m).name(Component.text(String.valueOf(ChatColor.GOLD) + m.name()))).flags(ItemFlag.HIDE_ATTRIBUTES)).lore(Component.text(""), Util.componentify(Util.translate("editing.material.click-select", new String[0])))).asGuiItem(event -> onSelect.accept(m)));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return gui;
    }
}

