/*
 * Decompiled with CFR 0.152.
 */
package cc.synkdev.nexusMenus.objects;

import cc.synkdev.nexusMenus.ConfigManager;
import cc.synkdev.nexusMenus.NexusMenus;
import cc.synkdev.nexusMenus.Util;
import cc.synkdev.nexusMenus.gui.CreationGui;
import cc.synkdev.nexusMenus.gui.ItemCreationGui;
import cc.synkdev.nexusMenus.gui.MenusListGui;
import cc.synkdev.nexusMenus.gui.PageSwitchersEditGui;
import cc.synkdev.nexusMenus.gui.PagesEditGui;
import cc.synkdev.nexusMenus.objects.GUIType;
import cc.synkdev.nexusMenus.objects.ItemActionType;
import cc.synkdev.nexusMenus.objects.ItemCooldown;
import cc.synkdev.nexusMenus.objects.PluginItem;
import dev.triumphteam.gui.builder.gui.ChestGuiBuilder;
import dev.triumphteam.gui.builder.gui.TypedGuiBuilder;
import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.builder.item.SkullBuilder;
import dev.triumphteam.gui.guis.Gui;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.wesjd.anvilgui.AnvilGUI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PluginGui {
    public String name;
    public String title;
    public String permission;
    public int rows;
    public GUIType type;
    public int pages;
    public Map<Integer, PluginItem> itemsMap;
    public ItemStack prevPageItem;
    public int prevPageSlot;
    public ItemStack nextPageItem;
    public int nextPageSlot;

    public PluginGui(String name, String title, int rows, GUIType type) {
        this.name = name;
        this.title = title;
        this.permission = "nexusmenus." + name;
        this.rows = rows;
        this.type = type;
        this.itemsMap = new HashMap<Integer, PluginItem>();
        this.setPages(1);
    }

    public PluginGui(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.setName(config.getString("name"));
        this.setTitle(config.getString("title"));
        this.setType(GUIType.valueOf(config.getString("type")));
        this.setRows(config.getInt("rows"));
        this.setPermission(config.getString("permission"));
        this.setPages(config.getInt("pages-count"));
        this.itemsMap = new HashMap<Integer, PluginItem>();
        if (this.getType() == GUIType.CHEST) {
            try {
                for (String page : config.getConfigurationSection("pages").getKeys(false)) {
                    for (String item : config.getConfigurationSection("pages").getConfigurationSection(page).getConfigurationSection("items").getKeys(false)) {
                        ConfigurationSection section = config.getConfigurationSection("pages." + page + ".items." + item);
                        int pageInt = Integer.parseInt(page);
                        int slot = (pageInt - 1) * this.getRows() * 9 + Integer.parseInt(item);
                        this.itemsMap.put(slot, this.loadItem(section));
                    }
                }
            }
            catch (Exception exception) {}
        } else if (config.getConfigurationSection("items") != null) {
            for (String s : config.getConfigurationSection("items").getKeys(false)) {
                int slot = Integer.parseInt(s);
                this.itemsMap.put(slot, this.loadItem(config.getConfigurationSection("items").getConfigurationSection(s)));
            }
        }
        this.setPrevPageItem(Util.restoreItem(config.getConfigurationSection("switchers.previous.item")));
        this.setPrevPageSlot(config.getInt("switchers.previous.slot"));
        this.setNextPageItem(Util.restoreItem(config.getConfigurationSection("switchers.next.item")));
        this.setNextPageSlot(config.getInt("switchers.next.slot"));
    }

    private PluginItem loadItem(ConfigurationSection section) {
        String id = section.getString("id");
        ItemStack itemStack = Util.restoreItem(section);
        HashMap<String, ItemActionType> actionMap = new HashMap<String, ItemActionType>();
        for (String action : section.getStringList("actions")) {
            Pattern pattern = Pattern.compile("\\[([^\\]]+)\\]\\s*(.*)");
            Matcher matcher = pattern.matcher(action);
            if (!matcher.matches()) continue;
            ItemActionType actionType = ItemActionType.valueOf(matcher.group(1).toUpperCase());
            actionMap.put(matcher.group(2), actionType);
        }
        ItemCooldown cooldown = new ItemCooldown(!section.getBoolean("cooldown.disabled"), section.getBoolean("cooldown.one-time-use"), section.getLong("cooldown.duration"), Util.restoreItem(section.getConfigurationSection("cooldown-fallback-item")));
        String permission = section.getBoolean("permission.enabled") ? section.getString("permission.node") : null;
        ItemStack permissionFallback = Util.restoreItem(section.getConfigurationSection("permission.fallback-item"));
        return new PluginItem(id, itemStack, actionMap, cooldown, permission, permissionFallback);
    }

    public void openEditor(Player p, boolean clone, int page) {
        NexusMenus core = NexusMenus.getInstance();
        if (core.guiEditors.containsKey(this.title) && core.guiEditors.get(this.title) != p.getUniqueId()) {
            p.sendMessage(Util.translate("editing.double-editing", new String[0]));
            return;
        }
        core.guiEditors.put(this.getName(), p.getUniqueId());
        Gui gui = this.type == GUIType.CHEST ? ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().rows(this.rows)).title(Util.componentify(this.title))).disableAllInteractions()).create() : ((TypedGuiBuilder)((TypedGuiBuilder)Gui.gui().type(this.type.guiType).title(Util.componentify(this.title))).disableAllInteractions()).create();
        try {
            gui.getFiller().fill(((SkullBuilder)ItemBuilder.skull().texture("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZmMzE0MzFkNjQ1ODdmZjZlZjk4YzA2NzU4MTA2ODFmOGMxM2JmOTZmNTFkOWNiMDdlZDc4NTJiMmZmZDEifX19").name(Util.componentify(clone ? Util.translate("editing.paste-item", new String[0]) : Util.translate("editing.add-item", new String[0])))).asGuiItem(event -> {
                int slot;
                int n = slot = this.getType() == GUIType.CHEST ? event.getSlot() + (page - 1) * this.getRows() * 9 : event.getSlot();
                if (clone) {
                    PluginItem item = core.cloneMap.remove(event.getWhoClicked().getUniqueId());
                    this.itemsMap.put(slot, item);
                    this.save();
                    PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(this.getName());
                    pGui1.openEditor(p, false, page);
                    return;
                }
                new ItemCreationGui().gui(this, slot).open((HumanEntity)((Player)event.getWhoClicked()));
            }));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int min = (page - 1) * this.getRows() * 9;
        int max = this.getType() == GUIType.CHEST ? this.rows * 9 * page - 1 : this.type.guiType.getLimit();
        for (int i = min; i <= max; ++i) {
            PluginItem pItem = this.itemsMap.get(i);
            if (pItem == null) continue;
            ItemStack item = pItem.getItem().clone();
            int finalI = i;
            gui.setItem(i - this.rows * (page - 1) * 9, ((ItemBuilder)ItemBuilder.from(item).lore(Util.componentify(Util.translate("editing.click-edit", new String[0])), ConfigManager.getMidClone() != false ? Util.componentify(Util.translate("editing.click-clone", new String[0])) : null, Util.componentify(Util.translate("editing.click-delete", new String[0])))).asGuiItem(event -> {
                if (event.isLeftClick()) {
                    pItem.openEditor(p, this, finalI);
                } else if (event.getClick() == ClickType.MIDDLE) {
                    core.cloneMap.put(event.getWhoClicked().getUniqueId(), pItem);
                    this.openEditor(p, true, page);
                } else {
                    this.itemsMap.remove(finalI);
                    this.save();
                    PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(this.getName());
                    pGui1.openEditor(p, false, page);
                }
            }));
        }
        if (page > 1) {
            if (this.prevPageItem == null) {
                this.setPrevPageItem(((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("menus.pages.prev-page", new String[0])))).asGuiItem().getItemStack());
                this.save();
            }
            gui.setItem(this.prevPageSlot, ItemBuilder.from(this.getPrevPageItem()).asGuiItem(event -> this.openEditor(p, clone, page - 1)));
        }
        if (page < this.pages) {
            if (this.nextPageItem == null) {
                this.setNextPageItem(((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("menus.pages.prev-page", new String[0])))).asGuiItem().getItemStack());
                this.save();
            }
            gui.setItem(this.nextPageSlot, ItemBuilder.from(this.getNextPageItem()).asGuiItem(event -> this.openEditor(p, clone, page + 1)));
        }
        gui.setCloseGuiAction(event -> core.guiEditors.remove(this.getName()));
        gui.open((HumanEntity)p);
    }

    public void save() {
        this.saveToFile();
        NexusMenus.getInstance().guiMap.put(this.getName(), this);
        if (!ConfigManager.isAutoReloadMenus()) {
            return;
        }
        for (Map.Entry<UUID, String> entry : NexusMenus.getInstance().guiViewers.entrySet()) {
            if (!entry.getValue().equals(this.getTitle())) continue;
            Player pp = Bukkit.getPlayer((UUID)entry.getKey());
            assert (pp != null);
            pp.closeInventory();
            pp.sendMessage(Util.translate("management.viewing-edited", new String[0]));
        }
    }

    public void open(Player p, int page) {
        if (this.getPermission() != null && !p.hasPermission(this.getPermission())) {
            p.sendMessage(Util.translate("menus.no-perm", new String[0]));
            return;
        }
        NexusMenus.getInstance().guiViewers.put(p.getUniqueId(), this.getName());
        Gui gui = this.type == GUIType.CHEST ? ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().rows(this.rows)).title(Util.componentify(Util.translate("menus.title", this.title, "" + page, "" + (this.pages == 0 ? 1 : this.pages))))).disableAllInteractions()).create() : ((TypedGuiBuilder)((TypedGuiBuilder)Gui.gui().type(this.type.guiType).title(Util.componentify(this.title))).disableAllInteractions()).create();
        if (page > 1) {
            if (this.prevPageItem == null) {
                this.setPrevPageItem(((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("menus.pages.prev-page", new String[0])))).asGuiItem().getItemStack());
                this.save();
            }
            gui.setItem(this.prevPageSlot, ItemBuilder.from(this.getPrevPageItem()).asGuiItem(event -> this.open(p, page - 1)));
        }
        if (page < this.pages) {
            if (this.nextPageItem == null) {
                this.setNextPageItem(((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("menus.pages.next-page", new String[0])))).asGuiItem().getItemStack());
                this.save();
            }
            gui.setItem(this.nextPageSlot, ItemBuilder.from(this.getNextPageItem()).asGuiItem(event -> this.open(p, page + 1)));
        }
        int minSlot = this.getType() == GUIType.CHEST ? (page - 1) * this.getRows() * 9 : 0;
        int maxSlot = this.getType() == GUIType.CHEST ? page * this.getRows() * 9 : this.getType().limit;
        for (int i = minSlot; i < maxSlot; ++i) {
            if (!this.itemsMap.containsKey(i)) continue;
            gui.setItem(i - minSlot, this.itemsMap.get(i).getGuiItem(p));
        }
        gui.setCloseGuiAction(event -> NexusMenus.getInstance().guiViewers.remove(event.getPlayer().getUniqueId(), this.getName()));
        gui.open((HumanEntity)p);
        NexusMenus.getInstance().guiViewers.put(p.getUniqueId(), this.getName());
    }

    public void openManager(Player p) {
        NexusMenus core = NexusMenus.getInstance();
        if (core.guiEditors.containsKey(this.title) && core.guiEditors.get(this.title) != p.getUniqueId()) {
            p.sendMessage(Util.translate("editing.double-editing", new String[0]));
            return;
        }
        core.guiEditors.put(this.getName(), p.getUniqueId());
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().rows(5)).disableAllInteractions()).title(Component.text(Util.translate("management.title", this.getTitle())))).create();
        gui.getFiller().fill(((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem());
        gui.setItem(1, 5, ((ItemBuilder)ItemBuilder.from(this.type.item).name(Util.componentify(this.getTitle()))).asGuiItem());
        gui.setItem(3, 2, ((ItemBuilder)ItemBuilder.from(Material.NAME_TAG).name(Util.componentify(Util.translate("editing.rename", new String[0])))).asGuiItem(event -> {
            AnvilGUI.Builder anvil = new AnvilGUI.Builder();
            anvil.title(Util.translate("editing.rename-anvil", new String[0]));
            anvil.itemLeft(((ItemBuilder)ItemBuilder.from(this.type.item).name(Component.text(Util.color(this.getTitle())))).asGuiItem().getItemStack());
            anvil.plugin((Plugin)core);
            anvil.onClick((integer, stateSnapshot) -> {
                if (integer != 2) {
                    return List.of();
                }
                core.guiMap.remove(this.getName());
                Bukkit.getScheduler().runTask((Plugin)core, () -> core.unregisterCommand(this.getName()));
                core.deleteMenuFile(this.getName());
                this.setName(Util.sanitize(stateSnapshot.getText()));
                this.setTitle(Util.color(stateSnapshot.getText()));
                this.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(this.getName());
                core.registerMenuCommand(this.getName(), this.getName());
                pGui1.openManager(p);
                return List.of();
            });
            anvil.open(p);
        }));
        gui.setItem(3, 3, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.GRASS_BLOCK).name(Util.componentify(Util.translate("management.change-rows", new String[0])))).lore(Util.componentify(this.type == GUIType.CHEST ? Util.translate("editing.click-edit", new String[0]) : Util.translate("management.chest-only", new String[0])))).asGuiItem(event -> {
            if (this.type != GUIType.CHEST) {
                return;
            }
            new CreationGui().rowsPicker(this.getTitle(), rows -> {
                this.setRows((int)rows);
                this.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(this.getName());
                pGui1.openManager(p);
            }).open((HumanEntity)p);
        }));
        gui.setItem(3, 4, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.WRITABLE_BOOK).name(Util.componentify(Util.translate("management.edit-pages", new String[0])))).lore(Util.componentify(this.type == GUIType.CHEST ? Util.translate("editing.click-edit", new String[0]) : Util.translate("management.chest-only", new String[0])))).asGuiItem(event -> {
            if (this.type != GUIType.CHEST) {
                return;
            }
            new PagesEditGui().gui(this, pGui -> {
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(this.getName());
                pGui1.openManager(p);
            }).open((HumanEntity)p);
        }));
        gui.setItem(3, 5, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.TIPPED_ARROW).name(Util.componentify(Util.translate("management.edit-switchers", new String[0])))).lore(Util.componentify(this.type == GUIType.CHEST ? Util.translate("editing.click-edit", new String[0]) : Util.translate("management.chest-only", new String[0])))).asGuiItem(event -> {
            if (this.type != GUIType.CHEST) {
                return;
            }
            new PageSwitchersEditGui().gui(this, pGui -> {
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(this.getName());
                pGui1.openManager(p);
            }).open((HumanEntity)p);
        }));
        gui.setItem(3, 8, ((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Util.componentify(Util.translate("management.delete-menu", new String[0])))).asGuiItem(event -> {
            Player player;
            core.guiMap.remove(this.getName());
            Bukkit.getScheduler().runTask((Plugin)core, () -> core.unregisterCommand(this.getName()));
            core.deleteMenuFile(this.getName());
            new MenusListGui().gui(1).open((HumanEntity)p);
            UUID uuid = core.guiEditors.remove(this.getName());
            if (uuid != null && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
                new MenusListGui().gui(1).open((HumanEntity)player);
                player.sendMessage(Util.translate("management.editing-deleted", new String[0]));
            }
            if (core.guiViewers.containsValue(this.getTitle())) {
                core.guiViewers.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(this.getTitle())).forEach(entry -> {
                    Player player;
                    core.guiViewers.remove(entry.getKey());
                    if (entry.getKey() != null && (player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()))) != null) {
                        player.closeInventory();
                        player.sendMessage(Util.translate("management.viewing-deleted", new String[0]));
                    }
                });
            }
        }));
        gui.setItem(5, 5, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("editing.back", new String[0])))).asGuiItem(event -> {
            new MenusListGui().gui(1).open((HumanEntity)p);
            if (!ConfigManager.isAutoReloadMenus()) {
                return;
            }
            for (Map.Entry<UUID, String> entry : core.guiViewers.entrySet()) {
                if (!entry.getValue().equals(this.getTitle())) continue;
                Player pp = Bukkit.getPlayer((UUID)entry.getKey());
                assert (pp != null);
                pp.closeInventory();
                pp.sendMessage(Util.translate("management.viewing-edited", new String[0]));
            }
        }));
        gui.open((HumanEntity)p);
    }

    public void saveToFile() {
        NexusMenus core = NexusMenus.getInstance();
        File file = new File(core.menusFolder, this.getTitle() + ".yml");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            config.set("name", (Object)this.name);
            config.set("title", (Object)Util.unSetColors(this.title));
            config.set("type", (Object)this.getType().name());
            config.set("rows", (Object)this.getRows());
            config.set("permission", (Object)this.getPermission());
            if (this.getType() == GUIType.CHEST) {
                config.set("pages-count", (Object)this.getPages());
            }
            for (Map.Entry<Integer, PluginItem> entry : this.itemsMap.entrySet()) {
                int page;
                Object prefix = "";
                int n = page = this.getType() == GUIType.CHEST ? entry.getKey() / (this.getRows() * 9) + 1 : 1;
                if (this.getType() == GUIType.CHEST) {
                    prefix = "pages." + page + ".";
                }
                prefix = (String)prefix + "items." + (this.getType() == GUIType.CHEST ? entry.getKey() - (page - 1) * this.getRows() * 9 : entry.getKey()) + ".";
                PluginItem pItem = entry.getValue();
                config.set((String)prefix + "id", (Object)pItem.getId());
                Util.saveItem((FileConfiguration)config, pItem.getItem(), (String)prefix);
                ArrayList<CallSite> actions = new ArrayList<CallSite>();
                for (Map.Entry<String, ItemActionType> action : pItem.getActions().entrySet()) {
                    actions.add((CallSite)((Object)("[" + action.getValue().name() + "] " + action.getKey())));
                }
                config.set((String)prefix + "actions", actions);
                config.set((String)prefix + "cooldown.enabled", (Object)(pItem.getCooldown().getDisabled() == false ? 1 : 0));
                config.set((String)prefix + "cooldown.one-time-use", (Object)pItem.getCooldown().getOneTime());
                config.set((String)prefix + "cooldown.duration", (Object)Util.formatMillisecondsToDuration(pItem.getCooldown().getTime()));
                Util.saveItem((FileConfiguration)config, pItem.getCooldown().getFallbackItem(), (String)prefix + "cooldown.fallback-item");
                config.set((String)prefix + "permission.enabled", (Object)(pItem.getPermission() != null ? 1 : 0));
                config.set((String)prefix + "permission.node", (Object)(pItem.getPermission() == null ? "" : pItem.getPermission()));
                Util.saveItem((FileConfiguration)config, pItem.getPermissionFallback(), (String)prefix + "permission.fallback-item");
            }
            config.set("switchers.previous.slot", (Object)this.getPrevPageSlot());
            Util.saveItem((FileConfiguration)config, this.getPrevPageItem(), "switchers.previous.item");
            config.set("switchers.next.slot", (Object)this.getNextPageSlot());
            Util.saveItem((FileConfiguration)config, this.getNextPageItem(), "switchers.next.item");
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public GUIType getType() {
        return this.type;
    }

    @Generated
    public int getPages() {
        return this.pages;
    }

    @Generated
    public Map<Integer, PluginItem> getItemsMap() {
        return this.itemsMap;
    }

    @Generated
    public ItemStack getPrevPageItem() {
        return this.prevPageItem;
    }

    @Generated
    public int getPrevPageSlot() {
        return this.prevPageSlot;
    }

    @Generated
    public ItemStack getNextPageItem() {
        return this.nextPageItem;
    }

    @Generated
    public int getNextPageSlot() {
        return this.nextPageSlot;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Generated
    public void setType(GUIType type) {
        this.type = type;
    }

    @Generated
    public void setPages(int pages) {
        this.pages = pages;
    }

    @Generated
    public void setItemsMap(Map<Integer, PluginItem> itemsMap) {
        this.itemsMap = itemsMap;
    }

    @Generated
    public void setPrevPageItem(ItemStack prevPageItem) {
        this.prevPageItem = prevPageItem;
    }

    @Generated
    public void setPrevPageSlot(int prevPageSlot) {
        this.prevPageSlot = prevPageSlot;
    }

    @Generated
    public void setNextPageItem(ItemStack nextPageItem) {
        this.nextPageItem = nextPageItem;
    }

    @Generated
    public void setNextPageSlot(int nextPageSlot) {
        this.nextPageSlot = nextPageSlot;
    }

    @Generated
    public PluginGui(String name, String title, String permission, int rows, GUIType type, int pages, Map<Integer, PluginItem> itemsMap, ItemStack prevPageItem, int prevPageSlot, ItemStack nextPageItem, int nextPageSlot) {
        this.name = name;
        this.title = title;
        this.permission = permission;
        this.rows = rows;
        this.type = type;
        this.pages = pages;
        this.itemsMap = itemsMap;
        this.prevPageItem = prevPageItem;
        this.prevPageSlot = prevPageSlot;
        this.nextPageItem = nextPageItem;
        this.nextPageSlot = nextPageSlot;
    }
}

