/*
 * Decompiled with CFR 0.152.
 */
package cc.synkdev.nexusMenus.objects;

import cc.synkdev.nexusMenus.ConfigManager;
import cc.synkdev.nexusMenus.CooldownManager;
import cc.synkdev.nexusMenus.NexusMenus;
import cc.synkdev.nexusMenus.Util;
import cc.synkdev.nexusMenus.gui.ActionsEditGui;
import cc.synkdev.nexusMenus.gui.CooldownEditGui;
import cc.synkdev.nexusMenus.gui.LoreEditGui;
import cc.synkdev.nexusMenus.gui.MaterialPickerGUI;
import cc.synkdev.nexusMenus.objects.ItemActionType;
import cc.synkdev.nexusMenus.objects.ItemCooldown;
import cc.synkdev.nexusMenus.objects.PluginGui;
import dev.triumphteam.gui.builder.gui.ChestGuiBuilder;
import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.wesjd.anvilgui.AnvilGUI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PluginItem {
    private String id;
    private GuiItem guiItem;
    private ItemStack item;
    private Map<String, ItemActionType> actions;
    private ItemCooldown cooldown;
    private String permission;
    private ItemStack permissionFallback;

    public PluginItem(ItemStack item, PluginGui pGui) {
        this.item = item;
        this.actions = new HashMap<String, ItemActionType>();
        this.cooldown = new ItemCooldown(true, false, 0L, null);
        this.setId(pGui.getTitle() + "." + Math.toIntExact(Math.round(Math.random() * 1.0E7)));
        this.guiItem = ItemBuilder.from(item).asGuiItem(event -> this.run((Player)event.getWhoClicked()));
    }

    public PluginItem(String id, ItemStack item, Map<String, ItemActionType> actions, ItemCooldown cooldown, String permission, ItemStack permissionFallback) {
        this.id = id;
        this.item = item;
        this.actions = actions;
        this.cooldown = cooldown;
        this.permission = permission;
        this.permissionFallback = permissionFallback;
        this.guiItem = ItemBuilder.from(item).asGuiItem(event -> this.run((Player)event.getWhoClicked()));
    }

    private void run(Player pl) {
        if (!this.cooldown.getDisabled().booleanValue() && !pl.hasPermission("nexusmenus.cooldown.bypass")) {
            CooldownManager.addCooldown(pl.getUniqueId(), this.id, this.cooldown.getOneTime() != false ? 0L : System.currentTimeMillis() + this.cooldown.getTime());
        }
        if (this.getPermission() != null && !pl.hasPermission(this.getPermission())) {
            pl.sendMessage(Util.translate("items.no-perm", new String[0]));
        }
        for (Map.Entry<String, ItemActionType> entry : this.actions.entrySet()) {
            String command = entry.getKey();
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                command = PlaceholderAPI.setPlaceholders((Player)pl, (String)entry.getKey());
            }
            switch (entry.getValue()) {
                case CONSOLE: {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    break;
                }
                case PLAYER: {
                    Bukkit.dispatchCommand((CommandSender)pl, (String)command);
                    break;
                }
                case PLAYEROP: {
                    boolean wasOp = pl.isOp();
                    pl.setOp(true);
                    Bukkit.dispatchCommand((CommandSender)pl, (String)command);
                    pl.setOp(wasOp);
                }
            }
        }
    }

    public GuiItem getGuiItem(Player p) {
        if (this.cooldown.getDisabled().booleanValue()) {
            return this.guiItem;
        }
        if (this.getPermission() != null && !p.hasPermission(this.getPermission())) {
            return ItemBuilder.from(this.getPermissionFallback() != null ? this.getPermissionFallback() : ConfigManager.getGlobalFallback()).asGuiItem();
        }
        if (!CooldownManager.hasCooldown(p, this.id)) {
            return this.guiItem;
        }
        return ItemBuilder.from(this.cooldown.getFallbackItem() == null ? ConfigManager.getGlobalFallback() : this.cooldown.getFallbackItem()).asGuiItem();
    }

    public void openEditor(Player p, PluginGui pGui, int slot) {
        NexusMenus core = NexusMenus.getInstance();
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().rows(5)).disableAllInteractions()).title(Component.text(Util.translate("items.editor.title", new String[0])))).create();
        gui.getFiller().fill(((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem());
        gui.setItem(1, 5, ItemBuilder.from(this.item).asGuiItem());
        gui.setItem(3, 1, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BOOK).name(Util.componentify(Util.translate("items.editor.id.set", new String[0])))).lore(Util.componentify(Util.translate("items.editor.id.lore-1", new String[0])), Util.componentify(Util.translate("items.editor.id.lore-2", this.getId())))).asGuiItem(event -> {
            AnvilGUI.Builder anvil = new AnvilGUI.Builder();
            anvil.plugin((Plugin)core);
            anvil.title(Util.translate("items.editor.id.anvil", new String[0]));
            anvil.itemLeft(((ItemBuilder)ItemBuilder.from(Material.PAPER).name(Component.text("Enter ID"))).asGuiItem().getItemStack());
            anvil.onClick((integer, stateSnapshot) -> {
                if (integer != 2) {
                    return List.of();
                }
                this.setId(stateSnapshot.getText());
                this.openEditor(p, pGui, slot);
                return List.of();
            });
            anvil.open(p);
        }));
        gui.setItem(3, 2, ((ItemBuilder)ItemBuilder.from(Material.NAME_TAG).name(Util.componentify(Util.translate("items.editor.rename.item", new String[0])))).asGuiItem(event -> {
            AnvilGUI.Builder anvil = new AnvilGUI.Builder();
            anvil.title(Util.translate("items.editor.rename.anvil", new String[0]));
            anvil.itemLeft(this.item);
            anvil.plugin((Plugin)core);
            anvil.onClick((integer, stateSnapshot) -> {
                if (integer != 2) {
                    return List.of();
                }
                ItemMeta meta = this.item.getItemMeta();
                assert (meta != null);
                meta.setDisplayName(Util.setColors(stateSnapshot.getText()));
                this.item.setItemMeta(meta);
                pGui.itemsMap.put(slot, this);
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
                pGui1.itemsMap.get(slot).openEditor(p, pGui1, slot);
                return List.of();
            });
            anvil.open(p);
        }));
        gui.setItem(3, 3, ((ItemBuilder)ItemBuilder.from(Material.GRASS_BLOCK).name(Util.componentify(Util.translate("editing.material.item", new String[0])))).asGuiItem(event -> new MaterialPickerGUI().gui(1, null, () -> pGui.itemsMap.get(slot).openEditor(p, pGui, slot), material -> {
            this.item.setType(material);
            pGui.itemsMap.put(slot, this);
            pGui.save();
            PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
            pGui1.itemsMap.get(slot).openEditor(p, pGui1, slot);
        }).open((HumanEntity)p)));
        gui.setItem(3, 4, ((ItemBuilder)ItemBuilder.from(Material.WRITABLE_BOOK).name(Util.componentify(Util.translate("editing.lore.item", new String[0])))).asGuiItem(event -> new LoreEditGui().gui(this.item, itemStack -> {
            this.setItem((ItemStack)itemStack);
            pGui.itemsMap.put(slot, this);
            pGui.save();
            PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
            pGui1.itemsMap.get(slot).openEditor(p, pGui1, slot);
        }).open((HumanEntity)p)));
        gui.setItem(3, 5, ((ItemBuilder)ItemBuilder.from(Material.COMMAND_BLOCK).name(Util.componentify(Util.translate("editing.actions.item", new String[0])))).asGuiItem(event -> new ActionsEditGui().gui(this, item -> {
            pGui.itemsMap.put(slot, (PluginItem)item);
            pGui.save();
            PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
            pGui1.itemsMap.get(slot).openEditor(p, pGui1, slot);
        }).open((HumanEntity)p)));
        gui.setItem(3, 6, ((ItemBuilder)ItemBuilder.from(Material.CLOCK).name(Util.componentify(Util.translate("editing.cooldown.item", new String[0])))).asGuiItem(event -> {
            AtomicReference<Consumer<ItemStack>> saveRef = new AtomicReference<Consumer<ItemStack>>();
            Consumer<PluginItem> edited = item -> {
                pGui.itemsMap.put(slot, (PluginItem)item);
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
                pGui1.itemsMap.get(slot).openEditor(p, pGui1, slot);
            };
            Consumer<ItemStack> save = item -> {
                this.getCooldown().setFallbackItem((ItemStack)item);
                pGui.itemsMap.put(slot, this);
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
                PluginItem pItem1 = pGui1.itemsMap.get(slot);
                new CooldownEditGui().gui(pItem1, pGui1, edited, (Consumer)saveRef.get()).open((HumanEntity)p);
            };
            saveRef.set(save);
            new CooldownEditGui().gui(this, pGui, edited, save).open((HumanEntity)p);
        }));
        gui.setItem(3, 7, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BOOK).name(Util.componentify(Util.translate("items.editor.permission.item", new String[0])))).lore(Util.componentify(Util.translate("items.editor.permission.lore-1", new String[0])), Util.componentify(Util.translate("items.editor.permission.lore-2", this.getPermission() == null ? "None" : this.getPermission())), this.getPermission() == null ? null : Util.componentify(Util.translate("items.editor.permission.lore-3", new String[0])))).asGuiItem(event -> {
            if (this.getPermission() != null && event.isRightClick()) {
                this.setPermission(null);
                this.openEditor(p, pGui, slot);
                return;
            }
            AnvilGUI.Builder anvil = new AnvilGUI.Builder();
            anvil.plugin((Plugin)core);
            anvil.title(Util.translate("items.editor.permission.anvil", new String[0]));
            anvil.itemLeft(((ItemBuilder)ItemBuilder.from(Material.PAPER).name(Component.text(Util.translate("items.editor.permission.anvil", new String[0])))).asGuiItem().getItemStack());
            anvil.onClick((integer, stateSnapshot) -> {
                if (integer != 2) {
                    return List.of();
                }
                this.setPermission("nexusmenus." + pGui.getName() + "." + stateSnapshot.getText());
                pGui.save();
                this.openEditor(p, pGui, slot);
                return List.of();
            });
            anvil.open(p);
        }));
        gui.setItem(4, 7, ((ItemBuilder)((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Util.componentify(Util.translate("items.editor.permission.fallback", new String[0])))).lore(Util.componentify(Util.translate("items.editor.permission.fallback-lore-1", new String[0])), this.getPermissionFallback() == null ? null : Util.componentify(Util.translate("items.editor.permission.fallback-lore-2", new String[0])))).asGuiItem(event -> {
            if (this.getPermissionFallback() != null && event.isRightClick()) {
                this.setPermissionFallback(null);
                pGui.itemsMap.put(slot, this);
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
                pGui1.itemsMap.get(slot).openEditor(p, pGui1, slot);
                return;
            }
            AtomicReference<Consumer<ItemStack>> saveRef = new AtomicReference<Consumer<ItemStack>>();
            Consumer<PluginItem> edited = item -> {
                this.setPermissionFallback(item.getItem());
                pGui.itemsMap.put(slot, this);
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
                pGui1.itemsMap.get(slot).openEditor(p, pGui1, slot);
            };
            Consumer<ItemStack> save = item -> {
                this.setPermissionFallback((ItemStack)item);
                pGui.itemsMap.put(slot, this);
                pGui.save();
                PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
                PluginItem pItem1 = pGui1.itemsMap.get(slot);
                new PluginItem(pItem1.getPermissionFallback() == null ? ConfigManager.getGlobalFallback() : pItem1.getPermissionFallback(), pGui1).openEditor(p, edited, (Consumer)saveRef.get());
            };
            saveRef.set(save);
            new PluginItem(this.getPermissionFallback() == null ? ConfigManager.getGlobalFallback().clone() : this.getPermissionFallback(), pGui).openEditor(p, edited, save);
        }));
        gui.setItem(3, 9, ((ItemBuilder)ItemBuilder.from(Material.BARRIER).name(Util.componentify(Util.translate("items.editor.remove", new String[0])))).asGuiItem(event -> {
            pGui.itemsMap.remove(slot);
            pGui.save();
            PluginGui pGui1 = NexusMenus.getInstance().guiMap.get(pGui.getName());
            pGui1.openEditor(p, false, 1);
        }));
        gui.setItem(5, 5, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("editing.back", new String[0])))).asGuiItem(event -> pGui.openEditor(p, false, 1)));
        gui.open((HumanEntity)p);
    }

    public void openEditor(Player p, Consumer<PluginItem> callback, Consumer<ItemStack> save) {
        NexusMenus core = NexusMenus.getInstance();
        AtomicBoolean picked = new AtomicBoolean(false);
        Gui gui = ((ChestGuiBuilder)((ChestGuiBuilder)((ChestGuiBuilder)Gui.gui().rows(5)).disableAllInteractions()).title(Component.text(Util.translate("items.editor.title", new String[0])))).create();
        gui.getFiller().fill(((ItemBuilder)ItemBuilder.from(Material.GRAY_STAINED_GLASS_PANE).name(Component.text(" "))).asGuiItem());
        gui.setItem(1, 5, ItemBuilder.from(this.item).asGuiItem());
        gui.setItem(3, 2, ((ItemBuilder)ItemBuilder.from(Material.NAME_TAG).name(Util.componentify(Util.translate("items.editor.rename.item", new String[0])))).asGuiItem(event -> {
            picked.set(true);
            AnvilGUI.Builder anvil = new AnvilGUI.Builder();
            anvil.title(Util.translate("items.editor.rename.anvil", new String[0]));
            anvil.itemLeft(this.item);
            anvil.plugin((Plugin)core);
            anvil.onClick((integer, stateSnapshot) -> {
                picked.set(true);
                if (integer != 2) {
                    return List.of();
                }
                ItemMeta meta = this.item.getItemMeta();
                assert (meta != null);
                meta.setDisplayName(stateSnapshot.getText());
                this.item.setItemMeta(meta);
                save.accept(this.item);
                return List.of();
            });
            anvil.open(p);
        }));
        gui.setItem(3, 3, ((ItemBuilder)ItemBuilder.from(Material.GRASS_BLOCK).name(Util.componentify(Util.translate("editing.material.item", new String[0])))).asGuiItem(event -> {
            picked.set(true);
            new MaterialPickerGUI().gui(1, null, () -> this.openEditor(p, callback, save), material -> {
                this.item.setType(material);
                save.accept(this.item);
            }).open((HumanEntity)p);
        }));
        gui.setItem(3, 4, ((ItemBuilder)ItemBuilder.from(Material.WRITABLE_BOOK).name(Util.componentify(Util.translate("editing.lore.item", new String[0])))).asGuiItem(event -> {
            picked.set(true);
            new LoreEditGui().gui(this.item, itemStack -> save.accept((ItemStack)itemStack)).open((HumanEntity)p);
        }));
        gui.setItem(5, 5, ((ItemBuilder)ItemBuilder.from(Material.ARROW).name(Util.componentify(Util.translate("editing.back", new String[0])))).asGuiItem(event -> {
            picked.set(true);
            callback.accept(this);
        }));
        gui.setCloseGuiAction(event -> {
            if (!picked.get()) {
                Bukkit.getScheduler().runTaskLater((Plugin)core, () -> callback.accept(this), 1L);
            }
        });
        gui.open((HumanEntity)p);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public GuiItem getGuiItem() {
        return this.guiItem;
    }

    @Generated
    public ItemStack getItem() {
        return this.item;
    }

    @Generated
    public Map<String, ItemActionType> getActions() {
        return this.actions;
    }

    @Generated
    public ItemCooldown getCooldown() {
        return this.cooldown;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public ItemStack getPermissionFallback() {
        return this.permissionFallback;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setGuiItem(GuiItem guiItem) {
        this.guiItem = guiItem;
    }

    @Generated
    public void setItem(ItemStack item) {
        this.item = item;
    }

    @Generated
    public void setActions(Map<String, ItemActionType> actions) {
        this.actions = actions;
    }

    @Generated
    public void setCooldown(ItemCooldown cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public void setPermissionFallback(ItemStack permissionFallback) {
        this.permissionFallback = permissionFallback;
    }

    @Generated
    public PluginItem(String id, GuiItem guiItem, ItemStack item, Map<String, ItemActionType> actions, ItemCooldown cooldown, String permission, ItemStack permissionFallback) {
        this.id = id;
        this.guiItem = guiItem;
        this.item = item;
        this.actions = actions;
        this.cooldown = cooldown;
        this.permission = permission;
        this.permissionFallback = permissionFallback;
    }
}

