/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.builder.item;

import dev.triumphteam.gui.builder.item.NameLoreHandler;
import dev.triumphteam.gui.components.exception.GuiException;
import dev.triumphteam.gui.components.util.Legacy;
import dev.triumphteam.gui.components.util.VersionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.platform.bukkit.MinecraftComponentSerializer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitNameLoreHandler
implements NameLoreHandler {
    private static final Field DISPLAY_NAME_FIELD;
    private static final Field LORE_FIELD;
    private static final BukkitNameLoreHandler INSTANCE;

    @NotNull
    public static BukkitNameLoreHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void name(@NotNull ItemMeta itemMeta, @NotNull Component name) {
        if (VersionHelper.IS_COMPONENT_LEGACY) {
            itemMeta.setDisplayName(Legacy.SERIALIZER.serialize(name));
            return;
        }
        try {
            DISPLAY_NAME_FIELD.set(itemMeta, this.serializeComponent(name));
        }
        catch (IllegalAccessException exception) {
            throw new GuiException("Could not set display name for ItemBuilder.", exception);
        }
    }

    @Override
    public void lore(@NotNull ItemMeta itemMeta, @NotNull List<Component> lore) {
        if (VersionHelper.IS_COMPONENT_LEGACY) {
            itemMeta.setLore(lore.stream().filter(Objects::nonNull).map(Legacy.SERIALIZER::serialize).collect(Collectors.toList()));
            return;
        }
        List jsonLore = lore.stream().filter(Objects::nonNull).map(this::serializeComponent).collect(Collectors.toList());
        try {
            LORE_FIELD.set(itemMeta, jsonLore);
        }
        catch (IllegalAccessException exception) {
            throw new GuiException("Could not set lore for ItemBuilder.", exception);
        }
    }

    @Override
    public void lore(@NotNull ItemMeta itemMeta, @NotNull Consumer<List<@Nullable Component>> lore) {
        ArrayList<Component> components;
        if (VersionHelper.IS_COMPONENT_LEGACY) {
            List stringLore = itemMeta.getLore();
            components = stringLore == null ? new ArrayList<Component>() : stringLore.stream().map(Legacy.SERIALIZER::deserialize).collect(Collectors.toList());
        } else {
            try {
                List jsonLore = (List)LORE_FIELD.get(itemMeta);
                components = jsonLore == null ? new ArrayList() : jsonLore.stream().map(this::deserializeComponent).collect(Collectors.toList());
            }
            catch (IllegalAccessException exception) {
                throw new GuiException("Could not get lore for ItemBuilder.", exception);
            }
        }
        lore.accept(components);
        this.lore(itemMeta, components);
    }

    @NotNull
    private Object serializeComponent(@NotNull Component component) {
        if (VersionHelper.IS_ITEM_NAME_COMPONENT) {
            return MinecraftComponentSerializer.get().serialize(component);
        }
        return GsonComponentSerializer.gson().serialize(component);
    }

    @NotNull
    private Component deserializeComponent(@NotNull Object obj) {
        if (VersionHelper.IS_ITEM_NAME_COMPONENT) {
            return MinecraftComponentSerializer.get().deserialize(obj);
        }
        return GsonComponentSerializer.gson().deserialize((String)obj);
    }

    static {
        INSTANCE = new BukkitNameLoreHandler();
        try {
            Class<?> metaClass = VersionHelper.craftClass("inventory.CraftMetaItem");
            DISPLAY_NAME_FIELD = metaClass.getDeclaredField("displayName");
            DISPLAY_NAME_FIELD.setAccessible(true);
            LORE_FIELD = metaClass.getDeclaredField("lore");
            LORE_FIELD.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException exception) {
            throw new GuiException("Could not retrieve displayName nor lore field for ItemBuilder.", exception);
        }
    }
}

