/*
 * Decompiled with CFR 0.152.
 */
package birsy.foglooksgoodnow.client;

import birsy.foglooksgoodnow.client.FogManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class FoggySkyRenderer {
    public static void renderSky(ClientLevel level, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (FogManager.shouldRenderCaveFog()) {
            FogManager densityManager = FogManager.getDensityManager();
            Vec3 fogColor = FogManager.getCaveFogColor();
            float darkness = densityManager.darkness.get(partialTick);
            float undergroundFactor = 1.0f - Mth.m_14179_((float)darkness, (float)densityManager.getUndergroundFactor(partialTick), (float)1.0f);
            undergroundFactor *= undergroundFactor * undergroundFactor * undergroundFactor;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.resetTextureMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Vec3 skyFogColor = densityManager.unlitFogColor;
            float radius = 5.0f;
            FoggySkyRenderer.renderCone(poseStack, bufferbuilder, 32, true, radius, -30.0f, (float)(fogColor.f_82479_ * skyFogColor.f_82479_), (float)(fogColor.f_82480_ * skyFogColor.f_82480_), (float)(fogColor.f_82481_ * skyFogColor.f_82481_), undergroundFactor, 0.0f, (float)(fogColor.f_82479_ * skyFogColor.f_82479_), (float)(fogColor.f_82480_ * skyFogColor.f_82480_), (float)(fogColor.f_82481_ * skyFogColor.f_82481_), undergroundFactor);
            FoggySkyRenderer.renderCone(poseStack, bufferbuilder, 32, false, radius, 30.0f, (float)(fogColor.f_82479_ * skyFogColor.f_82479_), (float)(fogColor.f_82480_ * skyFogColor.f_82480_), (float)(fogColor.f_82481_ * skyFogColor.f_82481_), undergroundFactor * 0.2f, 0.0f, (float)(fogColor.f_82479_ * skyFogColor.f_82479_), (float)(fogColor.f_82480_ * skyFogColor.f_82480_), (float)(fogColor.f_82481_ * skyFogColor.f_82481_), undergroundFactor);
            RenderSystem.depthMask((boolean)true);
        }
    }

    private static void renderCone(PoseStack poseStack, BufferBuilder bufferBuilder, int resolution, boolean normal, float radius, float topVertexHeight, float topR, float topG, float topB, float topA, float bottomVertexHeight, float bottomR, float bottomG, float bottomB, float bottomA) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix, 0.0f, topVertexHeight, 0.0f).m_85950_(topR, topG, topB, topA).m_5752_();
        for (int vertex = 0; vertex <= resolution; ++vertex) {
            float angle = (float)vertex * ((float)Math.PI * 2) / (float)resolution;
            float x = Mth.m_14031_((float)angle) * radius;
            float z = Mth.m_14089_((float)angle) * radius;
            bufferBuilder.m_252986_(matrix, x, bottomVertexHeight, normal ? z : -z).m_85950_(bottomR, bottomG, bottomB, bottomA).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

