/*
 * Decompiled with CFR 0.152.
 */
package femboys.are.cute;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Pings
extends JavaPlugin
implements Listener {
    private String replacementText;
    private Sound sound;
    private float volume;
    private float pitch;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
    }

    private void loadConfigValues() {
        this.replacementText = this.getConfig().getString("replacement-text", "&8@&b%loop-player%&7");
        try {
            this.sound = Sound.valueOf((String)this.getConfig().getString("sound", "BLOCK_NOTE_BLOCK_PLING"));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid sound in config, defaulting to BLOCK_NOTE_BLOCK_PLING");
            this.sound = Sound.BLOCK_NOTE_BLOCK_BELL;
        }
        this.volume = (float)this.getConfig().getDouble("volume", 1.0);
        this.pitch = (float)this.getConfig().getDouble("pitch", 0.8);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String message = event.getMessage();
        Player sender = event.getPlayer();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!message.contains(player.getName())) continue;
            message = message.replaceAll("(?i)" + player.getName(), ChatColor.translateAlternateColorCodes((char)'&', (String)this.replacementText.replace("%player%", player.getName())));
            player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
        }
        event.setMessage(message);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("pings") && args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("pings.reload")) {
                this.reloadConfig();
                this.loadConfigValues();
                sender.sendMessage(ChatColor.GREEN + "Config reloaded!");
            } else {
                sender.sendMessage(ChatColor.RED + "You don't have permission to use this command.");
            }
            return true;
        }
        return false;
    }
}

