/*
 * Decompiled with CFR 0.152.
 */
package dev.duzo.mobspawner.mixin;

import dev.duzo.mobspawner.Constants;
import dev.duzo.mobspawner.api.SpawnerData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpawnerBlockEntity.class})
public class SpawnerBlockEntityMixin
implements SpawnerData {
    @Unique
    private boolean mobspawner$forceLoaded = false;

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    private void saveAdditional(CompoundTag data, HolderLookup.Provider provider, CallbackInfo ci) {
        data.putBoolean("mobspawner:forceLoaded", this.mobspawner$isForceLoaded());
    }

    @Inject(method={"loadAdditional"}, at={@At(value="HEAD")})
    private void loadAdditional(CompoundTag data, HolderLookup.Provider provider, CallbackInfo ci) {
        this.mobspawner$setForceLoaded(data.getBoolean("mobspawner:forceLoaded"));
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private static void serverTick(Level level, BlockPos pos, BlockState state, SpawnerBlockEntity be, CallbackInfo ci) {
        RandomSource random;
        SpawnerData data;
        if (!(be instanceof SpawnerData) || !(data = (SpawnerData)be).mobspawner$isForceLoaded()) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        if (sLevel.getBlockTicks().count() % 120 == 0) {
            ChunkPos chunkPos = new ChunkPos(pos);
            sLevel.setChunkForced(chunkPos.x, chunkPos.z, true);
        }
        if (!(random = sLevel.random).nextBoolean()) {
            return;
        }
        Vec3 pPos = Vec3.atCenterOf((Vec3i)pos);
        pPos.add((double)((float)(random.nextInt(0, 100) - 50) / 100.0f), 0.1, (double)((float)(random.nextInt(0, 100) - 50) / 100.0f));
        sLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pPos.x, pPos.y, pPos.z, 10, 0.1, 0.1, 0.1, 0.1);
    }

    @Override
    public boolean mobspawner$isForceLoaded() {
        return this.mobspawner$forceLoaded;
    }

    @Override
    public void mobspawner$setForceLoaded(boolean forceLoaded) {
        this.mobspawner$forceLoaded = forceLoaded;
        SpawnerBlockEntity be = (SpawnerBlockEntity)this;
        if (!be.hasLevel()) {
            return;
        }
        if (be.getLevel().isClientSide()) {
            Constants.LOG.error("This mod is not supposed to be installed on the client side!");
            return;
        }
        ServerLevel level = (ServerLevel)be.getLevel();
        BlockPos pos = be.getBlockPos();
        ChunkPos chunkPos = new ChunkPos(pos);
        level.setChunkForced(chunkPos.x, chunkPos.z, forceLoaded);
    }
}

