/*
 * Decompiled with CFR 0.152.
 */
package net.p4pingvin4ik.NickPaints.client;

import com.mojang.authlib.GameProfile;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.type.ImBoolean;
import imgui.type.ImInt;
import imgui.type.ImString;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_640;
import net.p4pingvin4ik.NickPaints.client.Lang;
import net.p4pingvin4ik.NickPaints.client.MojangAPIHelper;
import net.p4pingvin4ik.NickPaints.client.WebSocketManager;
import net.p4pingvin4ik.NickPaints.client.imgui.RenderInterface;
import net.p4pingvin4ik.NickPaints.config.ConfigManager;
import net.p4pingvin4ik.NickPaints.util.GradientUtil;
import org.lwjgl.glfw.GLFW;

public class ImGuiScreen
extends class_437
implements RenderInterface {
    private final ImBoolean isRainbowMode = new ImBoolean(false);
    private final ImInt rainbowSpeed = new ImInt(3000);
    private final List<float[]> colors = new ArrayList<float[]>();
    private final ImInt speed = new ImInt(4000);
    private final ImInt segment = new ImInt(16);
    private final ImBoolean isStatic = new ImBoolean(false);
    private final ImBoolean isBlockStyle = new ImBoolean(false);
    private final ImInt angle = new ImInt(45);
    private final ImString playerToDisableInput = new ImString(32);
    private int tutorialStep = 0;
    private boolean isTutorialActive = false;
    private boolean isFirstFrame = true;
    private final float[] mainConfigPos = new float[2];
    private final float[] mainConfigSize = new float[2];
    private final float[] settingsPos = new float[2];
    private final float[] settingsSize = new float[2];
    private final float[] saveButtonPos = new float[2];
    private static final String DEFAULT_LAYOUT = "[Window][Dockspace Host]\nSize=1920,1080\nCollapsed=0\n\n[Window][Settings##Settings]\nSize=350,1080\nCollapsed=0\nDockId=0x00000004,0\n\n[Window][NickPaints Configuration##NickPaintsConfig]\nSize=350,1080\nCollapsed=0\nDockId=0x00000001,0\n\n[Window][DockspaceHost]\nPos=0,0\nSize=3440,1440\nCollapsed=0\n\n[Window][Debug##Default]\nPos=60,60\nSize=350,1080\nCollapsed=0\n\n[Window][\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 NickPaints##NickPaintsConfig]\nPos=0,0\nSize=350,1080\nCollapsed=0\nDockId=0x00000007,0\n\n[Window][\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438##Settings]\nPos=3172,0\nSize=350,1080\nCollapsed=0\nDockId=0x00000006,0\n\n[Docking][Data]\nDockSpace         ID=0x38A10747 Pos=0,24 Size=1920,1056\nDockSpace         ID=0xDAF01B52 Window=0x11EB8EBF Pos=0,0 Size=3440,1440 Split=X\n  DockNode        ID=0x00000007 Parent=0xDAF01B52 SizeRef=350,1440 Selected=0x690D7B6E\n  DockNode        ID=0x00000008 Parent=0xDAF01B52 SizeRef=3022,1440 Split=X\n    DockNode      ID=0x00000005 Parent=0x00000008 SizeRef=3170,1440 Split=X\n      DockNode    ID=0x00000003 Parent=0x00000005 SizeRef=1629,1080 Split=X\n        DockNode  ID=0x00000001 Parent=0x00000003 SizeRef=350,1080 Selected=0xB107EC98\n        DockNode  ID=0x00000002 Parent=0x00000003 SizeRef=1294,1080 CentralNode=1\n      DockNode    ID=0x00000004 Parent=0x00000005 SizeRef=350,1080 Selected=0x1C33C293\n    DockNode      ID=0x00000006 Parent=0x00000008 SizeRef=350,1440 Selected=0x8FAD21AA\n";

    public ImGuiScreen() {
        super((class_2561)class_2561.method_43470((String)"NickPaints ImGui Screen"));
    }

    @Override
    public void gradientNickname$render(ImGuiIO io) {
        if (this.isFirstFrame) {
            File iniFile;
            String iniPath = io.getIniFilename();
            if (iniPath != null && !iniPath.isEmpty() && !(iniFile = new File(iniPath)).exists()) {
                ImGui.loadIniSettingsFromMemory((String)DEFAULT_LAYOUT);
            }
            this.parseGradientString(ConfigManager.CONFIG.currentGradient);
            this.isTutorialActive = !ConfigManager.CONFIG.hasCompletedGuiTutorial;
            this.isFirstFrame = false;
        }
        this.setupDockspace();
        if (this.isTutorialActive) {
            ImGui.beginDisabled();
        }
        this.renderMainConfigurationWindow();
        this.renderSettingsWindow();
        if (this.isTutorialActive) {
            ImGui.endDisabled();
            this.renderTutorial();
        }
        ImGui.end();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void renderTutorial() {
        ImGui.getBackgroundDrawList().addRectFilled(0.0f, 0.0f, (float)class_310.method_1551().method_22683().method_4489(), (float)class_310.method_1551().method_22683().method_4506(), ImGui.getColorU32((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f));
        float tutorialWidth = 300.0f;
        float margin = 15.0f;
        float viewportWidth = ImGui.getMainViewport().getSizeX();
        float viewportHeight = ImGui.getMainViewport().getSizeY();
        switch (this.tutorialStep) {
            case 0: {
                float centerX = ImGui.getMainViewport().getPosX() + viewportWidth * 0.5f;
                float centerY = ImGui.getMainViewport().getPosY() + viewportHeight * 0.5f;
                ImGui.setNextWindowPos((float)centerX, (float)centerY, (int)8, (float)0.5f, (float)0.5f);
                if (!ImGui.begin((String)"WelcomePopup##Tutorial", (int)2097249)) break;
                ImGui.text((String)Lang.get("gui.nickpaints.tutorial.welcome.title"));
                ImGui.separator();
                ImGui.textWrapped((String)Lang.get("gui.nickpaints.tutorial.welcome.content"));
                ImGui.spacing();
                if (ImGui.button((String)Lang.get("gui.nickpaints.tutorial.button.start"))) {
                    ++this.tutorialStep;
                }
                if (ImGui.button((String)Lang.get("gui.nickpaints.tutorial.button.skip"))) {
                    ConfigManager.CONFIG.hasCompletedGuiTutorial = true;
                    ConfigManager.CONFIG.hasShownWelcomeMessage = true;
                    ConfigManager.saveConfig();
                    this.isTutorialActive = false;
                }
                ImGui.end();
                break;
            }
            case 1: {
                float step1X = this.mainConfigPos[0] + this.mainConfigSize[0] + 15.0f;
                if (step1X + 300.0f > viewportWidth) {
                    step1X = this.mainConfigPos[0] - 300.0f - 15.0f;
                }
                this.renderTutorialStep("gui.nickpaints.tutorial.step1", step1X, this.mainConfigPos[1]);
                break;
            }
            case 2: {
                float step2X = this.settingsPos[0] - 300.0f - 15.0f;
                if (step2X < 0.0f) {
                    step2X = this.settingsPos[0] + this.settingsSize[0] + 15.0f;
                }
                this.renderTutorialStep("gui.nickpaints.tutorial.step2", step2X, this.settingsPos[1]);
                break;
            }
            case 3: {
                float step3X = this.saveButtonPos[0];
                float step3Y = this.saveButtonPos[1] + 30.0f;
                if (this.saveButtonPos[1] > viewportHeight / 2.0f) {
                    step3Y = this.saveButtonPos[1] - 120.0f;
                }
                this.renderTutorialStep("gui.nickpaints.tutorial.step3", step3X, step3Y);
            }
        }
    }

    private void renderTutorialStep(String langKeyPrefix, float x, float y) {
        ImGui.setNextWindowSize((float)300.0f, (float)0.0f, (int)8);
        float viewportWidth = ImGui.getMainViewport().getSizeX();
        float viewportHeight = ImGui.getMainViewport().getSizeY();
        if (x + 300.0f > viewportWidth) {
            x = viewportWidth - 300.0f;
        }
        if (x < 0.0f) {
            x = 0.0f;
        }
        ImGui.setNextWindowPos((float)x, (float)y, (int)8);
        int flags = 38;
        if (ImGui.begin((String)Lang.get(langKeyPrefix + ".title"), (int)flags)) {
            float windowHeight = ImGui.getWindowSizeY();
            if (y + windowHeight > viewportHeight) {
                y = viewportHeight - windowHeight;
                ImGui.setWindowPos((float)x, (float)y);
            }
            if (y < 0.0f) {
                y = 0.0f;
                ImGui.setWindowPos((float)x, (float)y);
            }
            ImGui.textWrapped((String)Lang.get(langKeyPrefix + ".content"));
            ImGui.separator();
            if (this.tutorialStep < 3) {
                if (ImGui.button((String)Lang.get("gui.nickpaints.tutorial.button.next"))) {
                    ++this.tutorialStep;
                }
            } else if (ImGui.button((String)Lang.get("gui.nickpaints.tutorial.button.finish"))) {
                ConfigManager.CONFIG.hasCompletedGuiTutorial = true;
                ConfigManager.CONFIG.hasShownWelcomeMessage = true;
                ConfigManager.saveConfig();
                this.isTutorialActive = false;
            }
            ImGui.end();
        }
    }

    private void renderMainConfigurationWindow() {
        ImGui.begin((String)(Lang.get("gui.nickpaints.title") + "##NickPaintsConfig"));
        this.mainConfigPos[0] = ImGui.getWindowPosX();
        this.mainConfigPos[1] = ImGui.getWindowPosY();
        this.mainConfigSize[0] = ImGui.getWindowSizeX();
        this.mainConfigSize[1] = ImGui.getWindowSizeY();
        this.drawPreview(this.reconstructGradientString(), true);
        ImGui.separator();
        ImGui.checkbox((String)Lang.get("gui.nickpaints.mode.rainbow"), (ImBoolean)this.isRainbowMode);
        ImGui.separator();
        ImGui.pushItemWidth((float)-1.0f);
        if (this.isRainbowMode.get()) {
            ImGui.text((String)Lang.get("gui.nickpaints.option.speed"));
            ImGui.sliderInt((String)"##rainbowspeed", (int[])this.rainbowSpeed.getData(), (int)1000, (int)20000);
        } else {
            this.renderColorEditor();
            ImGui.text((String)Lang.get("gui.nickpaints.option.speed"));
            if (this.isStatic.get()) {
                ImGui.beginDisabled();
            }
            ImGui.sliderInt((String)"##speed", (int[])this.speed.getData(), (int)1000, (int)20000);
            if (this.isStatic.get()) {
                ImGui.endDisabled();
            }
            ImGui.text((String)Lang.get("gui.nickpaints.option.segment"));
            ImGui.sliderInt((String)"##segment", (int[])this.segment.getData(), (int)1, (int)200);
            ImGui.text((String)Lang.get("gui.nickpaints.option.angle"));
            ImGui.sliderInt((String)"##angle", (int[])this.angle.getData(), (int)0, (int)360);
        }
        ImGui.popItemWidth();
        ImGui.separator();
        if (!this.isRainbowMode.get()) {
            ImGui.checkbox((String)Lang.get("gui.nickpaints.option.static"), (ImBoolean)this.isStatic);
            ImGui.checkbox((String)Lang.get("gui.nickpaints.option.style_block"), (ImBoolean)this.isBlockStyle);
            ImGui.separator();
        }
        this.renderUtilities();
        if (ImGui.button((String)Lang.get("gui.nickpaints.button.save_sync"), (float)-1.0f, (float)0.0f)) {
            ConfigManager.CONFIG.currentGradient = this.reconstructGradientString();
            ConfigManager.saveConfig();
            if (class_310.method_1551().field_1724 != null) {
                WebSocketManager.syncMyPaint();
            }
        }
        this.saveButtonPos[0] = ImGui.getItemRectMinX();
        this.saveButtonPos[1] = ImGui.getItemRectMinY();
        ImGui.separator();
        this.renderPresets();
        ImGui.end();
    }

    private void renderSettingsWindow() {
        String username;
        ImGui.begin((String)(Lang.get("gui.nickpaints.settings.title") + "##Settings"));
        this.settingsPos[0] = ImGui.getWindowPosX();
        this.settingsPos[1] = ImGui.getWindowPosY();
        boolean globalEnabled = ConfigManager.CONFIG.globalRenderingEnabled;
        if (ImGui.checkbox((String)"##globaltoggle", (boolean)globalEnabled)) {
            ConfigManager.CONFIG.setGlobalRendering(!globalEnabled);
            ConfigManager.saveConfig();
        }
        ImGui.sameLine();
        ImGui.text((String)Lang.get("gui.nickpaints.settings.global_rendering"));
        boolean showOwnNametag = ConfigManager.CONFIG.showOwnNametag;
        if (ImGui.checkbox((String)"##showownnametag", (boolean)showOwnNametag)) {
            ConfigManager.CONFIG.showOwnNametag = !showOwnNametag;
            ConfigManager.saveConfig();
        }
        ImGui.sameLine();
        ImGui.text((String)Lang.get("gui.nickpaints.settings.show_own_nametag"));
        ImGui.separator();
        ImGui.text((String)Lang.get("gui.nickpaints.settings.disable_player_label"));
        ImGui.inputText((String)"##playerinput", (ImString)this.playerToDisableInput);
        ImGui.sameLine();
        if (ImGui.button((String)Lang.get("gui.nickpaints.settings.disable_button")) && !(username = this.playerToDisableInput.get()).isEmpty()) {
            MojangAPIHelper.getUuidForUsername(username).thenAccept(uuidOptional -> uuidOptional.ifPresent(uuid -> {
                ConfigManager.CONFIG.setPlayerRendering((UUID)uuid, username, false);
                ConfigManager.saveConfig();
            }));
            this.playerToDisableInput.set("");
        }
        this.renderPlayerSuggestions();
        ImGui.text((String)Lang.get("gui.nickpaints.settings.disabled_list"));
        ImGui.beginChild((String)"##disabledlist", (float)0.0f, (float)(-ImGui.getFrameHeightWithSpacing() * 2.0f), (boolean)true);
        if (ConfigManager.CONFIG.disabledPlayers.isEmpty()) {
            ImGui.textDisabled((String)Lang.get("gui.nickpaints.settings.none"));
        } else {
            ArrayList<Map.Entry<UUID, String>> disabledList = new ArrayList<Map.Entry<UUID, String>>(ConfigManager.CONFIG.disabledPlayers.entrySet());
            for (Map.Entry entry : disabledList) {
                if (ImGui.button((String)(Lang.get("gui.nickpaints.settings.reenable_button") + "##" + String.valueOf(entry.getKey())))) {
                    ConfigManager.CONFIG.setPlayerRendering((UUID)entry.getKey(), (String)entry.getValue(), true);
                    ConfigManager.saveConfig();
                }
                ImGui.sameLine();
                ImGui.text((String)((String)entry.getValue()));
            }
        }
        ImGui.endChild();
        if (ImGui.button((String)Lang.get("gui.nickpaints.settings.clear_cache_button"))) {
            WebSocketManager.clearCache();
        }
        ImGui.end();
    }

    private void renderPlayerSuggestions() {
        String currentInput = this.playerToDisableInput.get().toLowerCase();
        if (currentInput.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null || client.field_1724 == null) {
            return;
        }
        List suggestions = client.method_1562().method_2880().stream().map(class_640::method_2966).map(GameProfile::getName).filter(name -> !name.equalsIgnoreCase(client.field_1724.method_5477().getString())).filter(name -> name.toLowerCase().startsWith(currentInput)).filter(name -> !ConfigManager.CONFIG.disabledPlayers.containsValue(name)).collect(Collectors.toList());
        if (suggestions.size() == 1 && ((String)suggestions.get(0)).equalsIgnoreCase(currentInput)) {
            return;
        }
        if (!suggestions.isEmpty()) {
            ImGui.beginChild((String)"##suggestions", (float)ImGui.getContentRegionAvailX(), (float)Math.min(120.0f, (float)suggestions.size() * ImGui.getTextLineHeightWithSpacing() + 5.0f), (boolean)true);
            for (String suggestion : suggestions) {
                if (!ImGui.selectable((String)(suggestion + "##sugg"))) continue;
                this.playerToDisableInput.set(suggestion);
            }
            ImGui.endChild();
        }
    }

    private void drawPreview(String gradientString, boolean centered) {
        float startX;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        String playerName = client.field_1724.method_5477().getString();
        int totalLength = playerName.length();
        float startY = ImGui.getCursorScreenPosY();
        if (centered) {
            float textWidth = ImGui.calcTextSize((String)playerName).x;
            float windowWidth = ImGui.getWindowWidth();
            startX = ImGui.getWindowPosX() + (windowWidth - textWidth) / 2.0f;
        } else {
            startX = ImGui.getCursorScreenPosX();
        }
        float MC_CHAR_WIDTH = 8.0f;
        float MC_FONT_HEIGHT = 9.0f;
        int VERTICAL_SEGMENTS = 8;
        float currentX = startX;
        float fontHeight = ImGui.getTextLineHeight();
        for (int i = 0; i < playerName.length(); ++i) {
            String characterStr = String.valueOf(playerName.charAt(i));
            float charWidth = ImGui.calcTextSize((String)characterStr).x;
            float characterCenterX = ((float)i + 0.5f) * 8.0f;
            int topArgbColor = GradientUtil.get2DColor(gradientString, totalLength, characterCenterX, 0.0f);
            int bottomArgbColor = GradientUtil.get2DColor(gradientString, totalLength, characterCenterX, 9.0f);
            float segmentHeight = fontHeight / 8.0f;
            for (int vSeg = 0; vSeg < 8; ++vSeg) {
                float t = ((float)vSeg + 0.5f) / 8.0f;
                int interpolatedArgb = this.interpolateColor(topArgbColor, bottomArgbColor, t);
                int a = interpolatedArgb >> 24 & 0xFF;
                int r = interpolatedArgb >> 16 & 0xFF;
                int g = interpolatedArgb >> 8 & 0xFF;
                int b = interpolatedArgb & 0xFF;
                int abgrColor = a << 24 | b << 16 | g << 8 | r;
                float clipStartX = currentX;
                float clipStartY = startY + (float)vSeg * segmentHeight;
                float clipEndX = clipStartX + charWidth + 1.0f;
                float clipEndY = clipStartY + segmentHeight + 1.0f;
                ImGui.getWindowDrawList().pushClipRect(clipStartX, clipStartY, clipEndX, clipEndY, true);
                ImGui.getWindowDrawList().addText(currentX, startY, abgrColor, characterStr);
                ImGui.getWindowDrawList().popClipRect();
            }
            currentX += charWidth;
        }
        if (centered) {
            ImGui.dummy((float)0.0f, (float)ImGui.getTextLineHeightWithSpacing());
        } else {
            ImGui.dummy((float)(currentX - startX), (float)ImGui.getTextLineHeight());
        }
    }

    private int interpolateColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void renderColorEditor() {
        ImGui.text((String)Lang.get("gui.nickpaints.section.colors"));
        int colorToRemove = -1;
        for (int i = 0; i < this.colors.size(); ++i) {
            ImGui.pushID((int)i);
            ImGui.colorEdit3((String)"##color", (float[])this.colors.get(i), (int)32);
            if (this.colors.size() > 1) {
                ImGui.sameLine();
                if (ImGui.button((String)Lang.get("gui.nickpaints.button.remove"))) {
                    colorToRemove = i;
                }
            }
            ImGui.popID();
        }
        if (colorToRemove != -1) {
            this.colors.remove(colorToRemove);
        }
        if (ImGui.button((String)Lang.get("gui.nickpaints.button.add_color"))) {
            this.colors.add(new float[]{1.0f, 1.0f, 1.0f});
        }
    }

    private void renderUtilities() {
        String clipboardText;
        if (ImGui.button((String)Lang.get("gui.nickpaints.button.copy"))) {
            ImGui.setClipboardText((String)this.reconstructGradientString());
        }
        ImGui.sameLine();
        if (ImGui.button((String)Lang.get("gui.nickpaints.button.paste")) && (clipboardText = ImGui.getClipboardText()) != null && !clipboardText.isEmpty()) {
            this.parseGradientString(clipboardText);
        }
        ImGui.sameLine();
        String currentGradient = this.reconstructGradientString();
        int currentLength = currentGradient.length();
        int limit = 256;
        ImGui.text((String)Lang.get("gui.nickpaints.util.label_length"));
        ImGui.sameLine();
        Object valueText = String.format("%d/%d", currentLength, limit);
        if (currentLength > limit) {
            valueText = (String)valueText + Lang.get("gui.nickpaints.util.length_warning");
        }
        float r = 0.5f;
        float g = 1.0f;
        float b = 0.5f;
        if (currentLength > limit) {
            r = 1.0f;
            g = 0.2f;
            b = 0.2f;
        } else if (currentLength > limit - 30) {
            r = 1.0f;
            g = 1.0f;
            b = 0.2f;
        }
        ImGui.textColored((float)r, (float)g, (float)b, (float)1.0f, (String)valueText);
    }

    private void renderPresets() {
        int presetToDelete = -1;
        class_310 client = class_310.method_1551();
        String playerName = client != null && client.field_1724 != null ? client.field_1724.method_5477().getString() : "Preview";
        float previewWidth = ImGui.calcTextSize((String)playerName).x;
        float buttonSize = ImGui.getTextLineHeightWithSpacing();
        for (int i = 0; i < ConfigManager.CONFIG.presets.size(); ++i) {
            ImGui.pushID((int)i);
            if (ImGui.button((String)"+", (float)buttonSize, (float)buttonSize)) {
                this.parseGradientString(ConfigManager.CONFIG.presets.get(i));
            }
            if (ImGui.isItemHovered()) {
                ImGui.setTooltip((String)Lang.get("gui.nickpaints.tooltip.apply_preset"));
            }
            ImGui.sameLine();
            float startX = ImGui.getCursorPosX();
            float endX = ImGui.getWindowContentRegionMaxX() - buttonSize;
            float availableSpace = endX - startX;
            float previewStartX = startX + (availableSpace - previewWidth) / 2.0f;
            if (previewStartX > startX) {
                ImGui.setCursorPosX((float)previewStartX);
                this.drawPreview(ConfigManager.CONFIG.presets.get(i), false);
            }
            ImGui.sameLine();
            ImGui.setCursorPosX((float)endX);
            ImGui.pushStyleColor((int)21, (float)0.7f, (float)0.2f, (float)0.2f, (float)1.0f);
            ImGui.pushStyleColor((int)22, (float)0.9f, (float)0.3f, (float)0.3f, (float)1.0f);
            ImGui.pushStyleColor((int)23, (float)0.6f, (float)0.15f, (float)0.15f, (float)1.0f);
            if (ImGui.button((String)"-", (float)buttonSize, (float)buttonSize)) {
                presetToDelete = i;
            }
            ImGui.popStyleColor((int)3);
            if (ImGui.isItemHovered()) {
                ImGui.setTooltip((String)Lang.get("gui.nickpaints.tooltip.delete_preset"));
            }
            ImGui.popID();
        }
        ImGui.separator();
        if (ImGui.button((String)Lang.get("gui.nickpaints.button.save_preset"), (float)-1.0f, (float)0.0f)) {
            ConfigManager.CONFIG.presets.add(this.reconstructGradientString());
            ConfigManager.saveConfig();
        }
        if (presetToDelete != -1) {
            ConfigManager.CONFIG.presets.remove(presetToDelete);
            ConfigManager.saveConfig();
        }
    }

    private void parseGradientString(String gradientString) {
        String[] hexCodes;
        Matcher segmentMatcher;
        Matcher speedMatcher;
        if (gradientString == null || gradientString.isEmpty()) {
            this.colors.add(new float[]{1.0f, 1.0f, 1.0f});
            return;
        }
        Matcher rainbowMatcher = Pattern.compile("rainbow\\((\\d+)\\)").matcher(gradientString);
        if (rainbowMatcher.matches()) {
            this.isRainbowMode.set(true);
            this.rainbowSpeed.set(Integer.parseInt(rainbowMatcher.group(1)));
            return;
        }
        this.isRainbowMode.set(false);
        String tempString = gradientString.toLowerCase();
        Matcher angleMatcher = Pattern.compile("angle\\((\\d+)\\)").matcher(tempString);
        if (angleMatcher.find()) {
            this.angle.set(Integer.parseInt(angleMatcher.group(1)));
            tempString = angleMatcher.replaceAll("");
        }
        Matcher staticMatcher = Pattern.compile("static\\(true\\)").matcher(tempString);
        this.isStatic.set(staticMatcher.find());
        if (this.isStatic.get()) {
            tempString = staticMatcher.replaceAll("");
        }
        if ((speedMatcher = Pattern.compile("speed\\((\\d+)\\)").matcher(tempString)).find()) {
            this.speed.set(Integer.parseInt(speedMatcher.group(1)));
            tempString = speedMatcher.replaceAll("");
        }
        if ((segmentMatcher = Pattern.compile("segment\\((\\d+)\\)").matcher(tempString)).find()) {
            this.segment.set(Integer.parseInt(segmentMatcher.group(1)));
            tempString = segmentMatcher.replaceAll("");
        }
        Matcher styleMatcher = Pattern.compile("style\\((block)\\)").matcher(tempString);
        this.isBlockStyle.set(styleMatcher.find());
        if (this.isBlockStyle.get()) {
            tempString = styleMatcher.replaceAll("");
        }
        this.colors.clear();
        for (String hex : hexCodes = tempString.trim().split(",")) {
            if (hex.trim().isEmpty()) continue;
            try {
                Color c = Color.decode(hex.trim());
                this.colors.add(new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.colors.isEmpty()) {
            this.colors.add(new float[]{1.0f, 1.0f, 1.0f});
        }
    }

    private String reconstructGradientString() {
        if (this.isRainbowMode.get()) {
            return String.format("rainbow(%d)", this.rainbowSpeed.get());
        }
        StringBuilder sb = new StringBuilder();
        String colorsString = this.colors.stream().map(color -> String.format("#%02x%02x%02x", (int)(color[0] * 255.0f), (int)(color[1] * 255.0f), (int)(color[2] * 255.0f))).collect(Collectors.joining(", "));
        sb.append(colorsString);
        if (this.isStatic.get()) {
            sb.append(" static(true)");
        } else {
            sb.append(" speed(").append(this.speed.get()).append(")");
        }
        sb.append(" segment(").append(this.segment.get()).append(")");
        sb.append(" angle(").append(this.angle.get()).append(")");
        if (this.isBlockStyle.get()) {
            sb.append(" style(block)");
        }
        return sb.toString().trim();
    }

    private void setupDockspace() {
        int windowFlags = 2367655;
        ImGui.setNextWindowPos((float)0.0f, (float)0.0f, (int)1);
        ImGui.setNextWindowSize((float)class_310.method_1551().method_22683().method_4489(), (float)class_310.method_1551().method_22683().method_4506());
        ImGui.pushStyleVar((int)3, (float)0.0f);
        ImGui.pushStyleVar((int)4, (float)0.0f);
        ImGui.pushStyleVar((int)2, (float)0.0f, (float)0.0f);
        ImGui.begin((String)"DockspaceHost", (ImBoolean)new ImBoolean(true), (int)windowFlags);
        ImGui.popStyleVar((int)3);
        ImGui.pushStyleColor((int)39, (int)0, (int)0, (int)0, (int)0);
        int dockspaceId = ImGui.getID((String)"MainDockspace");
        ImGui.dockSpace((int)dockspaceId);
        ImGui.popStyleColor();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            ImGui.setWindowFocus(null);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25432() {
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        GLFW.glfwSetCursor((long)windowHandle, (long)0L);
        super.method_25432();
    }
}

