/*
 * Decompiled with CFR 0.152.
 */
package net.p4pingvin4ik.NickPaints.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class MojangAPIHelper {
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final String MOJANG_API_URL = "https://api.mojang.com/users/profiles/minecraft/";

    public static CompletableFuture<Optional<?>> getUuidForUsername(String username) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MOJANG_API_URL + username)).GET().build();
        return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                try {
                    JsonObject jsonObject = JsonParser.parseString((String)((String)response.body())).getAsJsonObject();
                    String uuidString = jsonObject.get("id").getAsString();
                    String formattedUuid = uuidString.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
                    return Optional.of(UUID.fromString(formattedUuid));
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }
            return Optional.empty();
        })).exceptionally(e -> Optional.empty());
    }
}

