/*
 * Decompiled with CFR 0.152.
 */
package net.p4pingvin4ik.NickPaints.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.p4pingvin4ik.NickPaints.client.NickPaintsMod;
import org.slf4j.Logger;

public class VersionChecker {
    private static final Logger LOGGER = NickPaintsMod.LOGGER;
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final String MODRINTH_PROJECT_SLUG = "nickpaints";
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/nickpaints/version";
    private static String pendingUpdateVersion = null;
    private static String pendingUpdateUrl = null;
    private static boolean hasNotifiedInSession = false;

    public static void checkForUpdates() {
        LOGGER.info("Checking for NickPaints updates via Modrinth API...");
        try {
            String gameVersion = class_310.method_1551().method_1515();
            String loadersParam = URLEncoder.encode("[\"fabric\"]", StandardCharsets.UTF_8);
            String gameVersionsParam = URLEncoder.encode("[\"" + gameVersion + "\"]", StandardCharsets.UTF_8);
            String urlWithParams = String.format("%s?loaders=%s&game_versions=%s", MODRINTH_API_URL, loadersParam, gameVersionsParam);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(urlWithParams)).GET().build();
            ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(VersionChecker::handleModrinthResponse)).exceptionally(error -> {
                LOGGER.error("Failed to check for updates from Modrinth.", error);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("Could not create Modrinth API request URI.", (Throwable)e);
        }
    }

    public static void onPlayerJoin() {
        if (pendingUpdateVersion != null && !hasNotifiedInSession) {
            VersionChecker.notifyPlayerInChat(pendingUpdateVersion, pendingUpdateUrl);
            hasNotifiedInSession = true;
        }
    }

    private static void handleModrinthResponse(String responseBody) {
        try {
            JsonArray versions = JsonParser.parseString((String)responseBody).getAsJsonArray();
            if (versions.size() == 0) {
                LOGGER.info("No compatible version found for this Minecraft version on Modrinth.");
                return;
            }
            for (JsonElement versionElement : versions) {
                String currentVersion;
                JsonObject versionObj = versionElement.getAsJsonObject();
                if (!"release".equals(versionObj.get("version_type").getAsString())) continue;
                String latestVersion = versionObj.get("version_number").getAsString();
                if (VersionChecker.isNewerVersion(latestVersion, currentVersion = VersionChecker.getCurrentModVersion())) {
                    LOGGER.info("A new version of NickPaints is available: {} (current: {})", (Object)latestVersion, (Object)currentVersion);
                    pendingUpdateVersion = latestVersion;
                    pendingUpdateUrl = "https://modrinth.com/mod/nickpaints/version/" + latestVersion;
                } else {
                    LOGGER.info("NickPaints is up to date. (Current: {}, Latest compatible: {})", (Object)currentVersion, (Object)latestVersion);
                }
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse update response from Modrinth.", (Throwable)e);
        }
    }

    private static void notifyPlayerInChat(String newVersion, String url) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)"[NickPaints] ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43469((String)"chat.nickpaints.update.main", (Object[])new Object[]{newVersion}).method_27692(class_124.field_1054)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"chat.nickpaints.update.link").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}).method_27694(style -> {
            try {
                class_2558.class_10608 clickEvent = new class_2558.class_10608(new URI(url));
                class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43471((String)"chat.nickpaints.update.hover"));
                return style.method_10958((class_2558)clickEvent).method_10949((class_2568)hoverEvent);
            }
            catch (Exception e) {
                return style;
            }
        }));
        client.field_1724.method_7353((class_2561)message, false);
    }

    private static String getCurrentModVersion() {
        return FabricLoader.getInstance().getModContainer(MODRINTH_PROJECT_SLUG).map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).orElse("0.0.0");
    }

    private static boolean isNewerVersion(String versionA, String versionB) {
        try {
            String[] partsA = versionA.split("\\.");
            String[] partsB = versionB.split("\\.");
            int length = Math.max(partsA.length, partsB.length);
            for (int i = 0; i < length; ++i) {
                int partB;
                int partA = i < partsA.length ? Integer.parseInt(partsA[i].split("-")[0]) : 0;
                int n = partB = i < partsB.length ? Integer.parseInt(partsB[i].split("-")[0]) : 0;
                if (partA > partB) {
                    return true;
                }
                if (partA >= partB) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not compare versions: '{}' and '{}'", (Object)versionA, (Object)versionB);
            return false;
        }
    }
}

