/*
 * Decompiled with CFR 0.152.
 */
package net.p4pingvin4ik.NickPaints.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.p4pingvin4ik.NickPaints.client.NickPaintsMod;
import net.p4pingvin4ik.NickPaints.config.ConfigManager;
import org.slf4j.Logger;

public class WebSocketManager
implements WebSocket.Listener {
    private static final int MAX_LOGGED_RECONNECT_ATTEMPTS = 5;
    private static int reconnectAttempts = 0;
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final Logger LOGGER = NickPaintsMod.LOGGER;
    private static final Gson gson = new Gson();
    public static final Map<UUID, String> paintCache = new ConcurrentHashMap<UUID, String>();
    private static final Set<UUID> uuidQueue = ConcurrentHashMap.newKeySet();
    private static volatile WebSocket webSocket;
    private static volatile boolean isAuthenticated;
    private static volatile boolean isConnecting;
    private static volatile boolean manuallyDisconnected;
    private static volatile boolean authenticationPermanentlyFailed;
    private static ScheduledExecutorService scheduler;
    private static ScheduledFuture<?> queueProcessorTask;
    private static final WebSocketManager INSTANCE;
    private static final Set<UUID> lastVisiblePlayers;
    private static int tickCounter;

    public static void connect() {
        manuallyDisconnected = false;
        authenticationPermanentlyFailed = false;
        if (isAuthenticated || isConnecting || class_310.method_1551().method_1548().method_44717() == null) {
            return;
        }
        isConnecting = true;
        try {
            if (reconnectAttempts == 0) {
                LOGGER.info("Connecting to NickPaints server...");
            }
            client.newWebSocketBuilder().header("X-API-Key", ConfigManager.CONFIG.apiKey).buildAsync(URI.create(ConfigManager.CONFIG.baseUrl), INSTANCE).exceptionally(e -> {
                isConnecting = false;
                if (reconnectAttempts <= 5) {
                    LOGGER.error("WebSocket connection failed to build: {}", (Object)e.getMessage());
                }
                WebSocketManager.handleDisconnection();
                return null;
            });
        }
        catch (Exception e2) {
            isConnecting = false;
            if (reconnectAttempts <= 5) {
                LOGGER.error("Failed to initiate WebSocket connection", (Throwable)e2);
            }
            WebSocketManager.handleDisconnection();
        }
    }

    public static void disconnect() {
        manuallyDisconnected = true;
        isAuthenticated = false;
        isConnecting = false;
        if (webSocket != null && !webSocket.isOutputClosed()) {
            webSocket.sendClose(1000, "Client shutting down");
            webSocket = null;
        }
        WebSocketManager.stopQueueProcessor();
        LOGGER.info("WebSocket disconnected manually.");
    }

    @Override
    public void onOpen(WebSocket ws) {
        webSocket = ws;
        isConnecting = false;
        LOGGER.info("WebSocket connection opened, awaiting authentication challenge...");
        ws.request(1L);
    }

    @Override
    public CompletionStage<?> onText(WebSocket ws, CharSequence data, boolean last) {
        try {
            JsonElement parsedElement = JsonParser.parseString((String)data.toString());
            if (!parsedElement.isJsonObject()) {
                LOGGER.warn("Received non-JSON-object message: {}", (Object)data);
                ws.request(1L);
                return null;
            }
            JsonObject message = parsedElement.getAsJsonObject();
            if (!message.has("type") || !message.has("payload")) {
                LOGGER.warn("Received message with missing 'type' or 'payload': {}", (Object)data);
                ws.request(1L);
                return null;
            }
            String type = message.get("type").getAsString();
            JsonElement payloadElement = message.get("payload");
            if (isAuthenticated) {
                switch (type) {
                    case "paintUpdate": {
                        this.handlePaintUpdate(payloadElement.getAsJsonObject());
                        break;
                    }
                    case "paintData": {
                        this.handlePaintData(payloadElement.getAsJsonArray());
                        break;
                    }
                    case "playerLeft": {
                        this.handlePlayerLeft(payloadElement.getAsJsonObject());
                    }
                }
            } else {
                switch (type) {
                    case "auth_challenge": {
                        this.handleAuthChallenge(ws, payloadElement.getAsJsonObject().get("authHash").getAsString());
                        break;
                    }
                    case "auth_success": {
                        this.handleAuthSuccess(payloadElement.getAsJsonObject());
                        break;
                    }
                    case "auth_failure": {
                        LOGGER.error("Authentication failed: {}", (Object)payloadElement.getAsJsonObject().get("error").getAsString());
                        authenticationPermanentlyFailed = true;
                        WebSocketManager.disconnect();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to process WebSocket message: {}", (Object)data.toString(), (Object)e);
        }
        ws.request(1L);
        return null;
    }

    public static void updateVisiblePlayers() {
        if (!isAuthenticated || webSocket == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        if (++tickCounter < 100) {
            return;
        }
        tickCounter = 0;
        class_310 client = class_310.method_1551();
        Set currentlyVisiblePlayers = client.field_1687.method_18456().stream().filter(player -> !player.method_5667().equals(client.field_1724.method_5667())).map(player -> player.method_5667()).collect(Collectors.toSet());
        if (!lastVisiblePlayers.equals(currentlyVisiblePlayers)) {
            lastVisiblePlayers.clear();
            lastVisiblePlayers.addAll(currentlyVisiblePlayers);
            List uuidsAsString = currentlyVisiblePlayers.stream().map(UUID::toString).collect(Collectors.toList());
            JsonObject payload = new JsonObject();
            payload.add("uuids", gson.toJsonTree(uuidsAsString));
            JsonObject message = new JsonObject();
            message.addProperty("type", "updateVisiblePlayers");
            message.add("payload", (JsonElement)payload);
            webSocket.sendText(gson.toJson((JsonElement)message), true);
        }
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        if (isAuthenticated && reconnectAttempts <= 5) {
            LOGGER.warn("WebSocket closed unexpectedly: {} - {}", (Object)statusCode, (Object)reason);
        }
        isAuthenticated = false;
        isConnecting = false;
        WebSocketManager.webSocket = null;
        WebSocketManager.handleDisconnection();
        return new CompletableFuture();
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        if (reconnectAttempts <= 5) {
            LOGGER.error("WebSocket error occurred: {}", (Object)error.getMessage());
        }
        isAuthenticated = false;
        isConnecting = false;
        WebSocketManager.webSocket = null;
        WebSocketManager.handleDisconnection();
    }

    private void handleAuthChallenge(WebSocket ws, String authHash) {
        class_310 client = class_310.method_1551();
        class_320 session = client.method_1548();
        JsonObject verifyPayload = new JsonObject();
        verifyPayload.addProperty("paint", ConfigManager.CONFIG.currentGradient);
        JsonObject verifyMessage = new JsonObject();
        if (client.method_1542()) {
            LOGGER.info("In singleplayer mode, using token authentication...");
            verifyMessage.addProperty("type", "auth_verify_token");
            verifyPayload.addProperty("uuid", session.method_44717().toString());
            verifyPayload.addProperty("accessToken", session.method_1674());
        } else {
            LOGGER.info("In multiplayer mode, using session authentication...");
            try {
                GameProfile gameProfile = new GameProfile(session.method_44717(), session.method_1676());
                client.method_1495().joinServer(gameProfile.getId(), session.method_1674(), authHash);
                verifyMessage.addProperty("type", "auth_verify_session");
                verifyPayload.addProperty("username", session.method_1676());
            }
            catch (AuthenticationException e) {
                LOGGER.error("Session authentication failed. This can happen with a cracked client or invalid session. Disabling auto-reconnect.");
                authenticationPermanentlyFailed = true;
                WebSocketManager.disconnect();
                return;
            }
        }
        verifyMessage.add("payload", (JsonElement)verifyPayload);
        ws.sendText(gson.toJson((JsonElement)verifyMessage), true);
    }

    private void handleAuthSuccess(JsonObject payload) {
        isAuthenticated = true;
        String username = payload.get("username").getAsString();
        if (reconnectAttempts > 0) {
            LOGGER.info("Successfully authenticated with server after {} attempt(s). Welcome, {}!", (Object)reconnectAttempts, (Object)username);
        } else {
            LOGGER.info("Authentication successful. Welcome, {}!", (Object)username);
        }
        reconnectAttempts = 0;
        WebSocketManager.startQueueProcessor();
    }

    private void handlePaintUpdate(JsonObject payload) {
        UUID uuid = UUID.fromString(payload.get("uuid").getAsString());
        String paint = payload.has("paint") ? payload.get("paint").getAsString() : "";
        paintCache.put(uuid, paint);
    }

    private void handlePaintData(JsonArray paints) {
        for (JsonElement element : paints) {
            JsonObject paintObj = element.getAsJsonObject();
            UUID uuid = UUID.fromString(paintObj.get("uuid").getAsString());
            String paint = paintObj.has("paint") ? paintObj.get("paint").getAsString() : "";
            paintCache.put(uuid, paint);
        }
    }

    private void handlePlayerLeft(JsonObject payload) {
        UUID uuid = UUID.fromString(payload.get("uuid").getAsString());
        paintCache.remove(uuid);
    }

    private static void handleDisconnection() {
        WebSocketManager.stopQueueProcessor();
        if (isAuthenticated || isConnecting) {
            isAuthenticated = false;
            return;
        }
        WebSocketManager.scheduleReconnect();
    }

    private static void scheduleReconnect() {
        if (isConnecting || manuallyDisconnected || authenticationPermanentlyFailed) {
            return;
        }
        isConnecting = true;
        long delay = 10L;
        if (++reconnectAttempts <= 5) {
            LOGGER.warn("Connection lost. Reconnecting...");
        } else if (reconnectAttempts == 6) {
            LOGGER.warn("Max logged reconnection attempts reached. Further attempts will be silent.");
        }
        CompletableFuture.delayedExecutor(delay, TimeUnit.SECONDS).execute(() -> {
            isConnecting = false;
            WebSocketManager.connect();
        });
    }

    private static void startQueueProcessor() {
        if (scheduler == null || scheduler.isShutdown()) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("NickPaints-Queue-Processor-%d").setDaemon(true).build();
            scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
            queueProcessorTask = scheduler.scheduleAtFixedRate(WebSocketManager::processQueue, 2L, 2L, TimeUnit.SECONDS);
            LOGGER.info("Queue processor started.");
        }
    }

    private static void stopQueueProcessor() {
        if (queueProcessorTask != null && !queueProcessorTask.isDone()) {
            queueProcessorTask.cancel(false);
            queueProcessorTask = null;
        }
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
            scheduler = null;
        }
    }

    public static void syncMyPaint() {
        if (!isAuthenticated) {
            WebSocketManager.sendMessageToPlayer((class_2561)class_2561.method_43469((String)"chat.nickpaints.sync.failure", (Object[])new Object[]{"Not authenticated"}).method_27692(class_124.field_1061));
            return;
        }
        WebSocketManager.sendPaintUpdateInternal();
        WebSocketManager.sendMessageToPlayer((class_2561)class_2561.method_43471((String)"chat.nickpaints.sync.success").method_27692(class_124.field_1060));
    }

    public static void syncMyPaintSilently(UUID myUuid) {
        if (myUuid == null || !isAuthenticated) {
            return;
        }
        WebSocketManager.sendPaintUpdateInternal();
    }

    private static void sendPaintUpdateInternal() {
        if (!isAuthenticated || webSocket == null) {
            return;
        }
        String myPaint = ConfigManager.CONFIG.currentGradient;
        JsonObject payload = new JsonObject();
        payload.addProperty("paint", myPaint);
        JsonObject message = new JsonObject();
        message.addProperty("type", "updatePaint");
        message.add("payload", (JsonElement)payload);
        webSocket.sendText(gson.toJson((JsonElement)message), true);
    }

    public static void queuePaintForPlayer(UUID playerUuid) {
        if (playerUuid != null && !paintCache.containsKey(playerUuid)) {
            uuidQueue.add(playerUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processQueue() {
        ArrayList<UUID> uuidsToProcess;
        if (uuidQueue.isEmpty() || !isAuthenticated || webSocket == null) {
            return;
        }
        Set<UUID> set = uuidQueue;
        synchronized (set) {
            uuidsToProcess = new ArrayList<UUID>(uuidQueue);
            uuidQueue.clear();
        }
        for (int i = 0; i < uuidsToProcess.size(); i += 30) {
            List batchUuids = uuidsToProcess.subList(i, Math.min(i + 30, uuidsToProcess.size()));
            List<String> batchStrings = batchUuids.stream().map(UUID::toString).toList();
            JsonObject payload = new JsonObject();
            JsonArray uuidsAsJson = new JsonArray();
            batchStrings.forEach(arg_0 -> ((JsonArray)uuidsAsJson).add(arg_0));
            payload.add("uuids", (JsonElement)uuidsAsJson);
            JsonObject message = new JsonObject();
            message.addProperty("type", "requestPaints");
            message.add("payload", (JsonElement)payload);
            webSocket.sendText(gson.toJson((JsonElement)message), true);
        }
    }

    public static void clearCache() {
        paintCache.clear();
        uuidQueue.clear();
        LOGGER.info("All NickPaints caches have been cleared.");
    }

    private static void sendMessageToPlayer(class_2561 message) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            client.field_1724.method_7353(message, false);
        }
    }

    static {
        isAuthenticated = false;
        isConnecting = false;
        manuallyDisconnected = false;
        authenticationPermanentlyFailed = false;
        INSTANCE = new WebSocketManager();
        lastVisiblePlayers = new CopyOnWriteArraySet<UUID>();
        tickCounter = 0;
    }
}

