/*
 * Decompiled with CFR 0.152.
 */
package net.p4pingvin4ik.NickPaints.client.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.p4pingvin4ik.NickPaints.client.ImGuiScreen;
import net.p4pingvin4ik.NickPaints.client.MojangAPIHelper;
import net.p4pingvin4ik.NickPaints.client.WebSocketManager;
import net.p4pingvin4ik.NickPaints.config.ConfigManager;

public class NickPaintsCommands {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register(NickPaintsCommands::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"nickpaints").executes(context -> {
            class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new ImGuiScreen()));
            return 1;
        })).then(ClientCommandManager.literal((String)"clear-cache").executes(context -> {
            WebSocketManager.clearCache();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"NickPaints cache cleared. Nicknames will be re-fetched."));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggle").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"global").executes(context -> {
            boolean newState = ConfigManager.CONFIG.setGlobalRendering(!ConfigManager.CONFIG.globalRenderingEnabled);
            ConfigManager.saveConfig();
            NickPaintsCommands.sendToggleFeedback((FabricClientCommandSource)context.getSource(), "Global paint rendering", newState);
            return 1;
        })).then(ClientCommandManager.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            ConfigManager.CONFIG.setGlobalRendering(enabled);
            ConfigManager.saveConfig();
            NickPaintsCommands.sendToggleFeedback((FabricClientCommandSource)context.getSource(), "Global paint rendering", enabled);
            return 1;
        })))).then(ClientCommandManager.literal((String)"player").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests(NickPaintsCommands::getPlayerSuggestions).executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"username");
            NickPaintsCommands.togglePlayerSetting((FabricClientCommandSource)context.getSource(), username, null);
            return 1;
        })).then(ClientCommandManager.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            String username = StringArgumentType.getString((CommandContext)context, (String)"username");
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            NickPaintsCommands.togglePlayerSetting((FabricClientCommandSource)context.getSource(), username, enabled);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"list").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"--- NickPaints Settings ---").method_27692(class_124.field_1054));
            class_5250 globalStatus = class_2561.method_43470((String)"Global Rendering: ").method_10852((class_2561)(ConfigManager.CONFIG.globalRenderingEnabled ? class_2561.method_43470((String)"ENABLED").method_27692(class_124.field_1060) : class_2561.method_43470((String)"DISABLED").method_27692(class_124.field_1061)));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)globalStatus);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Disabled players:").method_27692(class_124.field_1054));
            if (ConfigManager.CONFIG.disabledPlayers.isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"  None").method_27692(class_124.field_1080));
            } else {
                ConfigManager.CONFIG.disabledPlayers.forEach((uuid, name) -> ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("  - " + name)).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(" (" + uuid.toString() + ")")).method_27692(class_124.field_1063))));
            }
            return 1;
        }))));
    }

    private static CompletableFuture<Suggestions> getPlayerSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        String input = builder.getRemaining().toLowerCase();
        ((FabricClientCommandSource)context.getSource()).method_9262().stream().filter(name -> name.toLowerCase().startsWith(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        ConfigManager.CONFIG.getDisabledPlayerNames().stream().filter(name -> name.toLowerCase().startsWith(input)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static void togglePlayerSetting(FabricClientCommandSource source, String username, Boolean enabledState) {
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Resolving " + username + "...")).method_27692(class_124.field_1080));
        MojangAPIHelper.getUuidForUsername(username).thenAccept(uuidOptional -> source.getClient().execute(() -> {
            if (uuidOptional.isEmpty()) {
                source.sendError((class_2561)class_2561.method_43470((String)("Player '" + username + "' not found via Mojang API.")));
                return;
            }
            UUID playerUuid = (UUID)uuidOptional.get();
            boolean isCurrentlyDisabled = ConfigManager.CONFIG.disabledPlayers.containsKey(playerUuid);
            boolean newState = enabledState != null ? enabledState : isCurrentlyDisabled;
            ConfigManager.CONFIG.setPlayerRendering(playerUuid, username, newState);
            ConfigManager.saveConfig();
            NickPaintsCommands.sendToggleFeedback(source, "Paint rendering for " + username, newState);
        }));
    }

    private static void sendToggleFeedback(FabricClientCommandSource source, String action, boolean enabled) {
        class_5250 status = enabled ? class_2561.method_43470((String)"ENABLED").method_27692(class_124.field_1060) : class_2561.method_43470((String)"DISABLED").method_27692(class_124.field_1061);
        source.sendFeedback((class_2561)class_2561.method_43470((String)(action + " set to ")).method_10852((class_2561)status));
    }
}

