/*
 * Decompiled with CFR 0.152.
 */
package net.p4pingvin4ik.NickPaints.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.p4pingvin4ik.NickPaints.client.NickPaintsMod;
import net.p4pingvin4ik.NickPaints.config.NickPaintsConfig;
import org.slf4j.Logger;

public class ConfigManager {
    private static final Logger LOGGER = NickPaintsMod.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("nickpaints.json").toFile();
    public static NickPaintsConfig CONFIG;

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                CONFIG = (NickPaintsConfig)GSON.fromJson((Reader)reader, NickPaintsConfig.class);
                if (CONFIG == null) {
                    throw new IOException("Config file is empty or malformed.");
                }
                if (ConfigManager.CONFIG.disabledPlayers == null) {
                    ConfigManager.CONFIG.disabledPlayers = new HashMap<UUID, String>();
                }
                LOGGER.info("NickPaints configuration loaded successfully.");
            }
            catch (Exception e) {
                LOGGER.error("Could not read NickPaints config file, creating new default config.", (Throwable)e);
                CONFIG = new NickPaintsConfig();
            }
        } else {
            LOGGER.info("No NickPaints config file found, creating a new one.");
            CONFIG = new NickPaintsConfig();
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
            LOGGER.debug("NickPaints configuration saved.");
        }
        catch (IOException e) {
            LOGGER.error("Could not save NickPaints config file.", (Throwable)e);
        }
    }
}

