/*
 * Decompiled with CFR 0.152.
 */
package net.p4pingvin4ik.NickPaints.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradientUtil {
    private static final Pattern ANGLE_PATTERN = Pattern.compile("angle\\(-?(\\d+)\\)");
    private static final Pattern RAINBOW_PATTERN = Pattern.compile("rainbow\\((\\d+)\\)");
    private static final Pattern SPEED_PATTERN = Pattern.compile("speed\\((\\d+)\\)");
    private static final Pattern SEGMENT_PATTERN = Pattern.compile("segment\\((\\d+)\\)");
    private static final Pattern STATIC_PATTERN = Pattern.compile("static\\(true\\)");
    private static final Pattern STYLE_PATTERN = Pattern.compile("style\\((block)\\)");
    private static final long MIN_ANIMATION_SPEED = 1000L;

    public static int get2DColor(String gradientString, int totalLength, float localX, float localY) {
        float progress;
        float timeOffset;
        if (gradientString == null || gradientString.trim().isEmpty()) {
            return Color.WHITE.getRGB();
        }
        GradientOptions options = GradientUtil.parseOptions(gradientString, totalLength);
        if (RAINBOW_PATTERN.matcher(gradientString.toLowerCase().trim()).matches()) {
            return GradientUtil.get2DRainbowColor(options, localX, localY);
        }
        if (options.colors().isEmpty()) {
            return Color.WHITE.getRGB();
        }
        if (options.colors().size() == 1) {
            return options.colors().get(0).getRGB();
        }
        float angleRad = (float)Math.toRadians(options.angle());
        float cos = (float)Math.cos(angleRad);
        float sin = (float)Math.sin(angleRad);
        float projectedPosition = localX * cos + localY * sin;
        float f = timeOffset = options.isStatic() ? 0.0f : (float)(System.currentTimeMillis() % options.speed()) / (float)options.speed();
        if (options.isSegmentUserDefined()) {
            progress = (projectedPosition / options.segmentLength() + timeOffset) % 1.0f;
        } else {
            float textWidth = (float)totalLength * 8.0f;
            float fontHeight = 9.0f;
            float minProjected = 0.0f;
            if (cos < 0.0f) {
                minProjected += textWidth * cos;
            }
            if (sin < 0.0f) {
                minProjected += fontHeight * sin;
            }
            float normalizedPosition = projectedPosition - minProjected;
            progress = (normalizedPosition / options.segmentLength() + timeOffset) % 1.0f;
        }
        if (progress < 0.0f) {
            progress += 1.0f;
        }
        return options.isBlockStyle() ? GradientUtil.getBlockColor(options.colors(), progress) : GradientUtil.blendColors(options.colors(), progress);
    }

    public static int getColor(String gradientString, int charIndex, int totalChars) {
        if (totalChars <= 0 || gradientString == null || gradientString.trim().isEmpty()) {
            return Color.WHITE.getRGB();
        }
        if (RAINBOW_PATTERN.matcher(gradientString.toLowerCase().trim()).matches()) {
            return GradientUtil.getRainbowColor(gradientString, charIndex, totalChars);
        }
        GradientOptions options = GradientUtil.parseOptions(gradientString, totalChars);
        if (options.colors().isEmpty()) {
            return Color.WHITE.getRGB();
        }
        if (options.colors().size() == 1) {
            return options.colors().get(0).getRGB();
        }
        float timeOffset = options.isStatic() ? 0.0f : (float)(System.currentTimeMillis() % options.speed()) / (float)options.speed();
        float progress = ((float)charIndex / options.segmentLength() + timeOffset) % 1.0f;
        if (progress < 0.0f) {
            progress += 1.0f;
        }
        return options.isBlockStyle() ? GradientUtil.getBlockColor(options.colors(), progress) : GradientUtil.blendColors(options.colors(), progress);
    }

    public static GradientOptions parseOptions(String gradientString, int totalChars) {
        float segmentLength;
        Matcher segmentMatcher;
        Matcher styleMatcher;
        Matcher speedMatcher;
        Matcher staticMatcher;
        float FONT_HEIGHT = 9.0f;
        float AVG_CHAR_WIDTH = 8.0f;
        long speed = 4000L;
        boolean isStatic = false;
        boolean isBlockStyle = false;
        boolean isSegmentUserDefined = false;
        float angle = 45.0f;
        String cleanGradientString = gradientString;
        Matcher angleMatcher = ANGLE_PATTERN.matcher(cleanGradientString.toLowerCase());
        if (angleMatcher.find()) {
            try {
                angle = Float.parseFloat(angleMatcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cleanGradientString = angleMatcher.replaceAll("").trim();
        }
        if ((staticMatcher = STATIC_PATTERN.matcher(cleanGradientString.toLowerCase())).find()) {
            isStatic = true;
            cleanGradientString = staticMatcher.replaceAll("").trim();
        }
        if ((speedMatcher = SPEED_PATTERN.matcher(cleanGradientString.toLowerCase())).find()) {
            try {
                speed = Math.max(1000L, Long.parseLong(speedMatcher.group(1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cleanGradientString = speedMatcher.replaceAll("").trim();
        }
        if ((styleMatcher = STYLE_PATTERN.matcher(cleanGradientString.toLowerCase())).find()) {
            if ("block".equals(styleMatcher.group(1))) {
                isBlockStyle = true;
            }
            cleanGradientString = styleMatcher.replaceAll("").trim();
        }
        if ((segmentMatcher = SEGMENT_PATTERN.matcher(cleanGradientString.toLowerCase())).find()) {
            isSegmentUserDefined = true;
            try {
                segmentLength = Integer.parseInt(segmentMatcher.group(1));
            }
            catch (NumberFormatException e) {
                segmentLength = (float)totalChars * 8.0f;
            }
            cleanGradientString = segmentMatcher.replaceAll("").trim();
        } else {
            isSegmentUserDefined = false;
            float angleRad = (float)Math.toRadians(angle);
            float textWidth = (float)totalChars * 8.0f;
            segmentLength = (float)(Math.abs((double)textWidth * Math.cos(angleRad)) + Math.abs(9.0 * Math.sin(angleRad)));
        }
        if (segmentLength < 1.0f) {
            segmentLength = 1.0f;
        }
        List<Color> colors = GradientUtil.parseHexColors(cleanGradientString);
        return new GradientOptions(speed, segmentLength, isStatic, isBlockStyle, angle, isSegmentUserDefined, colors);
    }

    private static int get2DRainbowColor(GradientOptions options, float localX, float localY) {
        float angleRad = (float)Math.toRadians(options.angle());
        float cos = (float)Math.cos(angleRad);
        float sin = (float)Math.sin(angleRad);
        float projectedPosition = localX * cos + localY * sin;
        float timeOffset = (float)(System.currentTimeMillis() % options.speed()) / (float)options.speed();
        float hue = timeOffset - projectedPosition * 0.1f;
        return Color.HSBtoRGB(hue % 1.0f, 0.8f, 1.0f);
    }

    private static List<Color> parseHexColors(String hexString) {
        String[] hexColorArray;
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String hex : hexColorArray = hexString.split(",")) {
            if (hex.trim().isEmpty()) continue;
            try {
                colors.add(Color.decode(hex.trim()));
            }
            catch (NumberFormatException e) {
                return new ArrayList<Color>();
            }
        }
        return colors;
    }

    private static int getRainbowColor(String gradientString, int charIndex, int totalChars) {
        Matcher rainbowMatcher = RAINBOW_PATTERN.matcher(gradientString.toLowerCase().trim());
        if (!rainbowMatcher.matches()) {
            return Color.WHITE.getRGB();
        }
        long speed = 3000L;
        try {
            speed = Math.max(1000L, Long.parseLong(rainbowMatcher.group(1)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float hue = (float)(System.currentTimeMillis() % speed) / (float)speed - (float)charIndex / (float)totalChars * 0.5f;
        return Color.HSBtoRGB(hue, 0.8f, 1.0f);
    }

    private static int blendColors(List<Color> colors, float progress) {
        float colorIndexFloat = progress * (float)(colors.size() - 1);
        int index1 = (int)colorIndexFloat;
        int index2 = Math.min(index1 + 1, colors.size() - 1);
        float blendFactor = colorIndexFloat - (float)index1;
        Color c1 = colors.get(index1);
        Color c2 = colors.get(index2);
        int r = (int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * blendFactor);
        int g = (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * blendFactor);
        int b = (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * blendFactor);
        return new Color(r, g, b).getRGB();
    }

    private static int getBlockColor(List<Color> colors, float progress) {
        int index = (int)(progress * (float)colors.size());
        index = Math.max(0, Math.min(colors.size() - 1, index));
        return colors.get(index).getRGB();
    }

    public record GradientOptions(long speed, float segmentLength, boolean isStatic, boolean isBlockStyle, float angle, boolean isSegmentUserDefined, List<Color> colors) {
    }
}

