/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigForce {
    private final JavaPlugin plugin;
    private final String CONFIG_VERSION_PATH = "version";

    public ConfigForce(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void checkAndUpdateConfig() {
        String configVersion;
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.saveDefaultConfig();
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
            newConfig.set("version", (Object)this.plugin.getDescription().getVersion());
            try {
                newConfig.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        FileConfiguration currentConfig = this.plugin.getConfig();
        String pluginVersion = this.plugin.getDescription().getVersion();
        if (!pluginVersion.equals(configVersion = currentConfig.getString("version", "none"))) {
            this.updateConfigWithPreservedValues(currentConfig);
        }
    }

    private void updateConfigWithPreservedValues(FileConfiguration oldConfig) {
        HashMap<String, Object> preservedValues = new HashMap<String, Object>();
        this.collectValues("", oldConfig, preservedValues);
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (configFile.exists()) {
            configFile.delete();
        }
        this.plugin.saveDefaultConfig();
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
        for (Map.Entry entry : preservedValues.entrySet()) {
            if (!newConfig.contains((String)entry.getKey())) continue;
            newConfig.set((String)entry.getKey(), entry.getValue());
        }
        newConfig.set("version", (Object)this.plugin.getDescription().getVersion());
        try {
            newConfig.save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.plugin.reloadConfig();
    }

    private void collectValues(String path, FileConfiguration config, Map<String, Object> map) {
        if (config.getConfigurationSection(path) == null) {
            return;
        }
        for (String key : config.getConfigurationSection(path).getKeys(false)) {
            String fullPath;
            String string = fullPath = path.equals("") ? key : path + "." + key;
            if (config.isConfigurationSection(fullPath)) {
                this.collectValues(fullPath, config, map);
                continue;
            }
            map.put(fullPath, config.get(fullPath));
        }
    }
}

