/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.manager.CombatManager;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class Death
implements Listener {
    private final Plugin plugin;
    private final CombatManager combat;

    public Death(Plugin plugin, CombatManager combat) {
        this.plugin = plugin;
        this.combat = combat;
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        boolean inCombat = this.combat.isInCombat(p.getUniqueId());
        Location loc = p.getLocation().getBlock().getLocation().add(0.5, 0.1, 0.5);
        if (inCombat && this.plugin.getConfig().getBoolean("combat-death-sound.enabled")) {
            this.playSound(loc, "combat-death-sound");
        }
        if (!inCombat && this.plugin.getConfig().getBoolean("normal-death-sound.enabled")) {
            this.playSound(loc, "normal-death-sound");
        }
        if (inCombat && this.plugin.getConfig().getBoolean("combat-death-particles.enabled")) {
            this.spawnParticles(loc, "combat-death-particles");
        }
        if (!inCombat && this.plugin.getConfig().getBoolean("normal-death-particles.enabled")) {
            this.spawnParticles(loc, "normal-death-particles");
        }
    }

    private void playSound(Location loc, String path) {
        String soundName = this.plugin.getConfig().getString(path + ".sound", "minecraft:entity.wither.shoot");
        float volume = (float)this.plugin.getConfig().getDouble(path + ".volume", 1.0);
        float pitch = (float)this.plugin.getConfig().getDouble(path + ".pitch", 1.0);
        try {
            Sound s = Sound.valueOf((String)soundName.toUpperCase().replace("MINECRAFT:", ""));
            loc.getWorld().playSound(loc, s, volume, pitch);
        }
        catch (Exception ex) {
            loc.getWorld().playSound(loc, soundName, SoundCategory.MASTER, volume, pitch);
        }
    }

    private void spawnParticles(Location loc, String path) {
        Particle particle;
        String particleName = this.plugin.getConfig().getString(path + ".particle", "SCULK_SOUL");
        int amount = this.plugin.getConfig().getInt(path + ".amount", 10);
        double ox = this.plugin.getConfig().getDouble(path + ".offset-x", 0.5);
        double oy = this.plugin.getConfig().getDouble(path + ".offset-y", 0.25);
        double oz = this.plugin.getConfig().getDouble(path + ".offset-z", 0.5);
        double speed = this.plugin.getConfig().getDouble(path + ".speed", 0.0);
        try {
            particle = Particle.valueOf((String)particleName.toUpperCase());
        }
        catch (Exception e) {
            particle = Particle.SCULK_SOUL;
        }
        Location finalLoc = loc;
        Particle finalParticle = particle;
        double fx = ox;
        double fy = oy;
        double fz = oz;
        double fs = speed;
        for (int i = 0; i < amount; ++i) {
            int delay = this.randomDelay();
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> finalLoc.getWorld().spawnParticle(finalParticle, finalLoc, 1, fx, fy, fz, fs), (long)delay);
        }
    }

    private int randomDelay() {
        int ms = ThreadLocalRandom.current().nextInt(0, 11);
        return ms < 8 ? 0 : 1;
    }
}

