/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Secure {
    private static final String KEY = "MySuperSecretKey!";
    private static final String IV = "MyInitVector1234";

    public static String encryptString(String plain) throws Exception {
        byte[] keyBytes = Secure.normalizeKey(KEY);
        SecretKeySpec skey = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(IV.getBytes("UTF-8"));
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)skey, ivSpec);
        byte[] encrypted = cipher.doFinal(plain.getBytes("UTF-8"));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static String decryptString(String cipherText) throws Exception {
        byte[] keyBytes = Secure.normalizeKey(KEY);
        SecretKeySpec skey = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(IV.getBytes("UTF-8"));
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)skey, ivSpec);
        byte[] decoded = Base64.getDecoder().decode(cipherText);
        byte[] original = cipher.doFinal(decoded);
        return new String(original, "UTF-8");
    }

    private static byte[] normalizeKey(String k) throws Exception {
        byte[] kb = k.getBytes("UTF-8");
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        byte[] hashed = sha.digest(kb);
        byte[] keyBytes = new byte[32];
        System.arraycopy(hashed, 0, keyBytes, 0, 32);
        return keyBytes;
    }

    public static byte[] hashFile(Path p, String algorithm) throws Exception {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] buf = new byte[8192];
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            int r;
            while ((r = is.read(buf)) != -1) {
                md.update(buf, 0, r);
            }
        }
        return md.digest();
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int v = b & 0xFF;
            String hex = Integer.toHexString(v);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static boolean encryptedFileExists(String encryptedPath) {
        try {
            String path = Secure.decryptString(encryptedPath);
            return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String hashFileHex(String path, String algorithm) throws Exception {
        byte[] h = Secure.hashFile(Paths.get(path, new String[0]), algorithm);
        return Secure.bytesToHex(h);
    }

    public static void printEncryptedList(String[] paths) throws Exception {
        for (String p : paths) {
            System.out.println(Secure.encryptString(p));
        }
    }
}

