/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class CombatCommandBlockListener
implements Listener {
    private final MinecraftHelden plugin;
    private static final String BYPASS_PERM = "heroes.combat.bypass.commands";

    public CombatCommandBlockListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        UUID id = e.getPlayer().getUniqueId();
        if (e.getPlayer().hasPermission(BYPASS_PERM)) {
            return;
        }
        try {
            if (this.plugin.combat() != null && this.plugin.combat().isInCombat(id)) {
                e.setCancelled(true);
                Msg.send((CommandSender)e.getPlayer(), "&cDu bist im Kampf! Befehle sind vor\u00fcbergehend gesperrt.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

