/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ArmorLockManager {
    private final MinecraftHelden plugin;
    private final Map<UUID, EnumMap<ArmorSlot, Long>> lockEnd;
    private final Map<UUID, EnumMap<ArmorSlot, Integer>> lastAnnouncedMinute;
    private final Map<UUID, EnumMap<ArmorSlot, Long>> cooldownEnd;
    private boolean enabled;
    private BukkitTask tick;
    private int defaultMinutes;
    private int cooldownSeconds;
    private final File file;
    private FileConfiguration cfg;

    public ArmorLockManager(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.lockEnd = new ConcurrentHashMap<UUID, EnumMap<ArmorSlot, Long>>();
        this.lastAnnouncedMinute = new ConcurrentHashMap<UUID, EnumMap<ArmorSlot, Integer>>();
        this.cooldownEnd = new ConcurrentHashMap<UUID, EnumMap<ArmorSlot, Long>>();
        this.enabled = true;
        this.file = new File(plugin.getDataFolder(), "armorlock.yml");
        this.loadFromDisk();
        this.reload();
        this.startTicker();
    }

    public void reload() {
        this.defaultMinutes = Math.max(1, this.plugin.getConfig().getInt("armorlock.minutes", 10));
        this.cooldownSeconds = Math.max(0, this.plugin.getConfig().getInt("armorlock.cooldown", 0));
    }

    public void shutdown() {
        this.saveNow();
        if (this.tick != null) {
            this.tick.cancel();
            this.tick = null;
        }
        this.lockEnd.clear();
        this.lastAnnouncedMinute.clear();
        this.cooldownEnd.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLocked(UUID id, ArmorSlot slot) {
        long now = System.currentTimeMillis();
        Long until = (Long)this.lockEnd.getOrDefault(id, new EnumMap(ArmorSlot.class)).get((Object)slot);
        return until != null && until > now;
    }

    public boolean isInCooldown(UUID id, ArmorSlot slot) {
        long now = System.currentTimeMillis();
        Long until = (Long)this.cooldownEnd.getOrDefault(id, new EnumMap(ArmorSlot.class)).get((Object)slot);
        return until != null && until > now;
    }

    public void startLock(Player p, ArmorSlot slot) {
        if (p == null || slot == null) {
            return;
        }
        UUID id = p.getUniqueId();
        if (this.isInCooldown(id, slot)) {
            long remaining = (this.cooldownEnd.get(id).get((Object)slot) - System.currentTimeMillis()) / 1000L;
            p.sendMessage(Msg.withPrefix("\u00a7cDu musst noch \u00a7f" + remaining + " s \u00a7cwarten, bevor du den \u00a76\u00a7l" + ArmorLockManager.displayName(slot) + " \u00a7cwieder sperren kannst."));
            return;
        }
        long until = System.currentTimeMillis() + (long)this.defaultMinutes * 60000L;
        this.lockEnd.computeIfAbsent(id, k -> new EnumMap(ArmorSlot.class)).put(slot, until);
        this.lastAnnouncedMinute.computeIfAbsent(id, k -> new EnumMap(ArmorSlot.class)).remove((Object)slot);
        this.savePlayerSlots(id);
        p.sendMessage(Msg.withPrefix("\u00a7eArmorLock aktiv f\u00fcr \u00a76\u00a7l" + ArmorLockManager.displayName(slot) + "\u00a7e: \u00a7f" + this.defaultMinutes + " min"));
    }

    public String remainingText(UUID id, ArmorSlot slot) {
        Long until = (Long)this.lockEnd.getOrDefault(id, new EnumMap(ArmorSlot.class)).get((Object)slot);
        if (until == null) {
            return "0 s";
        }
        long ms = Math.max(0L, until - System.currentTimeMillis());
        long totalSec = ms / 1000L;
        long min = totalSec / 60L;
        long sec = totalSec % 60L;
        return (String)(min > 0L ? min + " min " : "") + sec + " s";
    }

    public static ArmorSlot guessFromMaterial(Material m) {
        if (m == null) {
            return null;
        }
        String n = m.name();
        if (n.endsWith("_HELMET")) {
            return ArmorSlot.HELMET;
        }
        if (n.endsWith("_CHESTPLATE")) {
            return ArmorSlot.CHESTPLATE;
        }
        if (n.endsWith("_LEGGINGS")) {
            return ArmorSlot.LEGGINGS;
        }
        if (n.endsWith("_BOOTS")) {
            return ArmorSlot.BOOTS;
        }
        return null;
    }

    public static String displayName(ArmorSlot s) {
        return switch (s.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Helm";
            case 1 -> "Brustpanzer";
            case 2 -> "Hose";
            case 3 -> "Stiefel";
        };
    }

    private void startTicker() {
        if (this.tick != null) {
            this.tick.cancel();
        }
        this.tick = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.enabled) {
                return;
            }
            long now = System.currentTimeMillis();
            for (Map.Entry<UUID, EnumMap<ArmorSlot, Long>> en : this.lockEnd.entrySet()) {
                UUID id = en.getKey();
                Player p = Bukkit.getPlayer((UUID)id);
                EnumMap<ArmorSlot, Long> per = en.getValue();
                if (per == null || per.isEmpty()) continue;
                EnumMap announced = this.lastAnnouncedMinute.computeIfAbsent(id, k -> new EnumMap(ArmorSlot.class));
                for (Map.Entry<ArmorSlot, Long> slotEn : new EnumMap<ArmorSlot, Long>(per).entrySet()) {
                    Integer last;
                    ArmorSlot slot = slotEn.getKey();
                    long until = slotEn.getValue();
                    if (until <= now) {
                        per.remove((Object)slot);
                        announced.remove((Object)slot);
                        this.savePlayerSlots(id);
                        if (this.cooldownSeconds > 0) {
                            this.cooldownEnd.computeIfAbsent(id, k -> new EnumMap(ArmorSlot.class)).put(slot, now + (long)this.cooldownSeconds * 1000L);
                        }
                        if (p == null || !p.isOnline()) continue;
                        p.sendMessage(Msg.withPrefix("\u00a7aArmorLock f\u00fcr \u00a76\u00a7l" + ArmorLockManager.displayName(slot) + " \u00a7aist abgelaufen."));
                        continue;
                    }
                    long remainingSec = (until - now) / 1000L;
                    int minutes = (int)(remainingSec / 60L);
                    if (minutes != 5 && minutes != 3 || (last = (Integer)announced.get((Object)slot)) != null && last == minutes) continue;
                    announced.put(slot, minutes);
                    if (p == null || !p.isOnline()) continue;
                    p.sendMessage(Msg.withPrefix("\u00a77Du bist f\u00fcr den \u00a7f" + ArmorLockManager.displayName(slot) + " \u00a77noch \u00a7f" + minutes + " min " + remainingSec % 60L + " s \u00a77im ArmorLock."));
                }
            }
        }, 20L, 200L);
    }

    private void loadFromDisk() {
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
            if (this.cfg.isConfigurationSection("players")) {
                long now = System.currentTimeMillis();
                for (String suid : this.cfg.getConfigurationSection("players").getKeys(false)) {
                    try {
                        UUID id = UUID.fromString(suid);
                        EnumMap<ArmorSlot, Long> map = new EnumMap<ArmorSlot, Long>(ArmorSlot.class);
                        long h = this.cfg.getLong("players." + suid + ".HELMET", 0L);
                        long c = this.cfg.getLong("players." + suid + ".CHESTPLATE", 0L);
                        long l = this.cfg.getLong("players." + suid + ".LEGGINGS", 0L);
                        long b = this.cfg.getLong("players." + suid + ".BOOTS", 0L);
                        if (h > now) {
                            map.put(ArmorSlot.HELMET, h);
                        }
                        if (c > now) {
                            map.put(ArmorSlot.CHESTPLATE, c);
                        }
                        if (l > now) {
                            map.put(ArmorSlot.LEGGINGS, l);
                        }
                        if (b > now) {
                            map.put(ArmorSlot.BOOTS, b);
                        }
                        if (map.isEmpty()) continue;
                        this.lockEnd.put(id, map);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Konnte armorlock.yml nicht laden: " + e.getMessage());
        }
    }

    private void savePlayerSlots(UUID id) {
        if (this.cfg == null) {
            this.cfg = new YamlConfiguration();
        }
        EnumMap<ArmorSlot, Long> map = this.lockEnd.get(id);
        String base = "players." + String.valueOf(id);
        if (map == null || map.isEmpty()) {
            this.cfg.set(base, null);
        } else {
            this.cfg.set(base + ".HELMET", (Object)map.getOrDefault((Object)ArmorSlot.HELMET, 0L));
            this.cfg.set(base + ".CHESTPLATE", (Object)map.getOrDefault((Object)ArmorSlot.CHESTPLATE, 0L));
            this.cfg.set(base + ".LEGGINGS", (Object)map.getOrDefault((Object)ArmorSlot.LEGGINGS, 0L));
            this.cfg.set(base + ".BOOTS", (Object)map.getOrDefault((Object)ArmorSlot.BOOTS, 0L));
        }
        this.saveNow();
    }

    private void saveNow() {
        if (this.cfg == null) {
            return;
        }
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Konnte armorlock.yml nicht speichern: " + e.getMessage());
        }
    }

    public EnumMap<ArmorSlot, Long> getLockedSlots(UUID playerId) {
        return this.lockEnd.getOrDefault(playerId, new EnumMap(ArmorSlot.class));
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    public static enum ArmorSlot {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS;

    }
}

