/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RulesManager {
    private final JavaPlugin plugin;
    private File rulesFile;
    private FileConfiguration rulesConfig;

    public RulesManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadRules();
    }

    private void loadRules() {
        this.rulesFile = new File(this.plugin.getDataFolder(), "rules.yml");
        if (!this.rulesFile.exists()) {
            this.plugin.saveResource("rules.yml", false);
        }
        this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
    }

    public String getRulesText() {
        return this.rulesConfig.getString("rules", "Hier stehen noch keine Regeln.");
    }

    public void setRulesText(String text) {
        this.rulesConfig.set("rules", (Object)text);
        this.saveRules();
    }

    private void saveRules() {
        try {
            this.rulesConfig.save(this.rulesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

