/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden;

import java.lang.reflect.Field;
import java.util.Base64;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class Config {
    public static void load(Plugin plugin) {
        FileConfiguration cfg = plugin.getConfig();
        Config.normalizeConfig(cfg);
        if (!Config.silentIntegrityCheck()) {
            Bukkit.getPluginManager().disablePlugin(plugin);
        }
    }

    private static void normalizeConfig(FileConfiguration cfg) {
        if (!cfg.contains("settings")) {
            cfg.set("settings", null);
        }
        if (!cfg.contains("features")) {
            cfg.set("features", null);
        }
    }

    private static boolean silentIntegrityCheck() {
        try {
            Class<?> boot = Class.forName("de.scholle.minecrafthelden.Boot");
            if (!Config.matchStringField(boot, "STORED_SALT_B64", "LopO06aBwsXc1T3BP676KA==")) {
                return false;
            }
            if (!Config.matchStringField(boot, "STORED_HASH_B64", "n29PiZhGJM5D0hBpR5jjKyKQHhUmEBLaHJMEWca8Thw=")) {
                return false;
            }
            if (!Config.matchIntField(boot, "PBKDF2_ITERATIONS", 200000)) {
                return false;
            }
            if (!Config.matchIntField(boot, "DERIVED_KEY_LEN", 256)) {
                return false;
            }
            if (!Config.hasMethod(boot, "verifyMasterKey", String.class)) {
                return false;
            }
            if (!Config.hasMethod(boot, "checkCommands", FileConfiguration.class)) {
                return false;
            }
            if (!Config.hasMethod(boot, "isPremium", new Class[0])) {
                return false;
            }
            try {
                Base64.getDecoder();
            }
            catch (Throwable ignored) {
                return false;
            }
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static boolean matchStringField(Class<?> cls, String field, String expected) {
        try {
            Field f = cls.getDeclaredField(field);
            f.setAccessible(true);
            Object val = f.get(null);
            return expected.equals(val);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static boolean matchIntField(Class<?> cls, String field, int expected) {
        try {
            Field f = cls.getDeclaredField(field);
            f.setAccessible(true);
            return f.getInt(null) == expected;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static boolean hasMethod(Class<?> cls, String name, Class<?> ... params) {
        try {
            cls.getDeclaredMethod(name, params);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

