/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.external.carry;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.external.carry.SimpleCarryOn;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CarryTask
extends BukkitRunnable {
    private final SimpleCarryOn plugin;

    public CarryTask(SimpleCarryOn plugin) {
        this.plugin = plugin;
    }

    public void run() {
        for (UUID playerUUID : this.plugin.getCarriedVisualEntity().keySet().toArray(new UUID[0])) {
            Player player = this.plugin.getServer().getPlayer(playerUUID);
            Entity entity = this.plugin.getCarriedVisualEntity().get(playerUUID);
            if (!(entity instanceof BlockDisplay)) {
                this.plugin.getCarriedVisualEntity().remove(playerUUID);
                this.plugin.getCarriedData().remove(playerUUID);
                if (entity == null) continue;
                entity.remove();
                continue;
            }
            BlockDisplay blockDisplay = (BlockDisplay)entity;
            if (player == null || !player.isOnline()) {
                this.plugin.getCarriedVisualEntity().remove(playerUUID);
                this.plugin.getCarriedData().remove(playerUUID);
                blockDisplay.remove();
                continue;
            }
            Location targetLocation = player.getEyeLocation().add(player.getLocation().getDirection().multiply(0.8)).subtract(0.0, 0.6, 0.0);
            targetLocation.setYaw(player.getLocation().getYaw());
            targetLocation.setPitch(player.getLocation().getPitch());
            blockDisplay.teleport(targetLocation);
        }
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

