/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.graves;

import de.scholle.minecrafthelden.graves.GraveManager;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GraveGUI
implements Listener {
    private final GraveManager manager;
    private final GraveManager.GraveData data;
    private final Inventory inv;

    public GraveGUI(GraveManager manager, GraveManager.GraveData data) {
        this.manager = manager;
        this.data = data;
        Player owner = Bukkit.getPlayer((UUID)data.owner);
        this.inv = Bukkit.createInventory(null, (int)54, (String)("Grab von " + (owner != null ? owner.getName() : "Spieler")));
        for (int i = 0; i < data.items.size() && i < 54; ++i) {
            this.inv.setItem(i, data.items.get(i));
        }
    }

    public void open(Player p) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.manager.getPlugin());
        p.openInventory(this.inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (e.getInventory() != this.inv) {
            return;
        }
        if (!e.getWhoClicked().getUniqueId().equals(this.data.owner)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory() != this.inv) {
            return;
        }
        ArrayList<ItemStack> updated = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inv.getSize(); ++i) {
            if (this.inv.getItem(i) == null) continue;
            updated.add(this.inv.getItem(i));
        }
        this.manager.updateItems(this.data.stand, updated);
        HandlerList.unregisterAll((Listener)this);
    }
}

