/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.graves;

import de.scholle.minecrafthelden.MinecraftHelden;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class GraveManager {
    private final MinecraftHelden plugin;
    private final Map<UUID, GraveData> graves = new HashMap<UUID, GraveData>();

    public GraveManager(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    public void createGrave(Player p, Location loc, List<ItemStack> droppedItems) {
        boolean noGravity = this.plugin.getConfig().getBoolean("graves.armorstand_no_gravity", true);
        String holo = this.plugin.getConfig().getString("graves.hologram_text", "Grab von %player%").replace("%player%", p.getName());
        ArrayList<ItemStack> realItems = new ArrayList<ItemStack>(droppedItems);
        ArmorStand as = (ArmorStand)loc.getWorld().spawnEntity(loc.clone().add(0.0, -0.75, 0.0), EntityType.ARMOR_STAND);
        as.setInvisible(true);
        as.setInvulnerable(true);
        as.setGravity(!noGravity);
        as.setSmall(true);
        as.setCustomNameVisible(true);
        as.setCustomName(holo);
        as.setBasePlate(false);
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta sm = (SkullMeta)head.getItemMeta();
        sm.setOwningPlayer((OfflinePlayer)p);
        head.setItemMeta((ItemMeta)sm);
        as.getEquipment().setHelmet(head);
        this.graves.put(as.getUniqueId(), new GraveData(p.getUniqueId(), as, realItems));
    }

    public GraveData getGrave(ArmorStand as) {
        return this.graves.get(as.getUniqueId());
    }

    public void updateItems(ArmorStand as, List<ItemStack> updated) {
        GraveData d = this.graves.get(as.getUniqueId());
        if (d == null) {
            return;
        }
        d.items.clear();
        d.items.addAll(updated);
        if (!d.items.isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            GraveData d2 = this.graves.get(as.getUniqueId());
            if (d2 == null) {
                return;
            }
            if (d2.items.isEmpty()) {
                as.remove();
                this.graves.remove(as.getUniqueId());
            }
        }, 20L);
    }

    public void deleteGrave(ArmorStand as) {
        this.graves.remove(as.getUniqueId());
        as.remove();
    }

    public MinecraftHelden getPlugin() {
        return this.plugin;
    }

    public static class GraveData {
        public final UUID owner;
        public final ArmorStand stand;
        public final List<ItemStack> items;

        public GraveData(UUID owner, ArmorStand stand, List<ItemStack> items) {
            this.owner = owner;
            this.stand = stand;
            this.items = items;
        }
    }
}

