/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KeepInventoryListener
implements Listener {
    private final MinecraftHelden plugin;

    public KeepInventoryListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent e) {
        double keepPercentage;
        Player victim = e.getEntity();
        UUID id = victim.getUniqueId();
        boolean wasInCombat = this.plugin.combat().isInCombat(id);
        double d = keepPercentage = wasInCombat ? this.plugin.getConfig().getDouble("keepInventoryPercentageCombat", 0.5) : this.plugin.getConfig().getDouble("keepInventoryPercentageNatural", 0.0);
        if (keepPercentage <= 0.0) {
            return;
        }
        boolean gravesEnabled = this.plugin.getConfig().getBoolean("graves.enabled", true);
        boolean sendCoords = this.plugin.getConfig().getBoolean("graves.send_location_message", true);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(e.getDrops());
        drops.removeIf(i -> i == null);
        int filled = drops.size();
        int keepAmount = (int)Math.round((double)filled * keepPercentage);
        Collections.shuffle(drops);
        ArrayList kept = new ArrayList(drops.subList(0, keepAmount));
        ArrayList dropped = new ArrayList(drops.subList(keepAmount, drops.size()));
        e.getDrops().clear();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player p = Bukkit.getPlayer((UUID)id);
            if (p != null && p.isOnline()) {
                for (ItemStack item : kept) {
                    p.getInventory().addItem(new ItemStack[]{item});
                }
                Msg.send((CommandSender)p, "&aDu hast &f" + (int)(keepPercentage * 100.0) + "% &adeiner Items behalten.");
            }
        }, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (gravesEnabled && !dropped.isEmpty()) {
                this.plugin.getGraves().createGrave(victim, victim.getLocation(), dropped);
                if (sendCoords) {
                    Msg.send((CommandSender)victim, "&eDein Grab befindet sich bei &fX: " + victim.getLocation().getBlockX() + " Y: " + victim.getLocation().getBlockY() + " Z: " + victim.getLocation().getBlockZ());
                }
            }
        }, 2L);
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("Secure-Funktion fehlerhaft \u2013 Plugin deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("Secure konnte nicht gepr\u00fcft werden \u2013 Plugin deaktiviert.");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

