/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class CountdownManager {
    private final MinecraftHelden plugin;
    private final MiniMessage mm;
    private BossBar bar;
    private BukkitTask task;
    private boolean running;
    private int secondsLeft;
    private int totalSeconds;
    public static final int SCATTER_RADIUS = 2500;
    private final Random rnd;

    public CountdownManager(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.mm = MiniMessage.miniMessage();
        this.running = false;
        this.secondsLeft = 0;
        this.totalSeconds = 0;
        this.rnd = new Random();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start(int seconds) {
        this.stop();
        this.running = true;
        this.secondsLeft = seconds;
        this.totalSeconds = seconds;
        this.bar = Bukkit.createBossBar((String)"\u00a78\u00bb \u00a76\u00a7lMinecraft-Helden startet bald\u00a78 \u00ab", (BarColor)BarColor.YELLOW, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.bar.addPlayer(p);
        }
        this.updateBar();
        this.broadcastTitle("<gradient:#F59E0B:#F97316><bold>HELDEN STARTET</bold></gradient>", "<gray>In <gold>" + this.formatTime(this.secondsLeft) + "</gold></gray>", 500, 1000, 500);
        this.playAll(Sound.UI_TOAST_IN, 1.0f, 1.2f);
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.running) {
                return;
            }
            --this.secondsLeft;
            if (this.secondsLeft <= 0) {
                this.playAll(Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
                this.broadcastTitle("<gradient:#22C55E:#16A34A><bold>JETZT GEHT'S LOS!</bold></gradient>", "<gray>Viel Erfolg, Helden!</gray>", 300, 1200, 300);
                String prefix = "\u00a7f[\u00a76\u00a7l\u029c\u1d07\u029f\u1d05\u1d07\u0274\u00a7f] ";
                for (Player p2 : Bukkit.getOnlinePlayers()) {
                    p2.sendMessage(prefix + "\u00a7aMinecraft-Helden startet jetzt! \u00a77Viel Erfolg!");
                }
                this.fadeOutBar();
                this.scatterAllPlayers();
                this.running = false;
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
            } else {
                this.tickMessages();
                this.updateBar();
            }
        }, 20L, 20L);
    }

    public void stop() {
        this.running = false;
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.bar != null) {
            this.bar.removeAll();
            this.bar = null;
        }
    }

    private void updateBar() {
        if (this.bar == null) {
            return;
        }
        double progress = Math.max(0.0, Math.min(1.0, (double)this.secondsLeft / (double)Math.max(1, this.totalSeconds)));
        this.bar.setProgress(progress);
        this.bar.setTitle("\u00a78\u00bb \u00a76\u00a7lMinecraft-Helden\u00a77 beginnt in \u00a7f" + this.formatTime(this.secondsLeft) + " \u00a78\u00ab");
    }

    private void fadeOutBar() {
        if (this.bar == null) {
            return;
        }
        final BossBar b = this.bar;
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            int step = 10;

            @Override
            public void run() {
                if (this.step <= 0) {
                    b.removeAll();
                    return;
                }
                b.setProgress((double)this.step / 10.0);
                --this.step;
            }
        }, 1L, 1L);
    }

    private void tickMessages() {
        String prefix = "\u00a7f[\u00a76\u00a7l\u029c\u1d07\u029f\u1d05\u1d07\u0274\u00a7f] ";
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(prefix + "\u00a77Beginn in \u00a7e" + this.secondsLeft + "s\u00a77 \u2026");
        }
        if (this.secondsLeft == 120 || this.secondsLeft == 90 || this.secondsLeft == 60 || this.secondsLeft == 30) {
            this.broadcastTitle("<gold><bold>Minecraft-Helden</bold></gold>", "<gray>Beginnt in <yellow>" + this.formatTime(this.secondsLeft) + "</yellow></gray>", 300, 1100, 300);
            this.playAll(Sound.ENTITY_ENDER_DRAGON_GROWL, 0.8f, 0.9f);
        } else if (this.secondsLeft <= 10) {
            this.broadcastTitle("<gradient:#F59E0B:#F97316><bold>" + this.secondsLeft + "</bold></gradient>", "<gray>Bereit machen!</gray>", 0, 800, 200);
            this.playAll(Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f + (float)(10 - this.secondsLeft) * 0.03f);
        } else {
            this.playAll(Sound.BLOCK_NOTE_BLOCK_PLING, 0.6f, this.secondsLeft % 2 == 0 ? 1.6f : 1.8f);
        }
    }

    private void broadcastTitle(String mainMini, String subMini, int fadeInMs, int stayMs, int fadeOutMs) {
        Component main = this.mm.deserialize((Object)mainMini);
        Component sub = this.mm.deserialize((Object)subMini);
        Title.Times times = Title.Times.times((Duration)Duration.ofMillis(fadeInMs), (Duration)Duration.ofMillis(stayMs), (Duration)Duration.ofMillis(fadeOutMs));
        Title title = Title.title((Component)main, (Component)sub, (Title.Times)times);
        for (Player p : Bukkit.getOnlinePlayers()) {
            try {
                p.showTitle(title);
            }
            catch (Throwable throwable) {}
        }
    }

    private void playAll(Sound s, float vol, float pitch) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            try {
                p.playSound(p.getLocation(), s, SoundCategory.MASTER, vol, pitch);
            }
            catch (Throwable throwable) {}
        }
    }

    private String formatTime(int totalSec) {
        int m = totalSec / 60;
        int s = totalSec % 60;
        return (String)(m > 0 ? m + "m " : "") + s;
    }

    public void scatterAllPlayers() {
        final World w = CountdownManager.mainWorld();
        final ArrayList list = new ArrayList(Bukkit.getOnlinePlayers());
        if (list.isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){
            int idx = 0;

            @Override
            public void run() {
                if (this.idx >= list.size()) {
                    return;
                }
                Player p = (Player)list.get(this.idx++);
                Location loc = CountdownManager.this.randomSafeLocation(w, 2500, 12);
                if (loc != null) {
                    CountdownManager.this.teleportAndSettle(p, loc, true);
                }
            }
        }, 1L, 10L);
    }

    public static World mainWorld() {
        World w = Bukkit.getWorld((String)"world");
        return w != null ? w : (World)Bukkit.getWorlds().get(0);
    }

    public Location randomSafeLocation(World w, int radius, int tries) {
        int margin = 16;
        for (int i = 0; i < tries; ++i) {
            int x = this.rnd.nextInt((radius - margin) * 2 + 1) - (radius - margin);
            int z = this.rnd.nextInt((radius - margin) * 2 + 1) - (radius - margin);
            w.getChunkAt(x >> 4, z >> 4);
            int groundY = w.getHighestBlockYAt(x, z);
            Material below = w.getBlockAt(x, groundY, z).getType();
            Material head = w.getBlockAt(x, groundY + 1, z).getType();
            if (!below.isSolid() || this.isBad(head)) continue;
            return new Location(w, (double)x + 0.5, (double)groundY + 1.01, (double)z + 0.5);
        }
        Location sp = w.getSpawnLocation().clone();
        sp.setY((double)w.getHighestBlockYAt(sp.getBlockX(), sp.getBlockZ()) + 1.01);
        sp.setX((double)sp.getBlockX() + 0.5);
        sp.setZ((double)sp.getBlockZ() + 0.5);
        return sp;
    }

    private boolean isBad(Material m) {
        return m.isAir() || m == Material.CAVE_AIR || m == Material.LAVA || m == Material.WATER;
    }

    public void teleportAndSettle(Player p, Location to, boolean notify) {
        p.teleportAsync(to).thenAccept(success -> {
            if (!success.booleanValue()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                p.setFallDistance(0.0f);
                p.setVelocity(new Vector(0, 0, 0));
                p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 60, 0, true, false, false));
                if (notify) {
                    p.playSound(to, Sound.ENTITY_ENDERMAN_TELEPORT, SoundCategory.MASTER, 0.8f, 1.2f);
                    p.sendMessage("\u00a7f[\u00a76\u00a7l\u029c\u1d07\u029f\u1d05\u1d07\u0274\u00a7f] \u00a77Du wurdest zuf\u00e4llig in der Welt verteilt.");
                }
            });
        });
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

