/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.utils;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TabCompleteUtil {
    private static final List<String> ONE_TO_THREE = Arrays.asList("1", "2", "3");

    public static List<String> filter(String input, List<String> options) {
        String q = input.toLowerCase(Locale.ROOT);
        return options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(q)).collect(Collectors.toList());
    }

    private static List<String> onlinePlayers() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            list.add(p.getName());
        }
        return list;
    }

    public static List<String> completeHelden(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return TabCompleteUtil.filter(args[0], Arrays.asList("addlive", "removelive", "setlives", "checklives", "revive", "linkedheart", "nametags"));
        }
        String sub = args[0].toLowerCase(Locale.ROOT);
        if (sub.equals("nametags")) {
            if (args.length == 2) {
                return TabCompleteUtil.filter(args[1], Arrays.asList("on", "off"));
            }
            return Collections.emptyList();
        }
        if ((sub.equals("addlive") || sub.equals("removelive") || sub.equals("setlives") || sub.equals("checklives") || sub.equals("revive")) && args.length == 2) {
            return TabCompleteUtil.filter(args[1], TabCompleteUtil.onlinePlayers());
        }
        if ((sub.equals("addlive") || sub.equals("removelive") || sub.equals("setlives")) && args.length == 3) {
            return TabCompleteUtil.filter(args[2], ONE_TO_THREE);
        }
        if (sub.equals("linkedheart")) {
            if (args.length == 2) {
                return TabCompleteUtil.filter(args[1], Arrays.asList("start", "check", "auto"));
            }
            if (args.length == 3 && (args[1].equalsIgnoreCase("start") || args[1].equalsIgnoreCase("check"))) {
                return TabCompleteUtil.filter(args[2], TabCompleteUtil.onlinePlayers());
            }
            if (args.length == 4 && args[1].equalsIgnoreCase("start")) {
                return TabCompleteUtil.filter(args[3], TabCompleteUtil.onlinePlayers());
            }
        }
        return Collections.emptyList();
    }

    public static List<String> completeCombat(String[] args) {
        if (args.length == 1) {
            return TabCompleteUtil.filter(args[0], Arrays.asList("pvpon", "pvpoff"));
        }
        return Collections.emptyList();
    }

    public static List<String> completeDuel(CommandSender sender, Command cmd, String alias, String[] args, boolean hasPendingRequest) {
        if (args.length == 1) {
            if (hasPendingRequest) {
                return TabCompleteUtil.filter(args[0], Arrays.asList("accept", "cancel"));
            }
            return TabCompleteUtil.filter(args[0], new ArrayList<String>(TabCompleteUtil.onlinePlayers()));
        }
        if (args.length == 2 && !hasPendingRequest) {
            return TabCompleteUtil.filter(args[1], new ArrayList<String>(TabCompleteUtil.onlinePlayers()));
        }
        return Collections.emptyList();
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

