/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden;

import de.scholle.minecrafthelden.Boot;
import de.scholle.minecrafthelden.blocker.NetheriteBlocker;
import de.scholle.minecrafthelden.blocker.OpgapBlocker;
import de.scholle.minecrafthelden.blocker.TotemBlocker;
import de.scholle.minecrafthelden.commands.AnnounceCommand;
import de.scholle.minecrafthelden.commands.BigAnnounceCommand;
import de.scholle.minecrafthelden.commands.CombatCommand;
import de.scholle.minecrafthelden.commands.DuelCommand;
import de.scholle.minecrafthelden.commands.HeldenCommand;
import de.scholle.minecrafthelden.commands.LinkedHeartCommand;
import de.scholle.minecrafthelden.commands.SettingsCommand;
import de.scholle.minecrafthelden.external.FancyNPC.FancyNpcListener;
import de.scholle.minecrafthelden.external.InstaLeafDecay.BlockBreakEventListener;
import de.scholle.minecrafthelden.external.carry.CarryListener;
import de.scholle.minecrafthelden.external.carry.CarryTask;
import de.scholle.minecrafthelden.external.carry.SimpleCarryOn;
import de.scholle.minecrafthelden.gui.ReviveGUI;
import de.scholle.minecrafthelden.links.DiscordCommand;
import de.scholle.minecrafthelden.listeners.ArmorLockListener;
import de.scholle.minecrafthelden.listeners.CobwebListener;
import de.scholle.minecrafthelden.listeners.CombatCommandBlockListener;
import de.scholle.minecrafthelden.listeners.CombatListener;
import de.scholle.minecrafthelden.listeners.DeathListener;
import de.scholle.minecrafthelden.listeners.DuelListener;
import de.scholle.minecrafthelden.listeners.DummyListener;
import de.scholle.minecrafthelden.listeners.GlowLogoutListener;
import de.scholle.minecrafthelden.listeners.JoinListener;
import de.scholle.minecrafthelden.listeners.KeepInventoryListener;
import de.scholle.minecrafthelden.listeners.NametagListener;
import de.scholle.minecrafthelden.listeners.PlayerJoinListener;
import de.scholle.minecrafthelden.listeners.QuitListener;
import de.scholle.minecrafthelden.listeners.SpawnScatterListener;
import de.scholle.minecrafthelden.listeners.SpectatorBypassListener;
import de.scholle.minecrafthelden.listeners.TeleporterListener;
import de.scholle.minecrafthelden.manager.ArmorLockManager;
import de.scholle.minecrafthelden.manager.CobwebManager;
import de.scholle.minecrafthelden.manager.CombatManager;
import de.scholle.minecrafthelden.manager.CountdownManager;
import de.scholle.minecrafthelden.manager.DuelManager;
import de.scholle.minecrafthelden.manager.DummyManager;
import de.scholle.minecrafthelden.manager.GlowManager;
import de.scholle.minecrafthelden.manager.HeartsService;
import de.scholle.minecrafthelden.manager.NametagManager;
import de.scholle.minecrafthelden.manager.SettingsManager;
import de.scholle.minecrafthelden.manager.SpectatorBypassManager;
import de.scholle.minecrafthelden.pluginhub.PluginHUB;
import de.scholle.minecrafthelden.storage.LinkedHeartStore;
import de.scholle.minecrafthelden.storage.LivesStore;
import de.scholle.minecrafthelden.texturepack.TexturePackForce;
import de.scholle.minecrafthelden.utils.TextureGlyphs;
import de.scholle.minecrafthelden.webhooks.DiscordLogger;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MinecraftHelden
extends JavaPlugin {
    private LivesStore livesStore;
    private HeartsService heartsService;
    private LinkedHeartStore linkedHeartStore;
    private ReviveGUI reviveGUI;
    private SpectatorBypassManager spectatorBypassManager;
    private CombatManager combatManager;
    private DuelManager duelManager;
    private DummyManager dummyManager;
    private NametagManager nametagManager;
    private DiscordLogger discordLogger;
    private ArmorLockManager armorLockManager;
    private SimpleCarryOn benCarryOn;
    private CountdownManager countdownManager;
    private TexturePackForce texturePackForce;
    private SettingsManager settingsManager;
    private GlowManager glowManager;
    private CobwebManager cobwebManager;
    private NetheriteBlocker netheriteBlocker;
    private OpgapBlocker opgapBlocker;
    private TotemBlocker totemBlocker;

    public void onEnable() {
        PluginCommand bigannounce;
        PluginCommand announce;
        PluginCommand duel;
        PluginCommand combat;
        PluginCommand discord;
        this.saveDefaultConfig();
        this.getConfig().addDefault("startingLives", (Object)3);
        this.getConfig().addDefault("nametags.enabled", (Object)true);
        this.getConfig().addDefault("armorlock.enabled", (Object)true);
        this.getConfig().addDefault("armorlock.duration_seconds", (Object)600);
        this.getConfig().addDefault("armorlock.reminders_seconds", Arrays.asList(300, 180));
        this.getConfig().addDefault("randomTeleport.radius", (Object)5000);
        this.getConfig().addDefault("linkedheart.enabled", (Object)true);
        this.getConfig().addDefault("glowing", (Object)true);
        this.getConfig().addDefault("glow-interval-minutes", (Object)20);
        this.getConfig().addDefault("glow-duration-seconds", (Object)60);
        this.getConfig().addDefault("glow-lose-heart-on-logout", (Object)true);
        this.getConfig().addDefault("combat-log", (Object)"dummy");
        this.getConfig().addDefault("master-key", (Object)"");
        this.getConfig().options().copyDefaults(true);
        this.discordLogger = new DiscordLogger(this.getConfig().getString("webhooks.admin", ""), this.getConfig().getString("webhooks.kills", ""));
        this.saveConfig();
        Boot.verify((Plugin)this);
        TextureGlyphs.loadFromConfig((Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            int playerCount = Bukkit.getOnlinePlayers().size();
            if (playerCount > 10) {
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            }
        }, 100L, 100L);
        this.settingsManager = new SettingsManager(this);
        if (this.getConfig().getBoolean("InstaLeafDecay.enabled")) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakEventListener(), (Plugin)this);
            this.getLogger().info("InstaLeafDecay aktiviert!");
        } else {
            this.getLogger().info("InstaLeafDecay deaktiviert.");
        }
        this.livesStore = new LivesStore(this);
        this.heartsService = new HeartsService(this);
        this.linkedHeartStore = new LinkedHeartStore((Plugin)this);
        this.reviveGUI = new ReviveGUI(this);
        this.spectatorBypassManager = new SpectatorBypassManager(this);
        this.duelManager = new DuelManager(this);
        this.dummyManager = new DummyManager(this);
        this.nametagManager = new NametagManager(this);
        this.texturePackForce = new TexturePackForce(this);
        this.texturePackForce.start();
        this.glowManager = new GlowManager(this);
        this.combatManager = new CombatManager(this);
        this.netheriteBlocker = new NetheriteBlocker(this);
        this.opgapBlocker = new OpgapBlocker(this);
        this.totemBlocker = new TotemBlocker(this);
        PluginHUB pluginHub = new PluginHUB(this);
        this.cobwebManager = new CobwebManager(this.combatManager, this.getConfig().getInt("max-cobwebs-per-combat", 64));
        this.getServer().getPluginManager().registerEvents((Listener)new CobwebListener(this, this.cobwebManager), (Plugin)this);
        if (this.getConfig().getBoolean("armorlock.enabled", true)) {
            this.armorLockManager = new ArmorLockManager(this);
        }
        this.benCarryOn = new SimpleCarryOn(this);
        this.countdownManager = new CountdownManager(this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DeathListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SpectatorBypassListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CombatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DuelListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DummyListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FancyNpcListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NametagListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TeleporterListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CombatCommandBlockListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new KeepInventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GlowLogoutListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NetheriteBlocker(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OpgapBlocker(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TotemBlocker(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.netheriteBlocker, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.opgapBlocker, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.totemBlocker, (Plugin)this);
        if (this.armorLockManager != null) {
            this.getServer().getPluginManager().registerEvents((Listener)new ArmorLockListener(this), (Plugin)this);
        }
        if (this.getCommand("pluginhub") != null) {
            this.getCommand("pluginhub").setExecutor((CommandExecutor)pluginHub);
            this.getCommand("pluginhub").setTabCompleter((TabCompleter)pluginHub);
        }
        if (this.getCommand("phub") != null) {
            this.getCommand("phub").setExecutor((CommandExecutor)pluginHub);
            this.getCommand("phub").setTabCompleter((TabCompleter)pluginHub);
        }
        if (this.getCommand("license") != null) {
            this.getCommand("license").setExecutor((CommandExecutor)pluginHub);
            this.getCommand("license").setTabCompleter((TabCompleter)pluginHub);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new SpawnScatterListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CarryListener(this.benCarryOn), (Plugin)this);
        new CarryTask(this.benCarryOn).runTaskTimer((Plugin)this, 0L, 1L);
        PluginCommand helden = this.getCommand("helden");
        if (helden != null) {
            HeldenCommand cmd = new HeldenCommand(this);
            helden.setExecutor((CommandExecutor)cmd);
            helden.setTabCompleter((TabCompleter)cmd);
        }
        if ((discord = this.getCommand("discord")) != null) {
            discord.setExecutor((CommandExecutor)new DiscordCommand(this));
        }
        this.getCommand("settings").setExecutor((CommandExecutor)new SettingsCommand(this));
        PluginCommand linked = this.getCommand("linkedheart");
        if (linked != null) {
            linked.setExecutor((CommandExecutor)new LinkedHeartCommand(this));
        }
        if ((combat = this.getCommand("combat")) != null) {
            CombatCommand cc = new CombatCommand(this);
            combat.setExecutor((CommandExecutor)cc);
            combat.setTabCompleter((TabCompleter)cc);
        }
        if ((duel = this.getCommand("duel")) != null) {
            DuelCommand dc = new DuelCommand(this);
            duel.setExecutor((CommandExecutor)dc);
            duel.setTabCompleter((TabCompleter)dc);
        }
        if ((announce = this.getCommand("announce")) != null) {
            announce.setExecutor((CommandExecutor)new AnnounceCommand());
        }
        if ((bigannounce = this.getCommand("bigannounce")) != null) {
            bigannounce.setExecutor((CommandExecutor)new BigAnnounceCommand());
        }
        this.combatManager.start();
        this.heartsService.startTicker();
        this.dummyManager.start();
        boolean ntEnabled = this.getConfig().getBoolean("nametags.enabled", true);
        try {
            if (ntEnabled) {
                this.nametagManager.enable();
            } else {
                this.nametagManager.disable();
            }
            this.nametagManager.reapplyAllOnline();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.getServer().getOnlinePlayers().forEach(p -> {
                try {
                    if (this.spectatorBypassManager.hasBypassFlag((Player)p)) {
                        this.spectatorBypassManager.apply((Player)p);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getLogger().info("[Helden] Plugin aktiviert.");
    }

    public void onDisable() {
        if (this.texturePackForce != null) {
            this.texturePackForce.stop();
        }
        if (this.heartsService != null) {
            this.heartsService.stopTicker();
        }
        if (this.combatManager != null) {
            this.combatManager.shutdown();
        }
        if (this.dummyManager != null) {
            this.dummyManager.stop();
        }
        if (this.discordLogger != null) {
            this.discordLogger.shutdown();
        }
        if (this.armorLockManager != null) {
            this.armorLockManager.shutdown();
        }
        try {
            if (this.nametagManager != null) {
                this.nametags().enable();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.livesStore != null) {
            this.livesStore.saveNow();
        }
        if (this.linkedHeartStore != null) {
            this.linkedHeartStore.saveNow();
        }
        try {
            if (this.countdownManager != null) {
                this.countdownManager.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.glowManager = null;
        this.getLogger().info("[Helden] Plugin deaktiviert.");
    }

    public LivesStore lives() {
        return this.livesStore;
    }

    public HeartsService hearts() {
        return this.heartsService;
    }

    public LinkedHeartStore linkedHearts() {
        return this.linkedHeartStore;
    }

    public ReviveGUI reviveGui() {
        return this.reviveGUI;
    }

    public SpectatorBypassManager spectatorBypass() {
        return this.spectatorBypassManager;
    }

    public CombatManager combat() {
        return this.combatManager;
    }

    public DuelManager duels() {
        return this.duelManager;
    }

    public DummyManager dummies() {
        return this.dummyManager;
    }

    public NametagManager nametags() {
        return this.nametagManager;
    }

    public ArmorLockManager armorLock() {
        return this.armorLockManager;
    }

    public SettingsManager settingsManager() {
        return this.settingsManager;
    }

    public CountdownManager countdown() {
        return this.countdownManager;
    }

    public GlowManager glow() {
        return this.glowManager;
    }

    public CobwebManager cobwebs() {
        return this.cobwebManager;
    }

    public NetheriteBlocker netheriteBlocker() {
        return this.netheriteBlocker;
    }

    public OpgapBlocker opgapBlocker() {
        return this.opgapBlocker;
    }

    public TotemBlocker totemBlocker() {
        return this.totemBlocker;
    }

    public DiscordLogger discord() {
        return this.discordLogger;
    }

    public int randomTeleportRadius() {
        return Math.max(0, this.getConfig().getInt("randomTeleport.radius", 5000));
    }

    public boolean isLinkedHeartEnabled() {
        return this.getConfig().getBoolean("linkedheart.enabled", true);
    }
}

