/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.manager.CombatManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CobwebManager {
    private final CombatManager combatManager;
    private final int maxCobwebs;
    private final Map<UUID, Integer> placedCobwebs = new HashMap<UUID, Integer>();

    public CobwebManager(CombatManager combatManager, int maxCobwebs) {
        this.combatManager = combatManager;
        this.maxCobwebs = maxCobwebs;
    }

    public boolean canPlaceCobweb(Player player) {
        if (!this.combatManager.isInCombat(player.getUniqueId())) {
            return true;
        }
        int placed = this.placedCobwebs.getOrDefault(player.getUniqueId(), 0);
        return placed < this.maxCobwebs;
    }

    public void recordCobwebPlacement(Player player) {
        if (!this.combatManager.isInCombat(player.getUniqueId())) {
            return;
        }
        UUID uuid = player.getUniqueId();
        this.placedCobwebs.put(uuid, this.placedCobwebs.getOrDefault(uuid, 0) + 1);
    }

    public void resetCobwebs(UUID uuid) {
        this.placedCobwebs.remove(uuid);
    }

    public int getPlacedCobwebs(Player player) {
        return this.placedCobwebs.getOrDefault(player.getUniqueId(), 0);
    }

    public int getMaxCobwebs() {
        return this.maxCobwebs;
    }
}

