/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.external.carry;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.external.carry.SimpleCarryOn;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;

public class CarryListener
implements Listener {
    private final SimpleCarryOn plugin;
    private final List<Material> carriableBlocks = Arrays.asList(Material.CHEST, Material.SPAWNER);
    private final Set<EntityType> carriableMobs = EnumSet.of(EntityType.PIG, EntityType.SHEEP, EntityType.CHICKEN);

    public CarryListener(SimpleCarryOn plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!event.getAction().isRightClick() || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        if (this.isCarrying(player)) {
            event.setCancelled(true);
            this.placeCarriedObject(player, event);
            return;
        }
        if (event.getClickedBlock() != null && player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            if (!this.carriableBlocks.contains(event.getClickedBlock().getType())) {
                return;
            }
            event.setCancelled(true);
            BlockState blockState = event.getClickedBlock().getState();
            this.plugin.getCarriedData().put(player.getUniqueId(), blockState);
            this.createBlockDisplay(player, blockState);
            event.getClickedBlock().setType(Material.AIR);
            String nice = blockState.getType().name().toLowerCase().replace('_', ' ');
            Msg.send((CommandSender)player, "&7Du tr\u00e4gst jetzt &e" + nice + "&7.");
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        try {
            if (event.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!player.isSneaking()) {
            return;
        }
        if (this.isCarrying(player)) {
            return;
        }
        Entity clicked = event.getRightClicked();
        if (clicked == null) {
            return;
        }
        if (!this.carriableMobs.contains(clicked.getType())) {
            return;
        }
        event.setCancelled(true);
        boolean ok = player.addPassenger(clicked);
        if (!ok) {
            return;
        }
        this.plugin.getCarriedData().put(player.getUniqueId(), clicked);
        this.plugin.getCarriedVisualEntity().put(player.getUniqueId(), clicked);
        String nice = clicked.getType().name().toLowerCase().replace('_', ' ');
        Msg.send((CommandSender)player, "&7Du tr\u00e4gst jetzt &e" + nice + "&7.");
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.isCarrying(player)) {
            this.placeCarriedObject(player, null);
        }
    }

    private void placeCarriedObject(Player player, PlayerInteractEvent event) {
        Object carried = this.plugin.getCarriedData().get(player.getUniqueId());
        Entity visual = this.plugin.getCarriedVisualEntity().get(player.getUniqueId());
        if (carried == null) {
            return;
        }
        if (carried instanceof BlockState) {
            Block targetBlock;
            BlockState blockState = (BlockState)carried;
            if (visual instanceof BlockDisplay) {
                BlockDisplay bd = (BlockDisplay)visual;
                bd.remove();
            }
            if ((targetBlock = event != null && event.getClickedBlock() != null && event.getClickedBlock().getType().isSolid() ? event.getClickedBlock().getRelative(event.getBlockFace()) : player.getTargetBlock((Set)null, 5).getRelative(event != null ? event.getBlockFace() : null)) == null) {
                targetBlock = player.getLocation().add(player.getLocation().getDirection().multiply(1.5)).getBlock();
            }
            targetBlock.setType(blockState.getType());
            BlockState newState = targetBlock.getState();
            if (blockState instanceof CreatureSpawner) {
                CreatureSpawner oldSp = (CreatureSpawner)blockState;
                if (newState instanceof CreatureSpawner) {
                    CreatureSpawner newSp = (CreatureSpawner)newState;
                    newSp.setSpawnedType(oldSp.getSpawnedType());
                    newSp.setDelay(oldSp.getDelay());
                    newSp.update();
                }
            }
            if (blockState instanceof Container && newState instanceof Container) {
                ((Container)newState).getInventory().setContents(((Container)blockState).getInventory().getContents());
            }
            this.plugin.getCarriedData().remove(player.getUniqueId());
            this.plugin.getCarriedVisualEntity().remove(player.getUniqueId());
            Msg.send((CommandSender)player, "&aAbgestellt.");
            return;
        }
        if (carried instanceof Entity) {
            Entity mob = (Entity)carried;
            try {
                mob.leaveVehicle();
            }
            catch (Throwable targetBlock) {
                // empty catch block
            }
            Location drop = this.findSafeMobDrop(player);
            mob.teleport(drop);
            this.plugin.getCarriedData().remove(player.getUniqueId());
            this.plugin.getCarriedVisualEntity().remove(player.getUniqueId());
            Msg.send((CommandSender)player, "&aAbgestellt.");
        }
    }

    private void createBlockDisplay(Player player, BlockState blockState) {
        Location spawnLocation = player.getEyeLocation().add(player.getLocation().getDirection().multiply(1.2));
        BlockDisplay blockDisplay = (BlockDisplay)player.getWorld().spawn(spawnLocation, BlockDisplay.class, e -> {
            e.setBlock(blockState.getBlockData());
            Transformation transformation = e.getTransformation();
            float scale = 0.7f;
            transformation.getScale().set(0.7f);
            transformation.getTranslation().set(-0.35f, -0.35f, -0.35f);
            e.setTransformation(transformation);
        });
        this.plugin.getCarriedVisualEntity().put(player.getUniqueId(), (Entity)blockDisplay);
    }

    private boolean isCarrying(Player player) {
        return this.plugin.getCarriedData().containsKey(player.getUniqueId());
    }

    private Location findSafeMobDrop(Player player) {
        World w = player.getWorld();
        Location base = player.getLocation().add(player.getLocation().getDirection().multiply(1.2));
        int bx = base.getBlockX();
        int bz = base.getBlockZ();
        int maxR = 4;
        for (int r = 0; r <= maxR; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (Math.abs(dx) != r && Math.abs(dz) != r) continue;
                    int x = bx + dx;
                    int z = bz + dz;
                    int groundY = w.getHighestBlockYAt(x, z);
                    Block ground = w.getBlockAt(x, groundY, z);
                    Block space1 = w.getBlockAt(x, groundY + 1, z);
                    Block space2 = w.getBlockAt(x, groundY + 2, z);
                    if (!space1.getType().isAir() || !space2.getType().isAir() || ground.getType().isAir()) continue;
                    return new Location(w, (double)x + 0.5, (double)groundY + 1.0, (double)z + 0.5, player.getLocation().getYaw(), 0.0f);
                }
            }
        }
        int gy = w.getHighestBlockYAt(base);
        return new Location(w, base.getX(), Math.max(base.getY(), (double)gy + 1.0), base.getZ(), player.getLocation().getYaw(), 0.0f);
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

