/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.texturepack;

import com.sun.net.httpserver.HttpServer;
import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public final class TexturePackForce {
    private final MinecraftHelden plugin;
    private HttpServer server;
    private File packFile;
    private int port;

    public TexturePackForce(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    public void start() {
        try {
            this.port = this.plugin.getConfig().getInt("texturepack.port", 8080);
            File pluginFolder = this.plugin.getDataFolder();
            if (!pluginFolder.exists()) {
                pluginFolder.mkdirs();
            }
            String packName = this.plugin.getConfig().getString("texturepack.default-pack", "texturepack.zip");
            this.packFile = new File(pluginFolder, packName);
            if (!this.packFile.exists()) {
                this.saveResource(packName);
            }
            if (!this.packFile.exists()) {
                this.plugin.getLogger().warning("[TexturePack] Default pack not found: " + packName);
                return;
            }
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/" + this.packFile.getName(), exchange -> {
                try (FileInputStream fis = new FileInputStream(this.packFile);
                     OutputStream os = exchange.getResponseBody();){
                    exchange.sendResponseHeaders(200, this.packFile.length());
                    fis.transferTo(os);
                }
            });
            this.server.start();
            this.plugin.getLogger().info("[TexturePack] Server running on port " + this.port + " for pack " + this.packFile.getName());
            if (this.plugin.getConfig().getBoolean("texturepack.force-on-join", true)) {
                Bukkit.getOnlinePlayers().forEach(this::applyPack);
                Bukkit.getPluginManager().registerEvents(new Listener(){

                    @EventHandler
                    public void onJoin(PlayerJoinEvent event) {
                        TexturePackForce.this.applyPack(event.getPlayer());
                    }
                }, (Plugin)this.plugin);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    private void applyPack(Player player) {
        try {
            byte[] hash = TexturePackForce.calculateSHA1(this.packFile);
            String url = "http://localhost:" + this.port + "/" + this.packFile.getName();
            player.setResourcePack(url, hash, "Applying Texture Pack: " + this.packFile.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] calculateSHA1(File file) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[8192];
            while ((read = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
    }

    private void saveResource(String resourceName) {
        try (InputStream in = this.plugin.getResource(resourceName);){
            if (in == null) {
                return;
            }
            File outFile = new File(this.plugin.getDataFolder(), resourceName);
            try (FileOutputStream out = new FileOutputStream(outFile);){
                in.transferTo(out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

