/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.manager.ArmorLockManager;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ArmorLockListener
implements Listener {
    private final MinecraftHelden plugin;
    private final Map<UUID, EnumSet<ArmorLockManager.ArmorSlot>> usedFreeSwap = new ConcurrentHashMap<UUID, EnumSet<ArmorLockManager.ArmorSlot>>();

    public ArmorLockListener(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    private boolean inCombat(Player p) {
        try {
            return this.plugin.combat() != null && this.plugin.combat().isInCombat(p.getUniqueId());
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void ensureFreeSwapResetIfNotCombat(Player p) {
        if (!this.inCombat(p)) {
            this.usedFreeSwap.remove(p.getUniqueId());
        }
    }

    private boolean hasUsedFreeSwap(UUID id, ArmorLockManager.ArmorSlot slot) {
        EnumSet<ArmorLockManager.ArmorSlot> set = this.usedFreeSwap.get(id);
        return set != null && set.contains((Object)slot);
    }

    private void markUsedFreeSwap(UUID id, ArmorLockManager.ArmorSlot slot) {
        this.usedFreeSwap.computeIfAbsent(id, k -> EnumSet.noneOf(ArmorLockManager.ArmorSlot.class)).add(slot);
    }

    private void messageLocked(Player p, ArmorLockManager.ArmorSlot slot) {
        String nice = this.plugin.armorLock().remainingText(p.getUniqueId(), slot);
        Msg.send((CommandSender)p, "&cDu hast f\u00fcr den &f" + ArmorLockManager.displayName(slot) + " &cnoch &f" + nice + " &cArmorLock.");
    }

    private ArmorLockManager.ArmorSlot slotFromItem(ItemStack it) {
        if (it == null) {
            return null;
        }
        return ArmorLockManager.guessFromMaterial(it.getType());
    }

    private ItemStack getEquipped(Player p, ArmorLockManager.ArmorSlot s) {
        if (s == null) {
            return null;
        }
        return switch (s) {
            default -> throw new MatchException(null, null);
            case ArmorLockManager.ArmorSlot.HELMET -> p.getInventory().getHelmet();
            case ArmorLockManager.ArmorSlot.CHESTPLATE -> p.getInventory().getChestplate();
            case ArmorLockManager.ArmorSlot.LEGGINGS -> p.getInventory().getLeggings();
            case ArmorLockManager.ArmorSlot.BOOTS -> p.getInventory().getBoots();
        };
    }

    private boolean sameType(ItemStack a, ItemStack b) {
        Material ta = a == null ? Material.AIR : a.getType();
        Material tb = b == null ? Material.AIR : b.getType();
        return ta == tb;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClick(InventoryClickEvent e) {
        HumanEntity whoClicked = e.getWhoClicked();
        if (!(whoClicked instanceof Player)) {
            return;
        }
        Player p = (Player)whoClicked;
        this.ensureFreeSwapResetIfNotCombat(p);
        if (!this.plugin.armorLock().isEnabled()) {
            return;
        }
        UUID id = p.getUniqueId();
        ClickType click = e.getClick();
        InventoryType.SlotType slotType = e.getSlotType();
        ItemStack cursor = e.getCursor();
        ItemStack current = e.getCurrentItem();
        if (slotType != InventoryType.SlotType.ARMOR) {
            if (click.isShiftClick()) {
                ArmorLockManager.ArmorSlot target = this.slotFromItem(current);
                if (target == null) {
                    return;
                }
                if (this.plugin.armorLock().isLocked(id, target)) {
                    e.setCancelled(true);
                    this.messageLocked(p, target);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)p).updateInventory());
                    return;
                }
                if (!this.inCombat(p)) {
                    return;
                }
                if (this.hasUsedFreeSwap(id, target)) {
                    e.setCancelled(true);
                    this.messageLocked(p, target);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)p).updateInventory());
                    return;
                }
                ItemStack beforeFinal = this.cloneOrNull(this.getEquipped(p, target));
                ArmorLockManager.ArmorSlot targetFinal = target;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    ItemStack after = this.getEquipped(p, targetFinal);
                    if (after != null && after.getType() != Material.AIR && !this.sameType(beforeFinal, after)) {
                        this.markUsedFreeSwap(id, targetFinal);
                        this.plugin.armorLock().startLock(p, targetFinal);
                    }
                });
            }
            return;
        }
        ArmorLockManager.ArmorSlot target = this.slotFromItem(cursor);
        if (target == null) {
            target = this.slotFromItem(current);
        }
        if (target == null) {
            return;
        }
        if (this.plugin.armorLock().isLocked(id, target)) {
            e.setCancelled(true);
            this.messageLocked(p, target);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)p).updateInventory());
            return;
        }
        if (!this.inCombat(p)) {
            return;
        }
        if (this.hasUsedFreeSwap(id, target)) {
            e.setCancelled(true);
            this.messageLocked(p, target);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)p).updateInventory());
            return;
        }
        ItemStack beforeFinal = this.cloneOrNull(this.getEquipped(p, target));
        ArmorLockManager.ArmorSlot slotFinal = target;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            ItemStack after = this.getEquipped(p, slotFinal);
            if (after != null && after.getType() != Material.AIR && !this.sameType(beforeFinal, after)) {
                this.markUsedFreeSwap(id, slotFinal);
                this.plugin.armorLock().startLock(p, slotFinal);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrag(InventoryDragEvent e) {
        HumanEntity whoClicked = e.getWhoClicked();
        if (!(whoClicked instanceof Player)) {
            return;
        }
        Player p = (Player)whoClicked;
        this.ensureFreeSwapResetIfNotCombat(p);
        if (!this.plugin.armorLock().isEnabled()) {
            return;
        }
        InventoryView view = e.getView();
        ItemStack dragged = e.getOldCursor();
        ArmorLockManager.ArmorSlot fromItem = this.slotFromItem(dragged);
        Iterator iterator = e.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int raw = (Integer)iterator.next();
            if (view.getSlotType(raw) != InventoryType.SlotType.ARMOR) continue;
            ArmorLockManager.ArmorSlot target = fromItem;
            if (target == null) {
                if (this.inCombat(p)) {
                    e.setCancelled(true);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)p).updateInventory());
                }
                return;
            }
            UUID id = p.getUniqueId();
            if (this.plugin.armorLock().isLocked(id, target)) {
                e.setCancelled(true);
                this.messageLocked(p, target);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)p).updateInventory());
                return;
            }
            if (!this.inCombat(p)) {
                return;
            }
            if (this.hasUsedFreeSwap(id, target)) {
                e.setCancelled(true);
                this.messageLocked(p, target);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> ((Player)p).updateInventory());
                return;
            }
            ItemStack beforeFinal = this.cloneOrNull(this.getEquipped(p, target));
            ArmorLockManager.ArmorSlot targetFinal = target;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                ItemStack after = this.getEquipped(p, targetFinal);
                if (after != null && after.getType() != Material.AIR && !this.sameType(beforeFinal, after)) {
                    this.markUsedFreeSwap(id, targetFinal);
                    this.plugin.armorLock().startLock(p, targetFinal);
                }
            });
        }
    }

    private ItemStack cloneOrNull(ItemStack is) {
        return is == null ? null : is.clone();
    }
}

