/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class RulesManager {
    private final JavaPlugin plugin;
    private File rulesFile;
    private FileConfiguration rulesConfig;

    public RulesManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadRules();
    }

    private void loadRules() {
        this.rulesFile = new File(this.plugin.getDataFolder(), "rules.yml");
        if (!this.rulesFile.exists()) {
            this.plugin.saveResource("rules.yml", false);
        }
        this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
    }

    public String getRulesText() {
        return this.rulesConfig.getString("rules", "Hier stehen noch keine Regeln.");
    }

    public void setRulesText(String text) {
        this.rulesConfig.set("rules", (Object)text);
        this.saveRules();
    }

    private void saveRules() {
        try {
            this.rulesConfig.save(this.rulesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

