/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.manager;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.utils.Msg;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpawnScatterManager {
    private final MinecraftHelden plugin;
    private final Random rnd = new Random();
    private static final int RANGE = 2500;
    private static final int MARGIN = 32;
    private static final int MAX_TRIES = 40;
    private static final Set<Material> BAD_TOP = EnumSet.of(Material.WATER, new Material[]{Material.KELP, Material.KELP_PLANT, Material.SEAGRASS, Material.TALL_SEAGRASS, Material.LAVA, Material.MAGMA_BLOCK, Material.CACTUS, Material.SWEET_BERRY_BUSH, Material.POWDER_SNOW, Material.FIRE, Material.SOUL_FIRE});

    public SpawnScatterManager(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    public void scatterAllPlayersAsync(Collection<? extends Player> players, Runnable onDone) {
        ArrayDeque<Player> queue = new ArrayDeque<Player>(players);
        this.scatterNext(queue, onDone);
    }

    public void computeSafeLocationAsync(World world, Consumer<Location> callback) {
        if (world == null) {
            world = (World)Bukkit.getWorlds().get(0);
        }
        this.tryLocationAsync(world, 1, callback);
    }

    private void scatterNext(Queue<Player> queue, Runnable onDone) {
        Player p = queue.poll();
        if (p == null) {
            if (onDone != null) {
                onDone.run();
            }
            return;
        }
        World w = this.mainWorldOf(p);
        this.computeSafeLocationAsync(w, loc -> {
            if (loc == null) {
                loc = w.getSpawnLocation().add(0.5, 0.0, 0.5);
            }
            Location to = loc.clone();
            ((CompletableFuture)p.teleportAsync(to).thenRun(() -> {
                Msg.send((CommandSender)p, "&aDu wurdest zuf\u00e4llig teleportiert!");
                p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, SoundCategory.MASTER, 0.6f, 1.2f);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.scatterNext(queue, onDone), 1L);
            })).exceptionally(ex -> {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.scatterNext(queue, onDone), 1L);
                return null;
            });
        });
    }

    private void tryLocationAsync(World w, int attempt, Consumer<Location> callback) {
        int z;
        int cz;
        if (attempt > 40) {
            callback.accept(null);
            return;
        }
        int x = this.rndCoord();
        int cx = x >> 4;
        CompletableFuture<?> fut = this.callChunkAtAsync(w, cx, cz = (z = this.rndCoord()) >> 4, true);
        if (fut != null) {
            fut.whenComplete((ignored, err) -> {
                if (err != null) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.tryLocationAsync(w, attempt + 1, callback));
                } else {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.evaluateSpotOrRetry(w, x, z, attempt, callback));
                }
            });
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                if (!w.isChunkLoaded(cx, cz)) {
                    w.getChunkAt(cx, cz);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.evaluateSpotOrRetry(w, x, z, attempt, callback);
        });
    }

    private void evaluateSpotOrRetry(World w, int x, int z, int attempt, Consumer<Location> callback) {
        int y = w.getHighestBlockYAt(x, z);
        if (y <= w.getMinHeight() + 1) {
            this.tryLocationAsync(w, attempt + 1, callback);
            return;
        }
        Block ground = w.getBlockAt(x, y - 1, z);
        if (!this.isGoodTop(ground)) {
            this.tryLocationAsync(w, attempt + 1, callback);
            return;
        }
        Location loc = new Location(w, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5);
        loc.setYaw(this.rnd.nextFloat() * 360.0f);
        loc.setPitch(0.0f);
        callback.accept(loc);
    }

    private boolean isGoodTop(Block b) {
        Waterlogged wlog;
        Material t = b.getType();
        if (BAD_TOP.contains(t)) {
            return false;
        }
        BlockData blockData = b.getBlockData();
        if (blockData instanceof Waterlogged && (wlog = (Waterlogged)blockData).isWaterlogged()) {
            return false;
        }
        return !t.toString().endsWith("_LEAVES") && t != Material.BEDROCK && t != Material.BARRIER && t != Material.END_PORTAL && t != Material.NETHER_PORTAL;
    }

    private int rndCoord() {
        int min = -2468;
        int max = 2468;
        return this.rnd.nextInt(4937) + -2468;
    }

    private World mainWorldOf(Player p) {
        World w = Bukkit.getWorlds().isEmpty() ? null : (World)Bukkit.getWorlds().get(0);
        return w != null ? w : p.getWorld();
    }

    private CompletableFuture<?> callChunkAtAsync(World w, int cx, int cz, boolean gen) {
        try {
            Method m = w.getClass().getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            Object fut = m.invoke((Object)w, cx, cz, gen);
            if (fut instanceof CompletableFuture) {
                CompletableFuture completableFuture = (CompletableFuture)fut;
                return completableFuture;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

