/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.commands;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.utils.Msg;
import de.scholle.minecrafthelden.utils.TabCompleteUtil;
import de.scholle.minecrafthelden.utils.TextureGlyphs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HeldenCommand
implements CommandExecutor,
TabCompleter {
    private final MinecraftHelden plugin;

    public HeldenCommand(MinecraftHelden plugin) {
        this.plugin = plugin;
    }

    private void adminLog(CommandSender actor, String usedCmd, String details) {
        try {
            if (this.plugin.discord() != null) {
                String name = actor != null ? actor.getName() : "Konsole";
                this.plugin.discord().adminCommand(name, usedCmd, details == null ? "" : details);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            Msg.send(sender, "&cNutze: /helden <addlive|removelive|setlives|checklives|revive|linkedheart|nametags|countdown|reload>");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("helden.admin")) {
                    Msg.send(sender, "&cDaf\u00fcr hast du keine Rechte.");
                    return true;
                }
                try {
                    this.plugin.reloadConfig();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    TextureGlyphs.loadFromConfig((Plugin)this.plugin);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                int r = 0;
                try {
                    r = this.plugin.randomTeleportRadius();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Msg.send(sender, "&aConfig neu geladen. &7Aktueller RTP-Radius: &e" + r + " &7Bl\u00f6cke.");
                return true;
            }
            case "countdown": {
                if (args.length < 2) {
                    Msg.send(sender, "&c/helden countdown <start [sekunden]|stop>");
                    return true;
                }
                String act = args[1].toLowerCase();
                if (act.equals("start")) {
                    int seconds = 120;
                    if (args.length >= 3) {
                        try {
                            seconds = Math.max(5, Integer.parseInt(args[2]));
                        }
                        catch (NumberFormatException ignored) {
                            Msg.send(sender, "&7Ung\u00fcltige Zahl, nutze Standard: &e120s");
                        }
                    }
                    this.plugin.countdown().start(seconds);
                    Msg.send(sender, "&aCountdown gestartet (&f" + seconds + "s&a).");
                } else if (act.equals("stop")) {
                    this.plugin.countdown().stop();
                    Msg.send(sender, "&cCountdown gestoppt.");
                } else {
                    Msg.send(sender, "&c/helden countdown <start [sekunden]|stop>");
                }
                return true;
            }
            case "addlive": {
                int addAmount;
                if (args.length != 3) {
                    Msg.send(sender, "&c/helden addlive <Spieler> <Anzahl>");
                    return true;
                }
                Player targetAdd = Bukkit.getPlayer((String)args[1]);
                if (targetAdd == null) {
                    Msg.send(sender, "&cSpieler nicht gefunden!");
                    return true;
                }
                try {
                    addAmount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    Msg.send(sender, "&cUng\u00fcltige Zahl!");
                    return true;
                }
                int currentAdd = this.plugin.lives().getLives(targetAdd.getUniqueId());
                this.plugin.lives().setLives(targetAdd.getUniqueId(), currentAdd + addAmount);
                Msg.send(sender, "&a" + targetAdd.getName() + " hat " + addAmount + " Herzen erhalten.");
                return true;
            }
            case "removelive": {
                int remAmount;
                if (args.length != 3) {
                    Msg.send(sender, "&c/helden removelive <Spieler> <Anzahl>");
                    return true;
                }
                Player targetRem = Bukkit.getPlayer((String)args[1]);
                if (targetRem == null) {
                    Msg.send(sender, "&cSpieler nicht gefunden!");
                    return true;
                }
                try {
                    remAmount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    Msg.send(sender, "&cUng\u00fcltige Zahl!");
                    return true;
                }
                int currentRem = this.plugin.lives().getLives(targetRem.getUniqueId());
                int setRem = Math.max(0, currentRem - remAmount);
                this.plugin.lives().setLives(targetRem.getUniqueId(), setRem);
                Msg.send(sender, "&a" + targetRem.getName() + " hat " + remAmount + " Herzen verloren.");
                return true;
            }
            case "setlives": {
                int value;
                if (args.length != 3) {
                    Msg.send(sender, "&c/helden setlives <Spieler> <Anzahl>");
                    return true;
                }
                Player targetSet = Bukkit.getPlayer((String)args[1]);
                if (targetSet == null) {
                    Msg.send(sender, "&cSpieler nicht gefunden!");
                    return true;
                }
                try {
                    value = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    Msg.send(sender, "&cUng\u00fcltige Zahl!");
                    return true;
                }
                this.plugin.lives().setLives(targetSet.getUniqueId(), value);
                Msg.send(sender, "&a" + targetSet.getName() + " hat nun " + value + " Herzen.");
                return true;
            }
            case "checklives": 
            case "check": {
                if (args.length != 2) {
                    Msg.send(sender, "&c/helden checklives <Spieler>");
                    return true;
                }
                Player targetCheck = Bukkit.getPlayer((String)args[1]);
                if (targetCheck == null) {
                    Msg.send(sender, "&cSpieler nicht gefunden!");
                    return true;
                }
                int lives = this.plugin.lives().getLives(targetCheck.getUniqueId());
                Msg.send(sender, "&a" + targetCheck.getName() + " hat &f" + lives + " &aHerzen.");
                return true;
            }
            case "linkedheart": {
                if (!this.plugin.isLinkedHeartEnabled()) {
                    Msg.send(sender, "&cLinkedHeart ist derzeit deaktiviert.");
                    return true;
                }
                if (args.length < 2) {
                    Msg.send(sender, "&c/helden linkedheart <start|check|<SpielerA> <SpielerB>>");
                    return true;
                }
                String lsub = args[1].toLowerCase();
                if (lsub.equals("start")) {
                    String mode = this.plugin.getConfig().getString("generate", "random").toLowerCase();
                    if (!mode.equals("random")) {
                        Msg.send(sender, "&cLinkedHearts k\u00f6nnen nur automatisch generiert werden, wenn generate: random eingestellt ist!");
                        return true;
                    }
                    this.plugin.linkedHearts().linkAllOnlineRandomly();
                    Msg.send(sender, "&aAlle Online-Spieler wurden zuf\u00e4llig verlinkt.");
                    return true;
                }
                if (lsub.equals("check")) {
                    String name;
                    if (args.length != 3) {
                        Msg.send(sender, "&c/helden linkedheart check <Spieler>");
                        return true;
                    }
                    Player t = Bukkit.getPlayer((String)args[2]);
                    if (t == null) {
                        Msg.send(sender, "&cSpieler nicht gefunden!");
                        return true;
                    }
                    UUID partner = this.plugin.linkedHearts().getPartner(t.getUniqueId());
                    String string = name = partner != null ? Bukkit.getOfflinePlayer((UUID)partner).getName() : null;
                    Msg.send(sender, (String)(partner != null ? "&aPartner: &f" + String.valueOf(name != null ? name : partner) : "&cKein Partner gesetzt."));
                    return true;
                }
                if (args.length == 3) {
                    Player a = Bukkit.getPlayer((String)args[1]);
                    Player b = Bukkit.getPlayer((String)args[2]);
                    if (a == null || b == null) {
                        Msg.send(sender, "&cBeide Spieler m\u00fcssen online sein!");
                        return true;
                    }
                    UUID aId = a.getUniqueId();
                    UUID bId = b.getUniqueId();
                    UUID oldA = this.plugin.linkedHearts().getPartner(aId);
                    UUID oldB = this.plugin.linkedHearts().getPartner(bId);
                    this.plugin.linkedHearts().startLink(aId, bId);
                    if (oldA != null && oldA != bId) {
                        this.plugin.linkedHearts().startLink(oldA, oldB != null ? oldB : oldA);
                    }
                    if (oldB != null && oldB != aId) {
                        this.plugin.linkedHearts().startLink(oldB, oldA != null ? oldA : oldB);
                    }
                    this.plugin.linkedHearts().saveNow();
                    Msg.send(sender, "&a" + a.getName() + " &7und &a" + b.getName() + " &7wurden manuell verlinkt.");
                    return true;
                }
                Msg.send(sender, "&c/helden linkedheart <start|check|<SpielerA> <SpielerB>>");
                return true;
            }
            case "revive": {
                if (args.length != 2) {
                    Msg.send(sender, "&c/helden revive <Spieler>");
                    return true;
                }
                OfflinePlayer off = Bukkit.getOfflinePlayer((String)args[1]);
                if (off == null || off.getName() == null && !off.hasPlayedBefore()) {
                    Msg.send(sender, "&cSpieler nicht gefunden!");
                    return true;
                }
                int startLives = this.plugin.getConfig().getInt("startingLives", 3);
                this.plugin.lives().setLives(off.getUniqueId(), startLives);
                Player online = off.getPlayer();
                if (online != null) {
                    try {
                        this.plugin.spectatorBypass().clear(online);
                    }
                    catch (Throwable bId) {
                        // empty catch block
                    }
                    Msg.send((CommandSender)online, "&aDu wurdest von einem Admin wiederbelebt (&f" + startLives + " &aHerzen)!");
                } else if (off.getName() != null) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("pardon " + off.getName()));
                }
                Msg.send(sender, "&a" + String.valueOf(off.getName() != null ? off.getName() : off.getUniqueId()) + " wurde wiederbelebt (&f" + startLives + " &aHerzen).");
                return true;
            }
            case "nametags": {
                if (args.length != 2) {
                    Msg.send(sender, "&c/helden nametags <on|off>");
                    return true;
                }
                String state = args[1].toLowerCase();
                if (state.equals("on")) {
                    this.plugin.nametags().enable();
                    Msg.send(sender, "&aNametags wurden aktiviert. &7(OPs sehen ohnehin alles)");
                } else if (state.equals("off")) {
                    this.plugin.nametags().disable();
                    Msg.send(sender, "&cNametags wurden deaktiviert. &7(Nur OPs sehen per Holo die Namen)");
                } else {
                    Msg.send(sender, "&c/helden nametags <on|off>");
                }
                return true;
            }
        }
        Msg.send(sender, "&cUnbekannter Subcommand!");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> out = new ArrayList<String>();
        if (args.length == 1) {
            out.add("addlive");
            out.add("removelive");
            out.add("setlives");
            out.add("checklives");
            out.add("linkedheart");
            out.add("revive");
            out.add("nametags");
            out.add("countdown");
            out.add("reload");
            return this.filter(out, args[0]);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("countdown")) {
            out.add("start");
            out.add("stop");
            return this.filter(out, args[1]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("countdown") && args[1].equalsIgnoreCase("start")) {
            out.add("120");
            out.add("180");
            out.add("300");
            return this.filter(out, args[2]);
        }
        try {
            return TabCompleteUtil.completeHelden(sender, cmd, alias, args);
        }
        catch (Throwable ignored) {
            return out;
        }
    }

    private List<String> filter(List<String> src, String token) {
        token = token == null ? "" : token.toLowerCase();
        ArrayList<String> r = new ArrayList<String>();
        for (String s : src) {
            if (!s.toLowerCase().startsWith(token)) continue;
            r.add(s);
        }
        return r;
    }
}

