/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.listeners;

import de.scholle.minecrafthelden.MinecraftHelden;
import de.scholle.minecrafthelden.Secure;
import de.scholle.minecrafthelden.utils.Msg;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class GameplayRestrictionsListener
implements Listener {
    private final MinecraftHelden plugin;
    private final Map<UUID, Long> lastWarn = new HashMap<UUID, Long>();
    private boolean disableNether;
    private boolean disableVillagerTrading;
    private boolean disableMaceDamage;

    public GameplayRestrictionsListener(MinecraftHelden plugin) {
        this.plugin = plugin;
        this.reloadSettings();
    }

    public void reloadSettings() {
        this.plugin.reloadConfig();
        this.disableNether = this.plugin.getConfig().getBoolean("nonether", true);
        this.disableVillagerTrading = this.plugin.getConfig().getBoolean("villagerTradingDisabled", true);
        this.disableMaceDamage = this.plugin.getConfig().getBoolean("disableMaceDamage", true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPortal(PlayerPortalEvent e) {
        if (!this.disableNether) {
            return;
        }
        if (e.getTo() != null && e.getTo().getWorld() != null && e.getTo().getWorld().getEnvironment() == World.Environment.NETHER) {
            e.setCancelled(true);
            this.sendOnce(e.getPlayer(), "&f[&6&lMinecraftHelden&f] &cDer Nether ist im Helden-Modus deaktiviert!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        if (!this.disableNether) {
            return;
        }
        if (e.getTo() != null && e.getTo().getWorld() != null && e.getTo().getWorld().getEnvironment() == World.Environment.NETHER) {
            e.setCancelled(true);
            this.sendOnce(e.getPlayer(), "&f[&6&lMinecraftHelden&f] &cDer Nether ist im Helden-Modus deaktiviert!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onOpenMerchant(InventoryOpenEvent e) {
        if (!this.disableVillagerTrading) {
            return;
        }
        HumanEntity player = e.getPlayer();
        if (player instanceof Player) {
            Player p = (Player)player;
            if (e.getInventory().getType() == InventoryType.MERCHANT) {
                e.setCancelled(true);
                this.sendOnce(p, "&f[&6&lMinecraftHelden&f] &cVillager-Handel ist im Helden-Modus deaktiviert!");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMaceDamage(EntityDamageByEntityEvent e) {
        Projectile proj;
        ProjectileSource shooter;
        if (!this.disableMaceDamage) {
            return;
        }
        Player attacker = null;
        Entity damager = e.getDamager();
        if (damager instanceof Player) {
            Player player2;
            attacker = player2 = (Player)damager;
        } else if (damager instanceof Projectile && (shooter = (proj = (Projectile)damager).getShooter()) instanceof Player) {
            Player player;
            attacker = player = (Player)shooter;
        }
        if (attacker == null) {
            return;
        }
    }

    private void sendOnce(Player p, String msg) {
        if (p == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Long last = this.lastWarn.get(p.getUniqueId());
        if (last == null || now - last >= 1000L) {
            this.lastWarn.put(p.getUniqueId(), now);
            p.sendMessage(Msg.comp(msg));
        }
    }

    public void loadConfigChecks(MinecraftHelden plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[Helden] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[Helden] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

