/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.minecrafthelden.blocker;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CrystalBlocker
extends JavaPlugin
implements Listener {
    private boolean disableCrystalPvp;
    private boolean disableAnchorPvp;
    private long crystalCooldown;
    private long anchorCooldown;
    private final Map<UUID, Long> lastCrystalDamage = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastAnchorDamage = new HashMap<UUID, Long>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("CrystalBlocker aktiviert!");
    }

    private void loadConfig() {
        FileConfiguration cfg = this.getConfig();
        this.disableCrystalPvp = cfg.getBoolean("disablecrystalpvp");
        this.disableAnchorPvp = cfg.getBoolean("diasbleanchorpvp");
        this.crystalCooldown = cfg.getLong("crystalcooldown", 60L) * 1000L;
        this.anchorCooldown = cfg.getLong("anchorcooldown", 60L) * 1000L;
    }

    @EventHandler
    public void onAnchorClick(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.RESPAWN_ANCHOR) {
            return;
        }
        UUID id = e.getPlayer().getUniqueId();
        this.lastAnchorDamage.putIfAbsent(id, 0L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCrystalDamage(EntityDamageByEntityEvent e) {
        long last;
        if (e.getDamager().getType() != EntityType.ENDER_CRYSTAL) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        UUID id = p.getUniqueId();
        if (this.disableCrystalPvp) {
            e.setCancelled(true);
            return;
        }
        long now = System.currentTimeMillis();
        if (now - (last = this.lastCrystalDamage.getOrDefault(id, 0L).longValue()) < this.crystalCooldown) {
            e.setCancelled(true);
            return;
        }
        this.lastCrystalDamage.put(id, now);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAnchorExplosionDamage(EntityDamageEvent e) {
        long last;
        if (e.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && e.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        UUID id = p.getUniqueId();
        if (this.disableAnchorPvp) {
            e.setCancelled(true);
            return;
        }
        long now = System.currentTimeMillis();
        if (now - (last = this.lastAnchorDamage.getOrDefault(id, 0L).longValue()) < this.anchorCooldown) {
            e.setCancelled(true);
            return;
        }
        this.lastAnchorDamage.put(id, now);
    }
}

